/*****************************************************************
NotUnderstood.java
GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/


package madkit.fipa.agMgmt;
/** 
* 
* @see jade.domain.agMgmt.FIPAManagementOntology
* @author Fabio Bellifemine - CSELT S.p.A.
* @version $Date: 2007/10/31 13:03:27 $ $Revision: 1.2 $
*/

import madkit.fipa.FIPAException;
import madkit.messages.ACLMessage;

public class NotUnderstoodException extends FIPAException {

  public NotUnderstoodException(String msg) {
    super(msg);
  }

  public ACLMessage getACLMessage() {
    if (msg == null) {
      msg = new ACLMessage(ACLMessage.NOT_UNDERSTOOD);
      msg.setContent("("+getMessage()+")"); //in SL-0 it must be a t-uple
    } else
      msg.setPerformative(ACLMessage.NOT_UNDERSTOOD);
    return msg;
  }
}
