/*****************************************************************
ExceptionVocabulary.java

GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/


package madkit.fipa.agMgmt;

public interface ExceptionVocabulary {
	
  /**
    A symbolic constant, containing the name of this ontology.
  */
  public static final String NAME = "Exception";

  // Not-understood Exception Predicates
  public static final String UNSUPPORTEDACT = "unsupported-act";
  public static final String UNSUPPORTEDACT_ACT = "act";	
  
  public static final String UNEXPECTEDACT = "unexpected-act";
  public static final String UNEXPECTEDACT_ACT = "act";
  
  public static final String UNSUPPORTEDVALUE = "unsupported-value";
  public static final String UNSUPPORTEDVALUE_VALUE = "value";
    
  public static final String UNRECOGNISEDVALUE = "unrecognised-value";
  public static final String UNRECOGNISEDVALUE_VALUE = "value";	
  
  // Refusal Exception Predicates
  public static final String UNAUTHORISED = "unauthorised";
  
  public static final String UNSUPPORTEDFUNCTION = "unsupported-function";
  public static final String UNSUPPORTEDFUNCTION_FUNCTION = "function";
  
  public static final String MISSINGARGUMENT = "missing-argument";
  public static final String MISSINGARGUMENT_ARGUMENT = "argument-name";
  
  public static final String UNEXPECTEDARGUMENT = "unexpected-argument";
  public static final String UNEXPECTEDARGUMENT_ARGUMENT = "argument-name";
  
  public static final String UNEXPECTEDARGUMENTCOUNT = "unexpected-argument-count";

  public static final String MISSINGPARAMETER = "missing-parameter";
  public static final String MISSINGPARAMETER_OBJECT_NAME    = "object-name";	
  public static final String MISSINGPARAMETER_PARAMETER_NAME = "parameter-name";

  public static final String UNEXPECTEDPARAMETER = "unexpected-parameter";
  public static final String UNEXPECTEDPARAMETER_OBJECT_NAME = "object-name";
  public static final String UNEXPECTEDPARAMETER_PARAMETER_NAME = "parameter-name";
  
  public static final String UNRECOGNISEDPARAMETERVALUE = "unrecognised-parameter-value";
  public static final String UNRECOGNISEDPARAMETERVALUE_PARAMETER_NAME = "parameter-name";
  public static final String UNRECOGNISEDPARAMETERVALUE_PARAMETER_VALUE = "parameter-value";

  // Failure Exception Predicates
  public static final String INTERNALERROR = "internal-error";  
  public static final String INTERNALERROR_MESSAGE = "error-message";	

}
