/*****************************************************************
FIPANames.java

GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/

package madkit.fipa;

/**
 * This class provides a single access point for the
 *  set of constants
 * already defined by FIPA.
 * The constants have been grouped by category (i.e. ACLCodecs, 
 * Content Languages, MTPs, ...), with one inner class implementing each
 * category.
 * @author Fabio Bellifemine - TILab
 * @version $Date: 2004/02/15 15:44:18 $ $Revision: 1.1 $
 **/

public interface FIPANames {
    /**
     * Set of constants that identifies the Codec of ACL Messages and
     * that can be assigned via 
     * <code> ACLMessage.getEnvelope().setAclRepresentation(FIPANames.ACLCodec.BITEFFICIENT); </code>
     **/
    public static interface ACLCodec {
	/** Syntactic representation of ACL in string form 
	 * @see <a href=http://www.fipa.org/specs/fipa00070/XC00070f.html>FIPA Spec</a>
	 **/
	public static final String STRING = "fipa.acl.rep.string.std";
	/** Syntactic representation of ACL in XML form
	 * @see <a href=http://www.fipa.org/specs/fipa00071/XC00071b.html>FIPA Spec</a>
	 **/
	public static final String XML = "fipa.acl.rep.xml.std";
	/** Syntactic representation of ACL in XML form
	 * @see <a href=http://www.fipa.org/specs/fipa00069/XC00069e.html>FIPA Spec</a>
	 **/
	public static final String BITEFFICIENT = "fipa.acl.rep.bitefficient.std"; 
    }

    /**
     * Set of constants that identifies the Interaction Protocols and that
     * can be assigned via
     * <code>ACLMessage.setProtocol(FIPANames.InteractionProtocol.FIPA_REQUEST)
     * </code>
     **/
    public static interface InteractionProtocol {
	    //achieve rational effect protocol
	    public static final String FIPA_REQUEST = "fipa-request";
	    public static final String FIPA_QUERY =  "fipa-query" ;
			public static final String FIPA_REQUEST_WHEN = "fipa-request-when";
			public static final String FIPA_BROKERING = "fipa-brokering";
			public static final String FIPA_RECRUITING = "fipa-recruiting";
			public static final String FIPA_PROPOSE = "fipa-propose";
			public static final String FIPA_SUBSCRIBE = "fipa-subscribe";
			
			//auction protocol
			public static final String FIPA_ENGLISH_AUCTION = "fipa-auction-english";
			public static final String FIPA_DUTCH_AUCTION = "fipa-auction-dutch";
		
		
			public static final String FIPA_CONTRACT_NET = "fipa-contract-net";  
			public static final String FIPA_ITERATED_CONTRACT_NET = "fipa-iterated-contract-net";
    }

    /**
     * Set of constants that identifies the content languages and that 
     * can be assigned via
     * <code>ACLMessage.setLanguage(FIPANames.ContentLanguage.SL0)
     * </code>
     **/
    public static interface ContentLanguage {
	public static final String FIPA_SL0 = "fipa-sl0";
	public static final String FIPA_SL1 = "fipa-sl1";
	public static final String FIPA_SL2 = "fipa-sl2";
	public static final String FIPA_SL  = "fipa-sl";
    }

    /**
     * Set of constants that identifies the Message Transport Protocols. 
     **/
    public static interface MTP {
	/**
	 * IIOP-based MTP
	 * @see <a href=http://www.fipa.org/specs/fipa00075/XC00075e.html>FIPA Spec</a>
	 **/
	public static final String IIOP = "fipa.mts.mtp.iiop.std";
	/**
	 * WAP-based MTP
	 * @see <a href=http://www.fipa.org/specs/fipa00076/XC00076c.html>FIPA Spec</a>
	 **/
	public static final String WAP = "fipa.mts.mtp.wap.std";
	/**
	 * HTTP-based MTP
	 * @see <a href=http://www.fipa.org/specs/fipa00084/XC00084d.html>FIPA Spec</a>
	 **/
	public static final String HTTP = "fipa.mts.mtp.http.std";
    }
}
