/*****************************************************************
FIPAException.java

GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/

package madkit.fipa;

import madkit.fipa.content.Predicate;
import madkit.messages.ACLMessage;

/**
This class represents a generic FIPAException, i.e. one of NotUnderstood,Failure,Refuse, as defined in <code>jade.domain.FIPAAgentManagement</code>.
It has two constructors, one based on an ACLMessage, and the second based
on its content, i.e. the exception message.
@author Giovanni Rimassa - Universita` di Parma
@version $Date: 2007/10/31 13:04:10 $ $Revision: 1.2 $
*/

public class FIPAException extends Exception implements Predicate {

	/**
  @serial
  */
  protected ACLMessage msg; // can be accessed by subclasses
  /**
  @serial
  */
  private String content;

  /**
   * constructs a generic FIPAException. The ACLMessage performative is
   * defaulted to not-understood.
   * @param message is the content of the ACLMessage
  **/
  public FIPAException(String message) {
    super();
    content = message;
  }

  /**
   * @param message is the ACLMessage representing this exception
   **/
  public FIPAException(ACLMessage message) {
    this(message.getContent());
    msg=(ACLMessage)message.clone();
  }

  /**
   * @return the ACLMessage representing this exception
   **/
  public ACLMessage getACLMessage() {
    if (msg == null) {
      msg = new ACLMessage(ACLMessage.NOT_UNDERSTOOD);
      msg.setContent(getMessage());
    }
    return msg;
  }

  /**
   * set the content of the ACLMessage representing this exception
   * @param message is the content
   **/
  protected void setMessage(String message) {
    content=message;
    if (msg!=null)
      msg.setContent(message);
  }

  /**
   * get the content of the ACLMessage representing this exception
   **/
  public String getMessage() {
    return content;
  }
}



