/*
* AMS.java
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/package madkit.fipa.AMS;

import java.util.Vector;
import java.util.Enumeration;
import madkit.fipa.agMgmt.*;
import madkit.fipa.content.*;
import madkit.fipa.lang.acl.*;
import madkit.fipa.content.lang.*;
//import madkit.fipa.content.lang.CodecException;
import madkit.fipa.content.lang.sl.*;
import madkit.fipa.content.onto.*;
import madkit.fipa.content.abs.*;


// L'AMS est l'agent qui gre le cycle de vie des agents FIPA sur une plate-forme donne. Il est unique.
// Un AMS est charg d'enreregistrer les agents et de maintenir une table des AID des agfents FIPA prsents sur la plate-forme.
public class AMS extends FIPAAgent{


	//L'AMS connait sa plate-forme :
	private APDescription theProfile = new APDescription();
  
	// On donne   notre agent la facult de parler. Le codec pr le language SL :
	//  private Codec codec = new SLCodec();

	// L'AMS maintien une table de tous les agents FIPA de la Plate-forme ainsi que leur tat
	Vector vector_agentNames;

	String aFaire = null; // String qui donne l'action et les arguments

	//Lors de son initialisation l'AMS...
	public void activate()
	{
		
		// L'AMS construit une description de la plate-forme sur laquelle il se trouve
		//theProfile.setName(currentKernel.getName());
		name = new AID("ams@madkit.fr");
		// Puis il s'enregistre en tant que service de cet AP
		//APService AMSService = new APService();
		// AMSService.setName
		//theProfile.
		println("cool");
		
		Codec slc = new SLCodec();
		
		Ontology onto = FIPAManagementOntology.getInstance();
		
		getContentManager().registerLanguage(slc);
		getContentManager().registerOntology(onto);
		
		ACLMessage hello = new ACLMessage(ACLMessage.REQUEST);
		hello.setSender(this.name);
		hello.addReceiver(new AID("cool"));
		hello.setLanguage(slc.getName());
		hello.setOntology(onto.getName());
		//AlreadyRegistered ar = new AlreadyRegistered();
		
		Action action = new Action();
		Register register = new Register();
		AMSAgentDescription nag = new AMSAgentDescription();
		nag.setName(new AID("discovery-agent@foo.com"));
		nag.setState("active");
		register.setDescription(nag);
		
		
		//println(hello.getPerformative(hello.getPerformative()));
		try{
			getContentManager().fillContent(hello,register);
		}
		catch (Exception ce){
			println("C_erreur");
			ce.printStackTrace();
		}
		
		println("vie " +hello.getContent());
		
		ACLCodec acdc = new StringACLCodec();
		println("yo "+((StringACLCodec)acdc).toString(hello));
		
		
		
		try{
			ContentElement el = getContentManager().extractContent(hello);
			if (el==null)
				println("null");
			else if (el instanceof Register) println("register");
		}
		catch (Exception ce){
			println("C_erreur  2\n" + ce.toString());
			
		}
		
		
		
		
		
	}
	
	// Lors de sa vie il ne fait que traiter les msg qui lui sont envoys
	// Il faut 
	final public void live()
	{
		
		
		/*
		while(true)
		{
			Message e = waitNextMessage();
			handleMessage(e);
			
		}*/
	}
	
	
	//Il faut dcoder le message
	final synchronized void handleMessage()
	{
		/*
		switch (typeMessage)
			case register
			case deregister
			case search
			case modify
			case */
	}

	//Les agents FIPA doivent demander  s'enregistrer auprs de l'AMS. il leur renvoie un msg contenant leur AID
	//ou un message expliquant le rejet de la demande
	public AID register(String name)
	{
		AID newId;
		if(existAid(name))
		{
			newId=null;
		}
		else
		{
			newId= new AID(name);
		}
		return newId;
	}
	
	//Quand un agent meurt ou migre vers une autre plate-forme, il est supprim de la table des agents 
	public void deregister(String n)
	{
		int i = 0;
        for (Enumeration e = vector_agentNames.elements() ; e.hasMoreElements() ;)
		{
			if(((AID)e.nextElement()).getName().equals(n))
         	{
         		vector_agentNames.removeElementAt(i);
         		break;
    		}
    		i++;
    	} 
    }
	
	

	
	// permet de savoir si un AID n'existe pas dj. 2 AID sont quivalents si leur paramtre nom est le mme.
	public boolean existAid(String n)
	{
		boolean reponse=false;
		for (Enumeration e = vector_agentNames.elements() ; e.hasMoreElements() ;)
		{
         	if(((AID)e.nextElement()).getName().equals(n))
         	{
         		reponse=true;
         		break;
    		}
    	} 
    	return reponse;
    }


/*
modify();
search();


public APDescription getAPDescription(){return theProfile;}

//*****Pour dchiffrer le message SL

	public void absActionExp(AbsAgentAction aaa){
		println("*** action ***");
		AbsConcept agent = (AbsConcept) aaa.getAbsObject("agent");
		absAgent(agent);
		
		AbsTerm ft_register = aaa.getAbsTerm("functionTerm");
		absFT(ft_register);
	}
	


	public void absAgent(AbsConcept agent){
		// un agent 
		AbsConcept functionTerm = (AbsConcept)agent.getAbsObject("functionTerm");
		absFT(functionTerm);
	}	
	
	public void absFT(AbsTerm ft){
		//System.out.println(ft.getNames()[0]);
		AbsTerm sous_ft=null;
		if (ft.getNames()[0].equals("normal FT")){
			sous_ft = ((AbsConcept)ft).getAbsTerm("normal FT");
			absNormalFT(sous_ft);
		}else{
			sous_ft = ((AbsConcept)ft).getAbsTerm("named FT");
			absNamedFT(sous_ft);
		}
	}
	
	public void absNamedFT(AbsTerm namedFT){
	 	String fs_re = namedFT.getAbsObject("functionSymbol").toString().trim();
	 	if(fs_re.equals("ams-agent-description"))aFaire += fs_re+" ";
		println(fs_re);
		//Un nameFT est conpos d'un functionSymbol et de 1 ou pls parametres
		for(int i = 1; i <namedFT.getCount();i++){
			AbsConcept parametre = (AbsConcept) namedFT.getAbsObject("parameter"+i);
			absParameter(parametre);
		}
	}
	
	public void absNormalFT(AbsTerm normalFT){
	 	String fs_re = normalFT.getAbsObject("functionSymbol").toString().trim();
		if(fs_re.equals("register"))aFaire= fs_re+" ";
		if(fs_re.equals("deregister"))aFaire= fs_re+" ";
		println(fs_re);
		// Un normal FT est compos d'un func Symbol et de 0 ou pls term
		AbsConcept ft = (AbsConcept) normalFT.getAbsObject(normalFT.getNames()[1]);
		absFT(ft);
		
	}
	
	public void absParameter(AbsConcept parametre){
		AbsObject name = parametre.getAbsObject("paraName");
		String paraName = name.toString().substring(1).trim();
		AbsObject value = parametre.getAbsObject("paraValue");
		println(paraName);
		AbsObject constant = value.getAbsObject(value.getNames()[0]);
		// Un parametre est soit une constant soit un functionTerm
		if(value.getNames()[0].equals("constantTerm")){
			if (constant.getNames()[0].equals("stringConstant")){
				AbsPrimitive sc = (AbsPrimitive)constant.getAbsObject(constant.getNames()[0]);
				String paraValue = sc.getString().trim();
				println(paraValue);
			}			
		}
		if(value.getNames()[0].equals("functionTerm")){
			absFT((AbsTerm)value.getAbsObject(value.getNames()[0]));
			//System.out.print("     ");
		}
	}
	*/

}