/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.demo.KoyotBrain;
import warbot.kernel.Percept;

public class KKLauncher
extends KoyotBrain {
    public void activate() {
        this.roleName = "launcher";
        super.activate();
        this.behaviour = new int[][]{{45, -100, -100, -100, -100, 30, -100, -100, -100}, {50, 30, -100, -100, 80, 10, -100, -100, -100}, {20, 75, -100, -100, 65, 10, -100, -100, -100}, {20, 90, -100, -100, 45, 10, -100, -100, -100}, {10, -100, 80, -100, -100, 10, -100, -100, -100}, {20, -100, -100, -100, -100, 10, 55, -100, -100}, {20, -100, -100, -100, -100, 20, -100, 55, -100}};
    }

    public void snipe(Percept target) {
        if (this.getRocketNumber() <= 1) {
            this.buildRocket();
            return;
        }
        this.launchRocket(this.towards(target.getX(), target.getY()));
        this.bullet = 3;
    }

    public void goTarget(Percept target) {
        this.slide();
    }

    public void attack(Percept target) {
        if (this.iCanSnipe(target)) {
            this.snipe(target);
        } else {
            this.goTarget(target);
        }
    }

    public void attackExplorer(Percept target) {
        if (this.iCanSnipe(target)) {
            double targetX = target.getX();
            double targetY = target.getY();
            double oldTargetX = ((Percept)this.explorer.elementAt(0)).getX();
            double oldTargetY = ((Percept)this.explorer.elementAt(0)).getY();
            double decayX = -oldTargetX + targetX;
            double decayY = -oldTargetY + targetY;
            double far = Math.sqrt(oldTargetX * oldTargetX + oldTargetY * oldTargetY);
            double shootX = targetX + decayX * (far /= (double)10);
            double shootY = targetY + decayY * far;
            this.explorer.removeAllElements();
            this.explorer.add(target);
            this.launchRocket(this.towards(shootX, shootY));
        } else {
            this.goTarget(target);
        }
    }

    public void call_attackBot() {
        boolean skip = false;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            int i;
            boolean other = true;
            boolean lifeBlaster = false;
            int nbBlasters = 50;
            Percept e = null;
            Object oneBotToBlast = null;
            Object botToBlast = null;
            Object toBlast = null;
            boolean boneBotToBlast = false;
            boolean bbotToBlast = false;
            if (this.getEnergyLevel() * 100 / this.maxEnergy > 60) {
                lifeBlaster = true;
            }
            for (i = 0; i < detectedEntities.length; ++i) {
                e = detectedEntities[i];
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("RocketLauncher")) continue;
                this.warning(e.getX(), e.getY());
                this.attack(e);
                skip = true;
            }
            if (!skip) {
                for (i = 0; i < detectedEntities.length; ++i) {
                    e = detectedEntities[i];
                    if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("Explorer")) continue;
                    this.explorer.add(e);
                    this.attackExplorer(e);
                    break;
                }
            }
        }
    }

    public void call_attackBase() {
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("Home")) continue;
                this.attack(e);
                break;
            }
        }
    }

    public void screamMessages(int action) {
        if (this.ennemyBase) {
            this.throwMessage("Home", 65, 1);
        }
        if (action == 1 && (this.underpower || this.equalpower)) {
            this.throwMessage("RocketLauncher", 75, 0);
        }
        if (action == 4) {
            this.throwMessage("RocketLauncher", 63, 0);
        }
    }

    public void call_goHelp() {
        this.setHeading(this.towards(this.objectiveX, this.objectiveY));
        this.slide();
    }

    public void call_moveToBase() {
        this.setHeading(this.towards(this.objectiveX, this.objectiveY));
        this.slide();
    }

    public int[] GetEnergyLevelModifier(float ratio) {
        int[] modifier = ratio > (float)60 ? new int[]{0, 12, 10, 10, -3, -20, 0, 0, 10} : (ratio < (float)35 ? new int[]{-5, -10, -10, 12, 5, -10, 20, 20, 0} : new int[]{3, 5, 0, 10, 3, -10, 15, 15, 5});
        return modifier;
    }

    public void processLeaveGroup(int action) {
        if (this.groupGoal != -1 && !this.currentUnderGroupName.equals("")) {
            switch (this.groupGoal) {
                case 0: {
                    if (action != 0 && (action != 3 || !this.helpBase)) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 1: {
                    if (action != 0 && action != 2 && action != 8 && (action != 3 || this.testIfInMyGroup(this.maxPriorityMessage))) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 2: {
                    if (action == 0 || action == 6 || action == 7 || action == 4) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 3: {
                    if (action != 0 && action != 8 && action != 2 && (action != 3 || !this.helpBase)) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
            }
        }
        if (!this.nearMyGroup()) {
            this.ejectFromCurrentGroup();
        }
    }

    public void call_goAway() {
        this.println("goaway");
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (!this.iCanSnipe(e) || e.getTeam().equals(this.getTeam())) continue;
                this.launchRocket(this.towards(e.getX(), e.getY()));
                this.bullet = 3;
                return;
            }
        }
        this.applyStrengthRunAway();
    }

    public boolean iCanSnipe(Percept target) {
        int i;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0 && (i = 0) < detectedEntities.length) {
            Percept e = detectedEntities[i];
            if (Math.abs(this.distanceTo(e)) < Math.abs(this.distanceTo(target)) && (Math.abs(this.towards(e.getX(), e.getY()) - this.towards(target.getX(), target.getY())) < (double)35 || Math.abs(this.towards(e.getX(), e.getY()) - this.towards(target.getX(), target.getY())) > (double)325) && (e.getTeam().equals(this.getTeam()) || e.getPerceptType().equals("Obstacle"))) {
                return false;
            }
            return this.bullet <= 0;
        }
        return this.bullet <= 0;
    }
}

