/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import madkit.jess.JessEditorPanel;

class JessSetWatchDialog
extends JDialog
implements ItemListener,
ActionListener {
    boolean[] watchItems;
    JessEditorPanel editor;
    JCheckBox factsButton;
    JCheckBox rulesButton;
    JCheckBox activButton;
    JCheckBox compilButton;
    JCheckBox outButton;
    JCheckBox inButton;
    JCheckBox restartButton;
    JCheckBox controlButton;

    public JessSetWatchDialog(JessEditorPanel jessEditorPanel, boolean[] blArray) {
        this.setTitle("Watch settings");
        this.editor = jessEditorPanel;
        this.watchItems = blArray;
        this.factsButton = new JCheckBox("facts : ");
        this.factsButton.setSelected(this.watchItems[0]);
        this.factsButton.setToolTipText("prints a message whenever a fact is asserted or retracted");
        this.factsButton.addItemListener(this);
        this.rulesButton = new JCheckBox("rules : ");
        this.rulesButton.setSelected(this.watchItems[1]);
        this.rulesButton.setToolTipText("prints a message when any rule fires");
        this.rulesButton.addItemListener(this);
        this.activButton = new JCheckBox("activations : ");
        this.activButton.setSelected(this.watchItems[2]);
        this.activButton.setToolTipText("prints a message when any rule is activated, or deactivated");
        this.activButton.addItemListener(this);
        this.compilButton = new JCheckBox("compilations : ");
        this.compilButton.setSelected(this.watchItems[3]);
        this.compilButton.setToolTipText("prints a message when any rule is compiled");
        this.compilButton.addItemListener(this);
        this.outButton = new JCheckBox("out messages : ");
        this.outButton.setSelected(this.watchItems[4]);
        this.outButton.setToolTipText("prints a message when a Madkit message is sent");
        this.outButton.addItemListener(this);
        this.inButton = new JCheckBox("in messages : ");
        this.inButton.setSelected(this.watchItems[5]);
        this.inButton.setToolTipText("prints a message when a Madkit message is received");
        this.inButton.addItemListener(this);
        this.restartButton = new JCheckBox("restart engine : ");
        this.restartButton.setSelected(this.watchItems[6]);
        this.restartButton.setToolTipText("prints a message when the Jess engine is restarted (usually upon reception of a Madkit message)");
        this.restartButton.addItemListener(this);
        this.controlButton = new JCheckBox("control messages : ");
        this.controlButton.setSelected(this.watchItems[6]);
        this.controlButton.setToolTipText("prints a message when a Madkit control message is received");
        this.controlButton.addItemListener(this);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add(this.factsButton);
        jPanel.add(this.rulesButton);
        jPanel.add(this.activButton);
        jPanel.add(this.compilButton);
        jPanel.add(this.outButton);
        jPanel.add(this.inButton);
        jPanel.add(this.restartButton);
        jPanel.add(this.controlButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton("OK");
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jPanel2.add(jButton);
        jButton2.addActionListener(this);
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = 0;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.factsButton) {
            n = 0;
        } else if (itemSelectable == this.rulesButton) {
            n = 1;
        } else if (itemSelectable == this.activButton) {
            n = 2;
        } else if (itemSelectable == this.compilButton) {
            n = 3;
        } else if (itemSelectable == this.outButton) {
            n = 4;
        } else if (itemSelectable == this.inButton) {
            n = 5;
        } else if (itemSelectable == this.restartButton) {
            n = 6;
        } else if (itemSelectable == this.controlButton) {
            n = 7;
        }
        if (itemEvent.getStateChange() == 1) {
            this.watchItems[n] = true;
        } else if (itemEvent.getStateChange() == 2) {
            this.watchItems[n] = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.editor.setWatchItems(this.watchItems);
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

