/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.util.Vector;
import madkit.jess.JessAgent;
import madkit.jess.JessMonitorPanel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.Utils;
import madkit.messages.ControlMessage;

public class JessMonitor
extends Agent {
    public static final String VERSION = "0.8";
    public static final String DATE = "15/05/2001";
    AgentAddress recipient = null;
    String targetGroup;
    String targetRole;
    JessMonitorPanel display;

    public void setRecipient(AgentAddress agentAddress) {
        this.recipient = agentAddress;
        this.display.setRecipientLabel(agentAddress.toString());
    }

    public AgentAddress getRecipient() {
        return this.recipient;
    }

    public void initGUI() {
        this.display = new JessMonitorPanel(this);
        this.setGUIObject((Object)this.display);
    }

    public void println(String string) {
        this.display.println(string);
    }

    public void activate() {
        this.createGroup(false, "Jess", null, null);
        this.requestRole("Jess", "monitor", null);
        this.println("JessMonitor - version 0.8 - 15/05/2001");
        this.println("Author: J. Ferber - (C) MadKit Team 2000");
    }

    public void live() {
        while (true) {
            this.waitNextMessage();
        }
    }

    public void sendControlMessage(String string, String string2) {
        if (this.recipient != null) {
            this.println(">> " + string + " : " + string2);
            this.sendMessage(this.recipient, (Message)new ControlMessage(string, string2));
        }
    }

    public void sendControlMessage(String string) {
        if (this.recipient != null) {
            this.println(">> " + string);
            this.sendMessage(this.recipient, (Message)new ControlMessage(string));
        }
    }

    void launch(String string) {
        JessAgent jessAgent = new JessAgent(string);
        this.launchAgent((AbstractAgent)jessAgent, Utils.getFileNameFromPath((String)string), true);
        this.setRecipient(jessAgent.getAddress());
    }

    public void setTargetGroup(String string) {
        this.targetGroup = string;
    }

    public void setTargetRole(String string) {
        this.targetRole = string;
    }

    public void setTarget(String string, String string2) {
        if (string == null) {
            return;
        }
        this.targetGroup = string;
        this.targetRole = string2;
    }

    public Vector askGetGroups() {
        String[] stringArray = this.getExistingGroups();
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector;
    }

    public String[] askGetRoles(String string) {
        return this.getExistingRoles(string);
    }
}

