/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinScrollbar;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinScrollbar;
import com.l2fprod.gui.plaf.skin.impl.gtk.ArrowButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;

class GtkScrollbar
extends AbstractSkinScrollbar
implements SkinScrollbar,
SwingConstants {
    DefaultButton h_track;
    DefaultButton v_track;
    DefaultButton h_thumb;
    DefaultButton v_thumb;
    DefaultButton h_handle;
    DefaultButton v_handle;
    ArrowButton up;
    ArrowButton down;
    ArrowButton left;
    ArrowButton right;
    Dimension minimumThumbSize;

    public Dimension getPreferredSize(JScrollBar scrollbar) {
        return scrollbar.getOrientation() == 1 ? new Dimension(Math.max(10, Math.min(this.up.getWidth(), this.v_thumb.getWidth())), 48) : new Dimension(48, Math.max(10, Math.min(this.left.getHeight(), this.h_thumb.getHeight())));
    }

    public Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    public Dimension getArrowPreferredSize(int direction) {
        switch (direction) {
            case 1: {
                return this.up.getPreferredSize();
            }
            case 5: {
                return this.down.getPreferredSize();
            }
            case 7: {
                return this.left.getPreferredSize();
            }
            case 3: {
                return this.right.getPreferredSize();
            }
        }
        throw new Error("Invalid direction " + direction);
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    public boolean paintArrow(Graphics g, AbstractButton b, int direction) {
        switch (direction) {
            case 1: {
                this.up.paint(g, b);
                break;
            }
            case 5: {
                this.down.paint(g, b);
                break;
            }
            case 7: {
                this.left.paint(g, b);
                break;
            }
            case 3: {
                this.right.paint(g, b);
            }
        }
        return true;
    }

    public boolean paintTrack(Graphics g, JScrollBar scrollbar, Rectangle trackBounds) {
        if (this.h_track != null) {
            if (scrollbar.getOrientation() == 0) {
                this.h_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, scrollbar);
            } else {
                this.v_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, scrollbar);
            }
            return true;
        }
        return false;
    }

    public boolean paintThumb(Graphics g, JScrollBar scrollbar, Rectangle thumbBounds) {
        if (this.h_thumb != null) {
            if (scrollbar.getOrientation() == 0) {
                this.h_thumb.paint(g, 0, 0, thumbBounds.width, thumbBounds.height, scrollbar);
                if (this.h_handle != null && this.h_handle.getWidth() < thumbBounds.width) {
                    this.h_handle.paint(g, Math.max(0, (thumbBounds.width - this.h_handle.getWidth()) / 2), (thumbBounds.height - this.h_handle.getHeight()) / 2, Math.min(thumbBounds.width, this.h_handle.getWidth()), this.h_handle.getHeight(), scrollbar);
                }
            } else {
                this.v_thumb.paint(g, 0, 0, thumbBounds.width, thumbBounds.height, scrollbar);
                if (this.v_handle != null && this.v_handle.getHeight() < thumbBounds.height) {
                    this.v_handle.paint(g, (thumbBounds.width - this.v_handle.getWidth()) / 2, Math.max(0, (thumbBounds.height - this.v_handle.getHeight()) / 2), this.v_handle.getWidth(), Math.min(thumbBounds.height, this.v_handle.getHeight()), scrollbar);
                }
            }
            return true;
        }
        return false;
    }

    public GtkScrollbar(GtkParser parser) throws Exception {
        this.h_thumb = GtkUtils.newButton(parser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "slider", "HORIZONTAL"});
        this.v_thumb = GtkUtils.newButton(parser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "slider", "VERTICAL"});
        this.h_track = GtkUtils.newButton(parser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "HORIZONTAL"});
        this.v_track = GtkUtils.newButton(parser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "VERTICAL"});
        this.h_handle = GtkUtils.newButton(parser, "default", new String[]{"function", "orientation"}, new String[]{"HANDLE", "HORIZONTAL"}, true);
        if (this.h_handle != null) {
            this.h_handle.setCenterFill(1);
        }
        this.v_handle = GtkUtils.newButton(parser, "default", new String[]{"function", "orientation"}, new String[]{"HANDLE", "VERTICAL"}, true);
        if (this.v_handle != null) {
            this.v_handle.setCenterFill(1);
        }
        this.up = new ArrowButton(parser, "UP");
        this.down = new ArrowButton(parser, "DOWN");
        this.left = new ArrowButton(parser, "LEFT");
        this.right = new ArrowButton(parser, "RIGHT");
        this.minimumThumbSize = new Dimension(this.h_thumb.getInsets().left + (this.h_handle != null ? this.h_handle.getWidth() : 0) + this.h_thumb.getInsets().right, this.v_thumb.getInsets().top + (this.v_handle != null ? this.v_handle.getHeight() : 0) + this.v_thumb.getInsets().bottom);
    }
}

