/*
 * Decompiled with CFR 0.152.
 */
package madkit.scheme;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.WrongArguments;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import kawa.standard.Scheme;
import kawa.standard.load;
import madkit.kernel.Message;
import madkit.messages.ControlMessage;
import madkit.scheme.SchemeAgent;
import madkit.scheme.SchemeEditorPanel;

public class EditSchemeAgent
extends SchemeAgent {
    public SchemeEditorPanel display;

    public EditSchemeAgent() {
    }

    public EditSchemeAgent(String string) {
        super(string);
    }

    public EditSchemeAgent(File file) {
        super(file);
    }

    public void initGUI() {
        this.display = new SchemeEditorPanel(this);
        this.setOutputWriter(this.display.stdout());
        this.out_p = new OutPort((Writer)this.display.stdout(), true, "<msg_stdout>");
        this.err_p = new OutPort((Writer)this.display.stdout(), "<msg_stderr>");
        this.setGUIObject(this.display);
    }

    public void println(String string) {
        this.display.stdout().println(string);
    }

    public void print(String string) {
        this.display.stdout().print(string);
    }

    public void activate() {
        super.activate();
        this.println(";; EditSchemeAgent version 1.0");
        this.println(";; Scheme output appears in this window");
        this.println(";; Type and evaluate your input in the editor above");
    }

    public void doSendControlMessage(String string) {
        this.sendMessage(this.getAddress(), (Message)new ControlMessage(string));
    }

    public void doSendControlMessage(String string, String string2) {
        this.sendMessage(this.getAddress(), (Message)new ControlMessage(string, string2));
    }

    public void handleControlMessage(ControlMessage controlMessage) {
        String string = controlMessage.getAction();
        Object object = null;
        try {
            if (string.equals("eval")) {
                object = Scheme.eval((String)controlMessage.getContent(), (Environment)this.env);
            } else if (string.equals("load")) {
                try {
                    FileReader fileReader = new FileReader(controlMessage.getContent());
                    load.loadSource((InPort)new InPort((Reader)fileReader), (Environment)this.env);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.println("Error opening file " + controlMessage.getContent());
                }
                catch (IOException iOException) {
                    this.println("Error reading file " + controlMessage.getContent());
                }
                catch (Throwable throwable) {
                    this.println("Error with file " + controlMessage.getContent());
                }
            } else {
                this.println("** Error: command unknown " + string);
                return;
            }
            if (object != null) {
                this.print("> ");
                interp.print(object, this.out_p);
            } else {
                this.println("> null");
            }
        }
        catch (WrongArguments wrongArguments) {
            if (wrongArguments.usage != null) {
                this.err_p.println("usage: " + wrongArguments.usage);
            }
            wrongArguments.printStackTrace((PrintWriter)this.err_p);
        }
        catch (ClassCastException classCastException) {
            this.err_p.println("Invalid parameter, was: " + classCastException.getMessage());
            classCastException.printStackTrace((PrintWriter)this.err_p);
        }
        catch (Exception exception) {
            this.println("Scheme error doing " + string);
            exception.printStackTrace((PrintWriter)this.err_p);
        }
    }

    public void live() {
        while (true) {
            Message message;
            if ((message = this.waitNextMessage()) instanceof ControlMessage) {
                this.handleControlMessage((ControlMessage)message);
                continue;
            }
            Binding binding = this.env.lookup("handle-message");
            if (binding != null) {
                try {
                    Pair pair = new Pair(binding.getValue(), (Object)new Pair((Object)message, (Object)LList.Empty));
                    Scheme.eval((Object)pair, (Environment)this.env);
                }
                catch (Exception exception) {
                    this.println("Scheme error " + exception.getMessage());
                    exception.printStackTrace((PrintWriter)this.err_p);
                }
                continue;
            }
            this.println("cannot handle this message : " + message);
        }
    }

    public void doPause(int n) {
        this.pause(n);
    }
}

