/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.undo.UndoManager;
import madkit.TreeTools.AbstractFileNode;
import madkit.TreeTools.GenericTreeNode;
import madkit.explorer.ExplorerActionDrag;
import madkit.explorer.ExplorerActions;
import madkit.explorer.ExplorerBackForWard;
import madkit.explorer.ExplorerDetails;
import madkit.explorer.ExplorerFindFile;
import madkit.explorer.ExplorerGUI_jMenuEditReverseSelect_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuEditSelectAll_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuFileDeleteFolder_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuFileExit_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuFileLink_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuHelpAbout_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuHelpHelp_ActionAdapter;
import madkit.explorer.ExplorerGUI_jMenuHiddenFiles_ActionAdapter;
import madkit.explorer.ExplorerGUI_textField_ActionAdapter;
import madkit.explorer.ExplorerGUI_tree_treeSelectionListenerAdapter;
import madkit.explorer.ExplorerLauncher;
import madkit.explorer.ExplorerOptionPane;
import madkit.explorer.MadkitExplorer;
import madkit.explorer.MadkitExplorerTree;
import madkit.kernel.AbstractAgent;

public class ExplorerGUI
extends JRootPane {
    public static int ICONSIZE = 64;
    ExplorerLauncher ag;
    ExplorerActionDrag explorerActionDrag;
    String initialPath = System.getProperty("madkit.dir");
    private Box pToolbar;
    protected UndoManager undoManager = new UndoManager();
    JPanel contentPane;
    JPanel status;
    JButton backward;
    JTextField textField;
    JMenuBar jMenuBar;
    JMenu jMenuFile;
    JMenu jMenuEdit;
    JMenu jMenuDisplay;
    JButton bParent;
    JButton bForward;
    JButton bHome;
    JButton bUndo;
    JButton bRedo;
    JButton bCut;
    JButton bCopy;
    JButton bPast;
    String actionToolBar;
    JMenu jMenuHelp;
    JMenu jMenuOptions;
    JMenuItem jMenuFileNew;
    JMenuItem jMenuFileLink;
    JMenuItem jMenuFileDeleteFolder;
    JMenuItem jMenuFileFind;
    JMenuItem jMenuFileCreateFolder;
    JMenuItem jMenuFileExit;
    JMenuItem jMenuEditUndo;
    JMenuItem jMenuEditRedo;
    JMenuItem jMenuEditCut;
    JMenuItem jMenuEditCopy;
    JMenuItem jMenuEditPast;
    JMenuItem jMenuEditSelectAll;
    JMenuItem jMenuEditReverseSelect;
    JMenuItem jMenuDisplayDetails;
    JMenuItem jMenuHelpHelp;
    JMenuItem jMenuHelpAbout;
    JMenuItem jMenuHiddenFiles;
    JSplitPane splitPane;
    MadkitExplorerTree tree;
    MadkitExplorer explorer;

    public ExplorerGUI(ExplorerLauncher explorerLauncher) {
        this.ag = explorerLauncher;
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuFileNew = new JMenuItem();
        this.jMenuFileNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuFileNew.setName("new");
        this.jMenuFileLink = new JMenuItem();
        this.jMenuFileLink.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuFileLink.setName("link");
        this.jMenuFileDeleteFolder = new JMenuItem();
        this.jMenuFileDeleteFolder.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuFileDeleteFolder.setName("deletefolder");
        this.jMenuFileFind = new JMenuItem();
        this.jMenuFileFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuFileFind.setName("find");
        this.jMenuFileCreateFolder = new JMenuItem();
        this.jMenuFileCreateFolder.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.jMenuFileCreateFolder.setName("createfolder");
        this.jMenuFileExit = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuEditUndo = new JMenuItem();
        this.jMenuEditUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuEditRedo = new JMenuItem();
        this.jMenuEditRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuEditCut = new JMenuItem();
        this.jMenuEditCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuEditCopy = new JMenuItem();
        this.jMenuEditCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuEditPast = new JMenuItem();
        this.jMenuEditPast.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuEditSelectAll = new JMenuItem();
        this.jMenuEditSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuEditReverseSelect = new JMenuItem();
        this.jMenuDisplay = new JMenu();
        this.jMenuDisplayDetails = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuHelpHelp = new JMenuItem();
        this.jMenuHelpAbout = new JMenuItem();
        this.jMenuOptions = new JMenu();
        this.jMenuHiddenFiles = new JMenuItem();
        this.status = new JPanel(new BorderLayout());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.textField = new JTextField(50);
        this.textField.setMargin(new Insets(2, 2, 2, 2));
        this.textField.addActionListener(new ExplorerGUI_textField_ActionAdapter(this));
        String string = this.initialPath;
        this.tree = new MadkitExplorerTree(new File(string));
        this.tree.setBackground(Color.white);
        this.tree.getTree().addTreeSelectionListener(new ExplorerGUI_tree_treeSelectionListenerAdapter(this));
        this.explorer = new MadkitExplorer((AbstractAgent)this.ag, this.tree, (AbstractFileNode)this.tree.getLocalRoot(), string, ICONSIZE, this.textField);
        this.explorer.setNode((AbstractFileNode)this.tree.getLocalRoot());
        this.splitPane = new JSplitPane(1, (Component)((Object)this.tree), this.explorer);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(175);
        this.backward = new JButton(new ImageIcon(this.loadImage("/images/backward.png")));
        this.backward.setMargin(new Insets(2, 2, 2, 2));
        this.backward.setName("Backward");
        this.backward.setToolTipText("Backward");
        this.backward.addActionListener(new ExplorerActions(this));
        this.bParent = new JButton(new ImageIcon(this.loadImage("/images/parent.png")));
        this.bParent.setMargin(new Insets(0, 0, 0, 0));
        this.bParent.setName("Parent");
        this.bParent.setToolTipText("Parent Directory");
        this.bParent.addActionListener(new ExplorerActions(this));
        this.bForward = new JButton(new ImageIcon(this.loadImage("/images/forward.png")));
        this.bForward.setMargin(new Insets(2, 2, 2, 2));
        this.bForward.setName("forward");
        this.bForward.setToolTipText("forward");
        this.bForward.addActionListener(new ExplorerActions(this));
        this.bHome = new JButton(new ImageIcon(this.loadImage("/images/home.png")));
        this.bHome.setMargin(new Insets(0, 0, 0, 0));
        this.bHome.setName("Home");
        this.bHome.setToolTipText("Home Directory");
        this.bHome.addActionListener(new ExplorerActions(this));
        this.bUndo = new JButton(new ImageIcon(this.loadImage("/images/undo.png")));
        this.bUndo.setMargin(new Insets(0, 0, 0, 0));
        this.bUndo.setToolTipText("Undo");
        this.bUndo.setName("Undo");
        this.bUndo.setEnabled(false);
        this.bUndo.addActionListener(new ExplorerActions(this));
        this.bRedo = new JButton(new ImageIcon(this.loadImage("/images/redo.png")));
        this.bRedo.setMargin(new Insets(0, 0, 0, 0));
        this.bRedo.setToolTipText("Redo");
        this.bRedo.setName("Redo");
        this.bRedo.setEnabled(false);
        this.bRedo.addActionListener(new ExplorerActions(this));
        this.bCut = new JButton(new ImageIcon(this.loadImage("/images/cut.png")));
        this.bCut.setMargin(new Insets(0, 0, 0, 0));
        this.bCut.setToolTipText("Cut");
        this.bCut.setName("Cut");
        this.bCut.setEnabled(true);
        this.bCut.addActionListener(new ExplorerActions(this));
        this.bCopy = new JButton(new ImageIcon(this.loadImage("/images/copy.png")));
        this.bCopy.setMargin(new Insets(0, 0, 0, 0));
        this.bCopy.setToolTipText("Copy");
        this.bCopy.setName("Copy");
        this.bCopy.setEnabled(true);
        this.bCopy.addActionListener(new ExplorerActions(this));
        this.bPast = new JButton(new ImageIcon(this.loadImage("/images/past.png")));
        this.bPast.setMargin(new Insets(0, 0, 0, 0));
        this.bPast.setToolTipText("Past");
        this.bPast.setName("Past");
        this.bPast.setEnabled(false);
        this.bPast.addActionListener(new ExplorerActions(this));
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.bHome);
        jToolBar.add(this.backward);
        jToolBar.add(this.bForward);
        jToolBar.add(this.bParent);
        jToolBar.add(this.bUndo);
        jToolBar.add(this.bRedo);
        jToolBar.add(this.bCut);
        jToolBar.add(this.bCopy);
        jToolBar.add(this.bPast);
        this.status.add((Component)jToolBar, "West");
        this.status.add((Component)this.textField, "East");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.contentPane.add((Component)this.splitPane, "Center");
        this.contentPane.add((Component)this.status, "North");
        this.jMenuFile.setText("File");
        this.jMenuFileNew.setText("New");
        this.jMenuFileNew.addActionListener(new ExplorerActions(this));
        this.jMenuFileLink.setText("Create a link");
        this.jMenuFileLink.addActionListener(new ExplorerGUI_jMenuFileLink_ActionAdapter(this));
        this.jMenuFileDeleteFolder.setText("Delete Folder");
        this.jMenuFileDeleteFolder.addActionListener(new ExplorerGUI_jMenuFileDeleteFolder_ActionAdapter(this));
        this.jMenuFileFind.setText("Find");
        this.jMenuFileFind.addActionListener(new ExplorerFindFile(this));
        this.jMenuFileCreateFolder.setText("Create Folder");
        this.jMenuFileCreateFolder.addActionListener(new ExplorerActions(this));
        this.jMenuEdit.setText("Edit");
        this.jMenuEditUndo.setText("Undo");
        this.jMenuEditUndo.addActionListener(new ExplorerActions(this));
        this.jMenuEditUndo.setEnabled(false);
        this.jMenuEditRedo.setText("Redo");
        this.jMenuEditRedo.addActionListener(new ExplorerActions(this));
        this.jMenuEditRedo.setEnabled(false);
        this.jMenuEditCut.setText("Cut");
        this.jMenuEditCut.addActionListener(new ExplorerActions(this));
        this.jMenuEditCut.setEnabled(true);
        this.jMenuEditCopy.setText("Copy");
        this.jMenuEditCopy.addActionListener(new ExplorerActions(this));
        this.jMenuEditCopy.setEnabled(true);
        this.jMenuEditPast.setText("Past");
        this.jMenuEditPast.addActionListener(new ExplorerActions(this));
        this.jMenuEditPast.setEnabled(false);
        this.jMenuEditSelectAll.setText("Select All");
        this.jMenuEditSelectAll.addActionListener(new ExplorerGUI_jMenuEditSelectAll_ActionAdapter(this));
        this.jMenuEditSelectAll.setEnabled(false);
        this.jMenuEditReverseSelect.setText("Reverse Select");
        this.jMenuEditReverseSelect.addActionListener(new ExplorerGUI_jMenuEditReverseSelect_ActionAdapter(this));
        this.jMenuEditReverseSelect.setEnabled(false);
        this.jMenuDisplay.setText("Display");
        this.jMenuDisplayDetails.setText("Details");
        this.jMenuDisplayDetails.setEnabled(true);
        this.jMenuDisplayDetails.addActionListener(new ExplorerDetails(this));
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ExplorerGUI_jMenuFileExit_ActionAdapter(this));
        this.jMenuHelp.setText("?");
        this.jMenuHelpHelp.setText("Help - Documentation");
        this.jMenuHelpHelp.addActionListener(new ExplorerGUI_jMenuHelpHelp_ActionAdapter(this));
        this.jMenuHelpAbout.setText("About Madkit - Explorer");
        this.jMenuHelpAbout.addActionListener(new ExplorerGUI_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuOptions.setText("Options");
        this.jMenuHiddenFiles.setText("show/hide hidden files");
        this.jMenuHiddenFiles.addActionListener(new ExplorerGUI_jMenuHiddenFiles_ActionAdapter(this));
        this.jMenuBar.setActionMap(null);
        this.jMenuFile.add(this.jMenuFileNew);
        this.jMenuFile.add(this.jMenuFileLink);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileFind);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileCreateFolder);
        this.jMenuFile.add(this.jMenuFileDeleteFolder);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuEdit.add(this.jMenuEditUndo);
        this.jMenuEdit.add(this.jMenuEditRedo);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditCut);
        this.jMenuEdit.add(this.jMenuEditCopy);
        this.jMenuEdit.add(this.jMenuEditPast);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditSelectAll);
        this.jMenuEdit.add(this.jMenuEditReverseSelect);
        this.jMenuDisplay.add(this.jMenuDisplayDetails);
        this.jMenuHelp.add(this.jMenuHelpHelp);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuOptions.add(this.jMenuHiddenFiles);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuBar.add(this.jMenuDisplay);
        this.jMenuBar.add(this.jMenuOptions);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.explorerActionDrag = new ExplorerActionDrag();
        ExplorerBackForWard.init(this);
        ExplorerActions.actionToolBar = "init";
        this.traitBackFor();
    }

    private Image loadImage(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        return null;
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        String string = "Madkit - Explorer \nauthors A.Khammal ,C.Marty , X.Lorca, J.Ferber \nversion 3.0";
        String string2 = "INFORMATION";
        ExplorerOptionPane.showMessage(string, string2);
    }

    public void jMenuHelpHelp_actionPerformed(ActionEvent actionEvent) {
        String string = "help on line";
        String string2 = "INFORMATION";
        ExplorerOptionPane.showMessage(string, string2);
    }

    public void jMenuFileLink_actionPerformed(ActionEvent actionEvent) {
    }

    public void jMenuFileDeleteFolder_actionPerformed(ActionEvent actionEvent) {
        String string = this.explorer.absolutePath.intern();
        String string2 = "Enter the Name of the Folder you want to DELETE  ";
        String string3 = "DELETE FOLDER  ";
        String string4 = string + File.separatorChar;
        String string5 = ExplorerOptionPane.askForName(string4, string2, string3);
        File file = new File(string5);
        if (file.isDirectory()) {
            string2 = "ARE YOU SURE YOU WANT TO DELETE THIS FOLDER " + string5 + " ?";
            int n = ExplorerOptionPane.yesNo(string2, string3 = "DELETE FOLDER  ");
            if (n == 0) {
                boolean bl = file.delete();
                if (bl) {
                    System.out.println("Delete OK");
                    this.explorer.read();
                } else {
                    System.out.println("Delete NOT OK");
                }
            }
        } else {
            string2 = null;
            string3 = "MadKit cannot execute this action,This Folder or this File " + file + " Doesn't exist or is not a directory";
            ExplorerOptionPane.showMessage(string2, string3);
            string5 = ExplorerOptionPane.askForName(string, string2, string3);
            file = new File(string5);
        }
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        this.ag.killExplorerAgent();
    }

    public void jMenuEditSelectAll_actionPerformed(ActionEvent actionEvent) {
    }

    public void jMenuEditReverseSelect_actionPerformed(ActionEvent actionEvent) {
    }

    public void jMenuDisplayList_actionPerformed(ActionEvent actionEvent) {
    }

    public void jMenuDisplayReorganizedBy_actionPerformed(ActionEvent actionEvent) {
    }

    public void tree_treeSelection(TreeSelectionEvent treeSelectionEvent) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)this.tree.getTree().getLastSelectedPathComponent();
        if (genericTreeNode == null) {
            return;
        }
        this.explorer.setNode((AbstractFileNode)genericTreeNode);
        String string = this.tree.getPath(treeSelectionEvent.getPath().getPath());
        this.explorer.setAbsolutePath(string);
        this.traitBackFor();
        this.explorer.read();
        this.explorerActionDrag.execTree(this);
    }

    public void setRootPath(String string) {
        System.out.println("Setting root path:" + string);
        File file = new File(string);
        if (file.exists()) {
            this.tree.reInstallRoot(file);
            this.explorer.setNode((AbstractFileNode)this.tree.getLocalRoot());
            this.explorer.setAbsolutePath(string);
            this.traitBackFor();
            this.explorer.read();
        }
    }

    public void jMenuHiddenFiles_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.explorer.getHidden();
        this.explorer.setHidden(!bl);
        this.tree.setHidden(!bl);
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        System.out.println("mousePressed selected");
    }

    public void traitBackFor() {
        try {
            if (ExplorerActions.actionToolBar.equals("backward") || ExplorerActions.actionToolBar.equals("forward")) {
                ExplorerActions.actionToolBar = "init";
            } else {
                ExplorerBackForWard.vectorSelection.add(++ExplorerBackForWard.vectorGuiPos, this.explorer.getAbsolutePath());
                ExplorerBackForWard.vectorNode.add(ExplorerBackForWard.vectorGuiPos, this.explorer.node);
                this.backward.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

