/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.IOException;
import java.util.Vector;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.share.AbstractShareAgent;
import madkit.share.RequestSearchFileMessage;
import madkit.share.SearchFileMessage;
import madkit.share.SearchedFile;
import madkit.share.ShareSearchFilePanel;

public class SmallSearchFileAgent
extends Agent {
    AbstractShareAgent shareAgent;
    ShareSearchFilePanel searchPanel;
    Vector stockResultSearchFile;
    boolean live;
    String groupName;
    String fileName;

    public SmallSearchFileAgent(AbstractShareAgent abstractShareAgent, ShareSearchFilePanel shareSearchFilePanel) {
        this.shareAgent = abstractShareAgent;
        this.searchPanel = shareSearchFilePanel;
        this.groupName = abstractShareAgent.getGroupName();
        this.fileName = this.searchPanel.getFileName();
        this.stockResultSearchFile = new Vector();
        this.live = true;
    }

    public void activate() {
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, "SmallSearchFileAgent", null);
        this.sendAllRequestSearchFileMessage();
    }

    public void live() {
        while (this.live) {
            this.exitImmediatlyOnKill();
            if (!this.isMessageBoxEmpty()) {
                Message message = this.waitNextMessage();
                try {
                    this.handleMessage(message);
                }
                catch (IOException iOException) {
                    System.out.println("Error : SmallSearchFileAgent --> HandleMessage");
                }
                continue;
            }
            this.pause(1000);
        }
    }

    public void end() {
        System.out.println("(client) SmallSearchFileAgent killed");
    }

    void handleMessage(Message message) throws IOException {
        if (message instanceof SearchFileMessage) {
            this.stockResultSearchFile.add(new SearchedFile(((SearchFileMessage)message).getVirtualPath(), ((SearchFileMessage)message).isDirectory(), ((SearchFileMessage)message).getSize(), ((SearchFileMessage)message).getSender().getKernel().getHost().toString(), ((SearchFileMessage)message).getSender()));
            this.searchPanel.updateResultTable(this.stockResultSearchFile);
        }
    }

    public void sendAllRequestSearchFileMessage() {
        this.broadcastMessage(this.groupName, "sender", new RequestSearchFileMessage(this.fileName));
    }
}

