/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AgentAddress;
import madkit.share.AbstractShareAgent;
import madkit.share.AgentPanel;
import madkit.share.AgentPanel_jMenuFileExit_ActionAdapter;
import madkit.share.ExplorerPanel;
import madkit.share.KillMessage;
import madkit.share.ServerPanel;
import madkit.share.ShareAgentPanel_jMenuHelpAbout_ActionAdapter;
import madkit.share.ShareAgentPanel_jMenuSearchFile_ActionAdapter;
import madkit.share.ShareAgentPanel_jMenuSettings_ActionAdapter;
import madkit.share.ShareAgentPanel_jMenuUpdatedFile_ActionAdapter;
import madkit.share.ShareAgentPanel_jMenuViewExplorer_ActionAdapter;
import madkit.share.ShareAgentPanel_list_actionListenerAdapter;
import madkit.share.ShareList;
import madkit.share.ShareOptionPanel;
import madkit.share.ShareSearchFilePanel;

public class ShareAgentPanel
extends AgentPanel {
    AbstractShareAgent ag = (AbstractShareAgent)this.getAgent();
    JPanel mainPane;
    JPanel listPane;
    JPanel groupPane;
    JPanel buttonServerListPane;
    JPanel listPanel;
    JTabbedPane tabbedPane;
    JLabel status;
    JLabel separator;
    JLabel group;
    ImageIcon logo;
    URL url;
    JButton serverListButton;
    JTextField groupField;
    ShareList serverList;
    String role;
    JMenuBar jMenuBar1;
    JMenu jMenuFile;
    JMenuItem jMenuFileExit;
    JMenu jMenuHelp;
    JMenuItem jMenuHelpAbout;
    JMenu jMenuOption;
    JMenuItem jMenuSettings;
    JMenuItem jMenuUpdatedFile;
    JMenuItem jMenuSearchFile;
    JMenuItem jMenuViewExplorer;

    public ShareAgentPanel(AbstractShareAgent abstractShareAgent) {
        super(abstractShareAgent);
        this.role = this.ag.serverRoleName;
        this.serverList = new ShareList(new String[20], abstractShareAgent, new AgentAddress[20]);
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuFileExit = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuHelpAbout = new JMenuItem();
        this.jMenuOption = new JMenu();
        this.jMenuSettings = new JMenuItem();
        this.jMenuUpdatedFile = new JMenuItem();
        this.jMenuSearchFile = new JMenuItem();
        this.jMenuViewExplorer = new JMenuItem();
        this.jMenuSearchFile = new JMenuItem();
        this.mainPane = new JPanel();
        this.listPane = new JPanel();
        this.listPanel = new JPanel();
        this.groupPane = new JPanel();
        this.buttonServerListPane = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.status = new JLabel(" ");
        this.separator = new JLabel("       ");
        this.group = new JLabel("Group Name : ");
        this.serverListButton = new JButton("Server List");
        this.groupField = new JTextField(this.ag.groupName);
        this.url = this.getClass().getResource("/images/share/share.png");
        if (this.url != null) {
            this.logo = new ImageIcon(this.url);
        } else {
            System.out.println("erreur image : /images/share/share.png");
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuOption.setToolTipText("");
        this.jMenuOption.setText("Option");
        this.jMenuSettings.setToolTipText("");
        this.jMenuSettings.setText("Program Settings...");
        this.jMenuUpdatedFile.setToolTipText("");
        this.jMenuUpdatedFile.setText("View Updated Files...");
        this.jMenuSearchFile.setText("Search file...");
        this.jMenuViewExplorer.setText("View Incoming directory...");
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuOption);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.jMenuOption.add(this.jMenuSettings);
        this.jMenuOption.addSeparator();
        this.jMenuOption.add(this.jMenuUpdatedFile);
        this.jMenuOption.add(this.jMenuViewExplorer);
        this.jMenuOption.addSeparator();
        this.jMenuOption.add(this.jMenuSearchFile);
        this.jMenuFileExit.addActionListener(new AgentPanel_jMenuFileExit_ActionAdapter(this));
        this.jMenuHelpAbout.addActionListener(new ShareAgentPanel_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuUpdatedFile.addActionListener(new ShareAgentPanel_jMenuUpdatedFile_ActionAdapter(this));
        this.jMenuSettings.addActionListener(new ShareAgentPanel_jMenuSettings_ActionAdapter(this));
        this.jMenuSearchFile.addActionListener(new ShareAgentPanel_jMenuSearchFile_ActionAdapter(this));
        this.jMenuViewExplorer.addActionListener(new ShareAgentPanel_jMenuViewExplorer_ActionAdapter(this));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setPreferredSize(new Dimension(550, 350));
        this.contentPane.setBackground(Color.lightGray);
        this.groupPane.setLayout(new FlowLayout());
        this.groupPane.add((Component)this.group, null);
        this.groupPane.add((Component)this.groupField, null);
        this.groupField.setColumns(15);
        this.serverListButton.addActionListener(new ShareAgentPanel_list_actionListenerAdapter(this));
        this.buttonServerListPane.setLayout(new FlowLayout());
        this.buttonServerListPane.add((Component)this.serverListButton, null);
        this.listPane.setPreferredSize(new Dimension(200, 100));
        this.listPane.setLayout(new BorderLayout());
        this.listPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.listPanel.setBackground(Color.white);
        this.listPanel.add((Component)this.serverList, null);
        this.listPane.add((Component)this.listPanel, "Center");
        this.listPane.add((Component)this.buttonServerListPane, "North");
        this.mainPane.setLayout(new BorderLayout());
        this.mainPane.add((Component)new JLabel("               "), "East");
        this.mainPane.add((Component)this.listPane, "Center");
        this.mainPane.add((Component)this.status, "South");
        this.mainPane.add((Component)new JLabel("               "), "West");
        this.tabbedPane.addTab(this.ag.groupName, this.logo, this.mainPane, "Share Agent");
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.contentPane.add((Component)this.groupPane, "North");
    }

    public void initList() {
        String string = this.groupField.getText();
        AgentAddress[] agentAddressArray = this.getAgent().getAgentsWithRole(string, this.role);
        if (agentAddressArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Could'nt find server", "Error", 0);
        }
        String[] stringArray = new String[agentAddressArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = agentAddressArray[i].getKernel().toString();
        }
        this.serverList = new ShareList(stringArray, (AbstractShareAgent)this.getAgent(), agentAddressArray);
    }

    public void addServerPanel(DirEntry dirEntry, AgentAddress agentAddress) {
        this.url = this.getClass().getResource("/images/share/sender1.png");
        if (this.url != null) {
            this.logo = new ImageIcon(this.url);
        }
        ServerPanel serverPanel = new ServerPanel(this, dirEntry, (AbstractShareAgent)this.getAgent(), agentAddress);
        this.tabbedPane.addTab(agentAddress.getKernel().getHost().toString(), this.logo, serverPanel, "Server Agent");
        this.repaint();
    }

    public void removeServerPanel() {
        this.tabbedPane.removeTabAt(this.tabbedPane.getSelectedIndex());
        this.repaint();
    }

    public void list_action(ActionEvent actionEvent) {
        this.listPanel.removeAll();
        this.listPane.removeAll();
        this.listPane.validate();
        this.mainPane.validate();
        this.listPane.add((Component)this.buttonServerListPane, "North");
        this.listPanel.setBackground(Color.white);
        this.initList();
        this.listPanel.add((Component)this.serverList, null);
        this.listPane.add((Component)this.listPanel, "Center");
        this.listPane.validate();
        this.mainPane.validate();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        ((AbstractShareAgent)this.getAgent()).sendMessage(((AbstractShareAgent)this.getAgent()).getAddress(), new KillMessage());
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "Madkit - Share \nUniversity of Montpellier II \nauthors A.Khammal , W.Abdallah , C.Marty , X.Lorca , L.Nivaggioni \nversion 2.5", "INFORMATION", 1);
    }

    public void jMenuUpdatedFile_actionPerformed(ActionEvent actionEvent) {
        ((AbstractShareAgent)this.getAgent()).showUpdateTable();
    }

    public void jMenuSearchFile_actionPerformed(ActionEvent actionEvent) {
        ShareSearchFilePanel shareSearchFilePanel = new ShareSearchFilePanel(this.ag);
        shareSearchFilePanel.display();
    }

    public void jMenuSettings_actionPerformed(ActionEvent actionEvent) {
        ShareOptionPanel shareOptionPanel = new ShareOptionPanel(this);
    }

    public void jMenuViewExplorer_actionPerformed(ActionEvent actionEvent) {
        final JFrame jFrame = new JFrame("Explorer");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setContentPane(new ExplorerPanel(((AbstractShareAgent)this.getAgent()).madkitDirectory + File.separator + this.ag.groupName + File.separator + "Incoming"));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

