/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.share.AbstractServerAgent;
import madkit.share.AssocPath;
import madkit.share.FicDataBase;
import madkit.share.FicMessage;
import madkit.share.FileInfo;
import madkit.share.IndexMessage;
import madkit.share.ListFic;
import madkit.share.OffsetMessage;
import madkit.share.RequestSearchFileMessage;
import madkit.share.RequestTreeMessage;
import madkit.share.SearchFileMessage;
import madkit.share.SenderAgentPanel;
import madkit.share.SmallSenderAgent;
import madkit.share.TreeMessage;

public class FileServerAgent
extends AbstractServerAgent {
    public String pluginsPath;

    public void initGUI() {
        this.display = new SenderAgentPanel(this);
        this.setGUIObject(this.display);
    }

    public void activate() {
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.live = true;
        this.initDir();
        this.dataBase = new FicDataBase();
    }

    public void live() {
        while (this.live) {
            Message message = this.waitNextMessage();
            try {
                this.handleMessage(message);
            }
            catch (IOException iOException) {
                System.out.println("Error : SenderAgent : cannot handle message " + message);
            }
        }
    }

    public void end() {
        for (int i = 0; i < this.smallSenderAgentList.size(); ++i) {
            this.killAgent((AbstractAgent)((SmallSenderAgent)((Object)this.smallSenderAgentList.elementAt(i))));
        }
    }

    void handleMessage(Message message) throws IOException {
        Object object;
        int n;
        Object object2;
        Object object3;
        String string;
        if (message instanceof RequestTreeMessage) {
            System.out.println("(server) RequestTreeMessage received");
            string = ((RequestTreeMessage)message).getText();
            if (string.equals("request-tree")) {
                object3 = ((RequestTreeMessage)message).getSender();
                this.sendMessage((AgentAddress)object3, new TreeMessage((DirEntry)((SenderAgentPanel)this.display).getEntry()));
            }
        } else if (message instanceof FicMessage) {
            string = ((FicMessage)message).getSender().getKernel().getHost().toString();
            object3 = ((FicMessage)message).getSender();
            object2 = ((FicMessage)message).getPath();
            n = ((FicMessage)message).getUpdatePlugin();
            System.out.println("(server) Request file " + (String)object2);
            object = this.dataBase.searchRealPath((String)object2);
            if (object.equals("error")) {
                System.out.println("Fichier non autorise :" + (String)object2);
                return;
            }
            ListFic listFic = new ListFic();
            File file = new File((String)object);
            if (file.isDirectory()) {
                if (n != 0) {
                    this.println("cannot send plugins");
                } else {
                    this.dirIndex((String)object2, (String)object, listFic);
                }
            } else {
                int n2 = (int)file.length();
                FileInfo fileInfo = new FileInfo((String)object2, n2);
                listFic.getVector().addElement(fileInfo);
            }
            this.sendMessage((AgentAddress)object3, new IndexMessage(listFic, this.getAddress(), n != 0));
        } else if (message instanceof RequestSearchFileMessage) {
            string = ((RequestSearchFileMessage)message).getSender();
            object3 = ((RequestSearchFileMessage)message).getFile();
            object2 = this.dataBase.searchFile(((RequestSearchFileMessage)message).getFile());
            if (!((Vector)object2).isEmpty()) {
                System.out.println("---> File " + ((RequestSearchFileMessage)message).getFile() + " found");
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    this.sendMessage((AgentAddress)string, new SearchFileMessage((String)object3, ((AssocPath)((Vector)object2).elementAt(n)).getVirtualPath(), ((AssocPath)((Vector)object2).elementAt(n)).getSizeFile(), ((AssocPath)((Vector)object2).elementAt(n)).isDirectory()));
                }
            }
        }
        if (message instanceof OffsetMessage) {
            string = ((OffsetMessage)message).getSender();
            object3 = ((OffsetMessage)message).getName();
            int n3 = ((OffsetMessage)message).getOffsetStart();
            n = ((OffsetMessage)message).getOffsetEnd();
            ++this.nbrSmallSenderAgent;
            object = new SmallSenderAgent((AgentAddress)string, (String)object3, n3, n, this.dataBase, this);
            this.launchAgent((AbstractAgent)object, "smallSenderAgent" + this.nbrSmallSenderAgent, false);
            ++this.nbrSmallSenderAgent;
            this.smallSenderAgentList.add(object);
        } else if (message instanceof RequestSearchFileMessage) {
            string = ((RequestSearchFileMessage)message).getSender();
            object3 = ((RequestSearchFileMessage)message).getFile();
            object2 = this.dataBase.searchFile(((RequestSearchFileMessage)message).getFile());
            if (!((Vector)object2).isEmpty()) {
                System.out.println("---> File " + ((RequestSearchFileMessage)message).getFile() + " found");
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    this.sendMessage((AgentAddress)string, new SearchFileMessage((String)object3, ((AssocPath)((Vector)object2).elementAt(n)).getVirtualPath(), ((AssocPath)((Vector)object2).elementAt(n)).getSizeFile(), ((AssocPath)((Vector)object2).elementAt(n)).isDirectory()));
                }
            }
        } else {
            super.handleMessage(message);
        }
    }

    public void initDir() {
        this.madkitDirectory = System.getProperty("madkit.dir");
        System.out.println("Madkit --> " + this.madkitDirectory);
        File file = new File(this.madkitDirectory + File.separator + this.groupName);
        file.mkdir();
        this.pluginsPath = this.madkitDirectory + File.separator + "plugins";
    }

    public void dirIndex(String string, String string2, ListFic listFic) {
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.dirIndex(string + separator + file2.getName(), string2 + separator + file2.getName(), listFic);
                    continue;
                }
                if (!file2.canRead()) continue;
                int n = (int)file2.length();
                FileInfo fileInfo = new FileInfo(string + separator + file2.getName(), n);
                listFic.getVector().addElement(fileInfo);
            }
        }
    }
}

