/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.share.FicMessage;
import madkit.share.FileMaj;
import madkit.share.FileSave;
import madkit.share.IndexMessage;
import madkit.share.KillMessage;
import madkit.share.ListFic;
import madkit.share.PaquetOnQueue;
import madkit.share.SearchFileMessage;
import madkit.share.ShareAgentPanel;
import madkit.share.SmallShareAgent;
import madkit.share.UpdateTableFrame;
import madkit.share.UpdatedFile;

public class AbstractShareAgent
extends Agent {
    JRootPane display;
    DirEntry s;
    FileSave saveFic;
    FileMaj majFic;
    String groupName = "share";
    String serverRoleName = "sender";
    public String madkitDirectory;
    AgentAddress[] agList;
    int nbrSmallShareAgent = 0;
    boolean live;
    int timeout = 60;
    int maxSize = 524288;
    Vector stockPaquetOnQueue = new Vector();
    Vector stockUpdatedFile = new Vector();
    Vector smallShareAgentList = new Vector();

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public JRootPane getDisplay() {
        return this.display;
    }

    public void setLive(boolean bl) {
        this.live = bl;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public FileMaj getFileMaj() {
        return this.majFic;
    }

    public void initGUI() {
        this.display = new ShareAgentPanel(this);
        this.setGUIObject(this.display);
    }

    public void activate() {
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, "receiver", null);
        this.live = true;
        this.initDir();
        this.loadSettings();
        this.saveFic = new FileSave(this, this.madkitDirectory + File.separator + this.groupName + File.separator + "save.ini");
        this.stockPaquetOnQueue = this.saveFic.load();
        if (!this.stockPaquetOnQueue.isEmpty()) {
            this.createSmallShareAgentForResumeFile();
        }
        this.majFic = new FileMaj(this.madkitDirectory + File.separator + this.groupName + File.separator + "maj.ini");
        this.stockUpdatedFile = this.majFic.load();
    }

    public void live() {
        while (this.live) {
            this.exitImmediatlyOnKill();
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void end() {
        for (int i = 0; i < this.smallShareAgentList.size(); ++i) {
            this.killAgent((AbstractAgent)((SmallShareAgent)((Object)this.smallShareAgentList.elementAt(i))));
        }
        this.majFic.lastUpdate(this.stockUpdatedFile);
        this.saveFic.update(this.stockPaquetOnQueue);
        this.leaveRole(this.groupName, "receiver");
        this.leaveGroup(this.groupName);
    }

    void handleMessage(Message message) {
        Object object;
        Object object2;
        if (message instanceof IndexMessage) {
            object2 = ((IndexMessage)message).getSender();
            object = ((IndexMessage)message).getSmallServerAddress();
            ListFic listFic = ((IndexMessage)message).getListFic();
            if (!listFic.isEmpty()) {
                SmallShareAgent smallShareAgent = new SmallShareAgent(listFic, (AgentAddress)object2, this, ((IndexMessage)message).getUpdatePlugin());
                this.launchAgent((AbstractAgent)smallShareAgent, "smallShareAgent" + this.nbrSmallShareAgent, false);
                ++this.nbrSmallShareAgent;
                this.smallShareAgentList.add(smallShareAgent);
            }
        } else {
            this.println("Message unknown: " + message);
        }
        if (message instanceof SearchFileMessage) {
            object2 = ((SearchFileMessage)message).getFile();
            object = ((SearchFileMessage)message).getSender().getKernel().getHost().toString();
            System.out.println("(client) SearchMessage received");
            System.out.println("---> File " + ((SearchFileMessage)message).getFile() + " found on " + (String)object);
        }
        if (message instanceof KillMessage) {
            this.live = false;
        }
    }

    public void initDir() {
        this.madkitDirectory = System.getProperty("madkit.dir");
        File file = new File(this.madkitDirectory + File.separator + this.groupName);
        file.mkdir();
        file = new File(this.madkitDirectory + File.separator + this.groupName + File.separator + "Incoming");
        file.mkdir();
    }

    public void addPaquetOnQueue(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.stockPaquetOnQueue.add(vector.elementAt(i));
        }
        this.saveFic.update(this.stockPaquetOnQueue);
    }

    public void addUpdatedFile(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.stockUpdatedFile.add(vector.elementAt(i));
        }
    }

    public boolean removePaquetOnQueue(String string, AgentAddress agentAddress, int n, int n2) {
        for (int i = 0; i < this.stockPaquetOnQueue.size(); ++i) {
            if (!string.equals(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getPath()) || n != ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetStart() || n2 != ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetEnd()) continue;
            this.stockPaquetOnQueue.removeElementAt(i);
            this.saveFic.update(this.stockPaquetOnQueue);
            return true;
        }
        return false;
    }

    public boolean removeSmallShareAgent(SmallShareAgent smallShareAgent) {
        for (int i = 0; i < this.smallShareAgentList.size(); ++i) {
            if (!((Object)((Object)smallShareAgent)).equals((Object)((SmallShareAgent)((Object)this.smallShareAgentList.elementAt(i))))) continue;
            this.smallShareAgentList.removeElementAt(i);
            if (!smallShareAgent.getUpdatePlugin()) {
                this.showUpdateTable();
            }
            return true;
        }
        return false;
    }

    public void AskUserUpdatedFile(String string, String string2, long l) {
        boolean bl = false;
        for (int i = 0; i < this.stockUpdatedFile.size(); ++i) {
            if (!((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getPath().equals(string) || !((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getServerName().equals(string2)) continue;
            bl = true;
            this.stockUpdatedFile.remove(i);
            this.stockUpdatedFile.addElement(new UpdatedFile(string, string2, l));
        }
        if (!bl) {
            UpdatedFile updatedFile = new UpdatedFile(string, string2, l);
            this.stockUpdatedFile.addElement(updatedFile);
        }
    }

    public void checkUpdatedFile(DirEntry dirEntry, AgentAddress agentAddress) {
        for (int i = 0; i < this.stockUpdatedFile.size(); ++i) {
            int n;
            long l = dirEntry.isThereFile(((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getPath(), "");
            if (l == 0L || l <= ((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getLastModified() || (n = JOptionPane.showConfirmDialog(null, "Would you like to update file \"" + ((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getPath() + "\" ?", "Updated File", 0)) != 0) continue;
            this.sendMessage(agentAddress, new FicMessage(((UpdatedFile)this.stockUpdatedFile.elementAt(i)).getPath()));
        }
    }

    public void createSmallShareAgentForResumeFile() {
        Vector<PaquetOnQueue> vector = new Vector<PaquetOnQueue>();
        AgentAddress agentAddress = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getAddress();
        for (int i = 0; i < this.stockPaquetOnQueue.size(); ++i) {
            if (agentAddress.equals((Object)((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getAddress())) {
                vector.add((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i));
                continue;
            }
            SmallShareAgent smallShareAgent = new SmallShareAgent(vector, this);
            this.launchAgent((AbstractAgent)smallShareAgent, "smallShareAgent" + this.nbrSmallShareAgent, false);
            ++this.nbrSmallShareAgent;
            this.smallShareAgentList.add(smallShareAgent);
            vector.clear();
            agentAddress = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getAddress();
        }
        SmallShareAgent smallShareAgent = new SmallShareAgent(vector, this);
        this.launchAgent((AbstractAgent)smallShareAgent, "smallShareAgent" + this.nbrSmallShareAgent, false);
        ++this.nbrSmallShareAgent;
        this.smallShareAgentList.add(smallShareAgent);
        vector.clear();
    }

    public void showUpdateTable() {
        UpdateTableFrame updateTableFrame = new UpdateTableFrame(this.stockUpdatedFile, this);
        updateTableFrame.pack();
        updateTableFrame.setVisible(true);
    }

    public void loadSettings() {
        try {
            String string;
            String string2 = this.madkitDirectory + File.separator + this.groupName + File.separator + "share.ini";
            File file = new File(string2);
            file.createNewFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            while ((string = randomAccessFile.readLine()) != null) {
                int n = string.indexOf(" ** ");
                this.timeout = Integer.parseInt(string.substring(10, n));
                string = string.substring(n + 4);
                n = string.indexOf(" ** ");
                this.maxSize = Integer.parseInt(string.substring(10, n));
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("(Client) Can't read share.ini");
        }
    }

    protected void executeServer(AgentAddress agentAddress) {
    }
}

