/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt2CyanVsOrange;

import java.awt.Color;
import java.util.ArrayList;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.hunt2CyanVsOrange.Animat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredatorOrange
extends Animat {
    static String ennemis = "cyan";
    static final int SACRIFICE = 1;
    static final int WAIT = 2;
    static final int CHASE = 3;
    static final int CONSUME = 4;
    private int status = 2;
    private ArrayList<Animat> predators = new ArrayList();
    private ArrayList<PredatorOrange> predatorsOranges = new ArrayList();

    public PredatorOrange(int n, int n2) {
        super(n, n2);
    }

    public void setup() {
        this.playRole("orange");
        this.randomHeading();
        this.setColor(Color.orange);
    }

    private void updatePerceptions() {
        this.predators = new ArrayList();
        this.predatorsOranges = new ArrayList();
        for (int i = 1; i <= this.visionRadius; ++i) {
            this.parseTurtles(this.turtlesAt(i, 0));
            this.parseTurtles(this.turtlesAt(i, -i));
            this.parseTurtles(this.turtlesAt(i, i));
            this.parseTurtles(this.turtlesAt(-i, i));
            this.parseTurtles(this.turtlesAt(-i, 0));
            this.parseTurtles(this.turtlesAt(-i, -i));
            this.parseTurtles(this.turtlesAt(0, i));
            this.parseTurtles(this.turtlesAt(0, -i));
            for (Turtle turtle : this.turtlesHere()) {
                if (!turtle.isPlayingRole("orange")) continue;
                this.predatorsOranges.add(0, (PredatorOrange)turtle);
            }
        }
    }

    private void parseTurtles(Turtle[] turtleArray) {
        for (Turtle turtle : turtleArray) {
            if (turtle.isPlayingRole(ennemis)) {
                this.predators.add((Animat)turtle);
                continue;
            }
            this.predatorsOranges.add((PredatorOrange)turtle);
        }
    }

    public String live() {
        this.updatePerceptions();
        if (!this.predators.isEmpty()) {
            Animat animat = this.predators.get(0);
            this.towards(animat.xcor(), animat.ycor());
            this.status = 3;
            return "chase";
        }
        this.status = 2;
        return "waiting";
    }

    private boolean towardsTheNearestPrey() {
        if (!this.predators.isEmpty()) {
            Animat animat = this.predators.get(0);
            this.towards(animat.xcor(), animat.ycor());
            return true;
        }
        return false;
    }

    public String consume() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        this.consumeResource();
        return "waiting";
    }

    public String sacrifice() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        return "sacrifice";
    }

    public String waiting() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        if (this.life < 75) {
            if (this.getPatchVariable("resource") == 0.0) {
                this.turnRight(Math.random() * 60.0);
                this.turnLeft(Math.random() * 60.0);
                this.move();
                this.status = 2;
                return "waiting";
            }
            this.consumeResource();
            this.status = 2;
            return "waiting";
        }
        if (this.life < 15) {
            this.status = 1;
            return "sacrifice";
        }
        this.updatePerceptions();
        if (this.predatorsOranges.size() < 4 && this.life > 100) {
            this.reproduce();
        }
        if (this.life > 300) {
            this.reproduce();
        }
        for (Animat animat : this.predators) {
            if (this.isFleeingMe(animat)) continue;
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            this.status = 3;
            return "chase";
        }
        if (this.towardsTheNearestPrey()) {
            this.move();
            this.status = 3;
            return "chase";
        }
        if (this.countTurtlesHere() > 1) {
            this.randomHeading();
            this.move();
        }
        return "waiting";
    }

    private boolean isFleeingMe(Animat animat) {
        return !(animat.getHeading() - this.towards(this.xcor() - animat.xcor(), this.ycor() - animat.ycor()) < 45.0);
    }

    public String chase() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        if (this.life < 15) {
            this.status = 1;
            return "sacrifice";
        }
        this.updatePerceptions();
        if (this.predatorsOranges.size() < 2 && this.life > 100) {
            this.reproduce();
        }
        for (Animat animat : this.predators) {
            if (this.isFleeingMe(animat)) continue;
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            this.status = 3;
            return "chase";
        }
        if (this.predators.isEmpty()) {
            this.status = 2;
            return "waiting";
        }
        if (this.towardsTheNearestPrey()) {
            this.move();
            this.status = 3;
            return "chase";
        }
        return "chase";
    }

    private ArrayList<Animat> getPreysHere() {
        ArrayList<Animat> arrayList = new ArrayList<Animat>();
        for (Turtle turtle : this.turtlesHere()) {
            if (!turtle.isPlayingRole(ennemis)) continue;
            arrayList.add((Animat)turtle);
        }
        return arrayList;
    }

    public int getStatus() {
        return this.status;
    }
}

