/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt2CyanVsBlue;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.hunt2CyanVsBlue.Animat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cyan
extends Animat {
    private static final String selfColor = "cyan";
    private static final String otherColor = "Blue";
    private static double seuilVie = 30.0;
    private ArrayList<Animat> nous;
    private ArrayList<Animat> autre;
    private int generation = 0;

    public Cyan(int n, int n2) {
        super(n, n2);
    }

    public void setup() {
        this.playRole(selfColor);
        this.randomHeading();
        this.setColor(Color.cyan);
    }

    public String live() {
        this.updatePerceptions();
        if (!this.eatOther()) {
            if (!this.towardsAnother()) {
                this.towardsRessource();
            }
            this.move();
            if (!this.eatOther()) {
                if ((double)this.life > seuilVie) {
                    this.reproduce();
                } else {
                    this.consumeResource();
                }
            }
        }
        this.nous = null;
        this.autre = null;
        return "live";
    }

    private void updatePerceptions() {
        this.nous = new ArrayList();
        this.autre = new ArrayList();
        int n = 2;
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                if (j == 0 || i == 0) continue;
                this.parseTurtles(this.turtlesAt(i, j));
                this.parseTurtles(this.turtlesAt(i, -j));
                this.parseTurtles(this.turtlesAt(-i, j));
                this.parseTurtles(this.turtlesAt(-i, -j));
            }
        }
        for (Turtle turtle : this.turtlesHere()) {
            if (turtle.isPlayingRole(selfColor)) {
                this.nous.add(0, (Animat)turtle);
                continue;
            }
            this.autre.add((Animat)turtle);
        }
    }

    private void parseTurtles(Turtle[] turtleArray) {
        for (Turtle turtle : turtleArray) {
            if (turtle.isPlayingRole(selfColor)) {
                this.nous.add((Animat)turtle);
                continue;
            }
            this.autre.add((Animat)turtle);
        }
    }

    private boolean towardsAnother() {
        Iterator<Animat> iterator = this.autre.iterator();
        if (iterator.hasNext()) {
            Animat animat = iterator.next();
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            return true;
        }
        return false;
    }

    private ArrayList<Turtle> getOtherHere() {
        ArrayList<Turtle> arrayList = new ArrayList<Turtle>();
        Turtle[] turtleArray = this.turtlesHere();
        if (turtleArray != null) {
            for (int i = 0; i < turtleArray.length; ++i) {
                if (!turtleArray[i].isPlayingRole(otherColor)) continue;
                arrayList.add((Animat)turtleArray[i]);
            }
        }
        return arrayList;
    }

    private boolean eatOther() {
        ArrayList<Turtle> arrayList = this.getOtherHere();
        if (!arrayList.isEmpty()) {
            Animat animat = (Animat)arrayList.get(0);
            this.life += animat.getLife();
            animat.die();
            return true;
        }
        return false;
    }

    protected void reproduce() {
        this.life -= this.life / 2;
        Cyan cyan = new Cyan(this.visionRadius, this.life);
        cyan.generation = this.generation + 1;
        this.createTurtle(cyan);
    }

    @Override
    protected void move() {
        if (--this.life < 0) {
            this.die();
        }
        this.fd(1);
    }

    private boolean towardsRessource() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (j == 0 || i == 0 || !((d2 = this.getPatchVariableAt("resource", i, j)) > d)) continue;
                d = d2;
                n = i;
                n2 = j;
            }
        }
        if (d > 0.0) {
            this.towards(this.xcor() + n, this.ycor() + n2);
            return true;
        }
        return false;
    }

    private ArrayList<Turtle> getUsHere() {
        ArrayList<Turtle> arrayList = new ArrayList<Turtle>();
        Turtle[] turtleArray = this.turtlesHere();
        if (turtleArray != null) {
            for (int i = 0; i < turtleArray.length; ++i) {
                if (!turtleArray[i].isPlayingRole(selfColor)) continue;
                arrayList.add((Animat)turtleArray[i]);
            }
        }
        return arrayList;
    }
}

