/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.diffusion;

import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;
import turtlekit.simulations.diffusion.FlavorViewer;
import turtlekit.simulations.diffusion.FlavorViewer2;
import turtlekit.simulations.diffusion.GridInitializer;

public class DiffusionTest
extends Launcher {
    double value = 1.0E8;
    double value2 = 5.0E10;
    double valueDiff = 0.33;
    double value2Diff = 0.1;
    double valueEvap = 0.0;
    double value2Evap = 0.02;

    public void setvalue(double d) {
        this.value = d;
    }

    public double getvalue() {
        return this.value;
    }

    public void setvalue2(double d) {
        this.value2 = d;
    }

    public double getvalue2() {
        return this.value2;
    }

    public void setDiffusionValue(double d) {
        this.valueDiff = d;
    }

    public double getDiffusionValue() {
        return this.valueDiff;
    }

    public void setDiffusionValue2(double d) {
        this.value2Diff = d;
    }

    public double getDiffusionValue2() {
        return this.value2Diff;
    }

    public void setEvaporationValue(double d) {
        this.valueEvap = d;
    }

    public double getEvaporationValue() {
        return this.valueEvap;
    }

    public void setEvaporationValue2(double d) {
        this.value2Evap = d;
    }

    public double getEvaporationValue2() {
        return this.value2Evap;
    }

    public DiffusionTest() {
        this.setSimulationName("diffusion test");
        this.setWidth(100);
        this.setHeight(100);
        this.setCellSize(6);
    }

    protected void initializePatchVariables() {
        PatchVariable patchVariable = new PatchVariable("flavor");
        patchVariable.setDiffuseCoef(this.valueDiff);
        patchVariable.setEvapCoef(this.valueEvap);
        this.addPatchVariable(patchVariable);
        PatchVariable patchVariable2 = new PatchVariable("flavor2");
        patchVariable2.setDiffuseCoef(this.value2Diff);
        patchVariable2.setEvapCoef(this.value2Evap);
        this.addPatchVariable(patchVariable2);
    }

    public void addSimulationAgents() {
        this.addObserver(new GridInitializer(this.value, this.value2), false);
        this.addViewer(new FlavorViewer());
        this.addViewer(new FlavorViewer2());
    }
}

