/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

public class ServerSocketToPipe
implements PipeMsgListener,
Runnable {
    private String tagNameSpace = null;
    private String tagName = null;
    private MimeMediaType mediaType = null;
    private ServerSocket socket = null;
    private InputStream ip = null;
    private OutputStream op = null;
    private Thread worker = null;
    private PeerGroup group = null;
    private PipeAdvertisement inPipeAdv = null;
    private PipeAdvertisement outPipeAdv = null;
    private int port = 0;
    private InetAddress serverAddr = null;
    private InputPipe outPipeInputPipe = null;
    private OutputPipe inPipeOutputPipe = null;
    private static long DEFAULT_TIMEOUT = 15000L;

    public ServerSocketToPipe(InetAddress serverAddr, int port, PeerGroup group, PipeAdvertisement inPipeAdv, PipeAdvertisement outPipeAdv, String tagNameSpace, String tagName, MimeMediaType mediaType) throws IOException {
        this.tagNameSpace = tagNameSpace;
        this.tagName = tagName;
        this.mediaType = mediaType;
        this.group = group;
        this.inPipeAdv = inPipeAdv;
        this.outPipeAdv = outPipeAdv;
        this.port = port;
        this.serverAddr = serverAddr;
        PipeService pipeService = group.getPipeService();
        this.outPipeInputPipe = pipeService.createInputPipe(outPipeAdv, this);
        this.socket = new ServerSocket(port, 20, serverAddr);
        this.worker = new Thread((Runnable)this, "ServerSocketToPipe worker thread for " + serverAddr.toString() + ":" + port);
        this.worker.start();
    }

    private void processIncomingData(byte[] buffer) {
        try {
            ByteArrayMessageElement el = new ByteArrayMessageElement(this.tagName, this.mediaType, buffer, null);
            Message msg = new Message();
            msg.addMessageElement(this.tagNameSpace, el);
            if (this.inPipeOutputPipe == null) {
                PipeService pipeService = this.group.getPipeService();
                this.inPipeOutputPipe = pipeService.createOutputPipe(this.inPipeAdv, DEFAULT_TIMEOUT);
            }
            this.inPipeOutputPipe.send(msg);
        }
        catch (Exception ez1) {
            this.close();
        }
    }

    private void processOutgoingData(Message msg) {
        try {
            MessageElement el = msg.getMessageElement(this.tagNameSpace, this.tagName);
            if (el != null) {
                byte[] buffer = el.getBytes(false);
                if (this.op != null) {
                    this.op.write(buffer);
                    this.op.flush();
                }
            }
        }
        catch (Exception ez1) {
            this.close();
        }
    }

    public void run() {
        Socket inSocket = null;
        while (true) {
            try {
                while (true) {
                    byte[] tmp = new byte[1];
                    if (inSocket == null && (inSocket = this.socket.accept()) == null) continue;
                    this.ip = inSocket.getInputStream();
                    this.op = inSocket.getOutputStream();
                    byte[] buffer = null;
                    int tmpsize = this.ip.read(tmp);
                    int avail = this.ip.available();
                    if (avail > 0) {
                        buffer = new byte[avail + 1];
                        buffer[0] = tmp[0];
                        int res = this.ip.read(buffer, 1, avail);
                        if (res > 0) {
                            this.processIncomingData(buffer);
                            continue;
                        }
                        if (inSocket == null) continue;
                        try {
                            inSocket.close();
                        }
                        catch (Exception ez2) {
                            // empty catch block
                        }
                        inSocket = null;
                        continue;
                    }
                    if (tmpsize != 1) continue;
                    this.processIncomingData(tmp);
                }
            }
            catch (Exception ez1) {
                if (inSocket == null) continue;
                try {
                    inSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inSocket = null;
                continue;
            }
            break;
        }
    }

    public void close() {
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            msg = event.getMessage();
            if (msg != null) {
                this.processOutgoingData(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

