/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.jxta.peergroup.PeerGroup;
import net.jxta.util.socket.SocketToPipe;

public class ServerSocketProxy
implements Runnable {
    private ServerSocket serverSocket = null;
    private PeerGroup group = null;
    private ThreadGroup threadGroup = null;
    private int maxThreads = 1;
    private ServerSocketListener listener = null;

    public static ServerSocketProxy listen(int port, int backlog, InetAddress serverAddr, PeerGroup group, ServerSocketListener listener, int maxThreads) throws IOException {
        ServerSocketProxy ssp = new ServerSocketProxy();
        ssp.group = group;
        ssp.serverSocket = new ServerSocket(port, backlog, serverAddr);
        ssp.threadGroup = new ThreadGroup(ssp.serverSocket.toString());
        ssp.maxThreads = maxThreads;
        ssp.listener = listener;
        ssp.createThread();
        return ssp;
    }

    public static ServerSocketProxy listen(ServerSocket serverSocket, PeerGroup group, ServerSocketListener listener, int maxThreads) {
        ServerSocketProxy ssp = new ServerSocketProxy();
        ssp.group = group;
        ssp.serverSocket = serverSocket;
        ssp.threadGroup = new ThreadGroup(ssp.serverSocket.toString());
        ssp.maxThreads = maxThreads;
        ssp.listener = listener;
        ssp.createThread();
        return ssp;
    }

    private void createThread() {
        Thread thread = new Thread(this.threadGroup, this, "ServerSocketProxy Listener thread on " + this.serverSocket.toString());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int maxLoop = 1;
        int loop = 0;
        while (loop++ < maxLoop) {
            ServerSocketProxy serverSocketProxy = this;
            synchronized (serverSocketProxy) {
                if (this.threadGroup.activeGroupCount() > this.maxThreads) {
                    return;
                }
            }
            try {
                Socket socket = this.serverSocket.accept();
                if (socket == null) {
                    this.close();
                    return;
                }
                this.createThread();
                SocketToPipe socketToPipe = new SocketToPipe(socket);
                try {
                    this.listener.accept(socketToPipe);
                }
                catch (Throwable ex) {
                    break;
                }
            }
            catch (Exception ez1) {
                this.close();
                return;
            }
        }
    }

    public void close() {
    }

    public static interface ServerSocketListener {
        public void accept(SocketToPipe var1);
    }
}

