/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.jxta.util.WatchedStream;

public class WatchedOutputStream
extends FilterOutputStream
implements WatchedStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    Collection watchList = null;
    volatile boolean stalled = false;
    volatile boolean idle = true;
    boolean closed = false;
    final int chunkSize;
    OutputStream out = null;

    public WatchedOutputStream(OutputStream out, int chunkSize) {
        super(out);
        this.out = out;
        this.chunkSize = chunkSize;
    }

    public WatchedOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public String toString() {
        if (null == this.out) {
            return "closed/" + super.toString();
        }
        if (this.out instanceof ByteArrayOutputStream) {
            return this.out.getClass().getName() + "@" + System.identityHashCode(this.out) + "/" + super.toString();
        }
        return this.out.toString() + "/" + super.toString();
    }

    public synchronized void setWatchList(Collection watchList) {
        if (this.watchList != null) {
            this.watchList.remove(this);
        }
        this.watchList = watchList;
        watchList.add(this);
    }

    public void watch() {
        if (this.idle) {
            return;
        }
        if (!this.stalled) {
            this.stalled = true;
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.idle = true;
        WatchedOutputStream watchedOutputStream = this;
        synchronized (watchedOutputStream) {
            if (this.watchList != null) {
                this.watchList.remove(this);
                this.watchList = null;
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.stalled = false;
        this.idle = false;
        try {
            this.out.flush();
        }
        finally {
            this.idle = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        this.stalled = false;
        this.idle = false;
        try {
            this.out.write(b);
        }
        finally {
            this.idle = true;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.stalled = false;
        this.idle = false;
        try {
            while (len > this.chunkSize) {
                this.out.write(b, off, this.chunkSize);
                this.stalled = false;
                off += this.chunkSize;
                len -= this.chunkSize;
            }
            if (len > 0) {
                this.out.write(b, off, len);
            }
        }
        finally {
            this.idle = true;
        }
    }
}

