/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.id.IDFactory;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaServerPipe
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger((String)JxtaServerPipe.class.getName());
    protected static final String nameSpace = "JXTABIP";
    protected static final String credTag = "Cred";
    protected static final String reqPipeTag = "reqPipe";
    protected static final String remPeerTag = "remPeer";
    protected static final String remPipeTag = "remPipe";
    protected static final String closeTag = "close";
    protected static final String reliableTag = "reliable";
    private PeerGroup group;
    private InputPipe serverPipe;
    private PipeAdvertisement pipeadv;
    private int backlog = 50;
    private int timeout = 60000;
    private String closeLock = new String("closeLock");
    private UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
    private boolean bound = false;
    private boolean closed = false;
    private boolean stop = false;
    protected StructuredDocument myCredentialDoc = null;

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this(group, pipeadv, 50);
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog, int timeout) throws IOException {
        this(group, pipeadv, backlog);
        this.timeout = timeout;
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.group = group;
        this.pipeadv = pipeadv;
        this.backlog = backlog;
        this.queue.setMaxQueueSize(backlog);
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this.group = group;
        this.pipeadv = pipeadv;
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.backlog = backlog;
        this.bind(group, pipeadv);
        this.queue.setMaxQueueSize(backlog);
    }

    public JxtaBiDiPipe accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("JxtaServerPipe is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("JxtaServerPipe is not bound yet");
        }
        try {
            Message msg;
            JxtaBiDiPipe bidi;
            do {
                if ((msg = (Message)this.queue.pop(this.timeout)) != null) continue;
                throw new SocketException("timed out");
            } while ((bidi = this.processMessage(msg)) == null);
            return bidi;
        }
        catch (InterruptedException ie) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
            throw new SocketException("interrupted");
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeadv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        String string = this.closeLock;
        synchronized (string) {
            if (this.isClosed()) {
                return;
            }
            if (this.bound) {
                this.stop = true;
                this.serverPipe.close();
                this.bound = false;
            }
            this.closed = true;
        }
    }

    void setBound() {
        this.bound = true;
    }

    public synchronized int getPipeTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public synchronized void setPipeTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        String string = this.closeLock;
        synchronized (string) {
            return this.closed;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        boolean pushed;
        block4: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            pushed = false;
            try {
                pushed = this.queue.push(message, -1L);
            }
            catch (InterruptedException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"Interrupted", (Throwable)e);
            }
        }
        if (!pushed && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"backlog queue full, connect request dropped");
        }
    }

    private JxtaBiDiPipe processMessage(Message msg) {
        block9: {
            PipeAdvertisement outputPipeAdv = null;
            PeerAdvertisement peerAdv = null;
            StructuredDocument credDoc = null;
            try {
                Messenger msgr;
                InputStream in;
                MessageElement el = msg.getMessageElement(nameSpace, credTag);
                if (el != null) {
                    in = el.getStream();
                    credDoc = StructuredDocumentFactory.newStructuredDocument(el.getMimeType(), in);
                }
                if ((el = msg.getMessageElement(nameSpace, reqPipeTag)) != null) {
                    in = el.getStream();
                    outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(el.getMimeType(), in);
                }
                if ((el = msg.getMessageElement(nameSpace, remPeerTag)) != null) {
                    in = el.getStream();
                    peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(el.getMimeType(), in);
                }
                el = msg.getMessageElement(nameSpace, reliableTag);
                boolean isReliable = false;
                if (el != null) {
                    isReliable = Boolean.valueOf(el.toString());
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Connection request [isReliable] :" + isReliable));
                    }
                }
                if ((msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, outputPipeAdv, peerAdv)) != null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Reliability set to :" + isReliable));
                    }
                    PipeAdvertisement newpipe = JxtaServerPipe.newInputPipe(this.group, outputPipeAdv);
                    JxtaBiDiPipe pipe = new JxtaBiDiPipe(this.group, msgr, newpipe, credDoc, isReliable);
                    pipe.setRemotePeerAdvertisement(peerAdv);
                    pipe.setRemotePipeAdvertisement(outputPipeAdv);
                    this.sendResponseMessage(this.group, msgr, newpipe);
                    return pipe;
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                LOG.debug((Object)"IOException occured", (Throwable)e);
            }
        }
        return null;
    }

    protected void sendResponseMessage(PeerGroup group, Messenger msgr, PipeAdvertisement pipeAd) throws IOException {
        block4: {
            Message msg = new Message();
            PeerAdvertisement peerAdv = group.getPeerAdvertisement();
            if (this.myCredentialDoc == null) {
                this.myCredentialDoc = JxtaBiDiPipe.getCredDoc(group);
            }
            try {
                if (this.myCredentialDoc != null) {
                    msg.addMessageElement(nameSpace, new InputStreamMessageElement(credTag, MimeMediaType.XMLUTF8, this.myCredentialDoc.getStream(), null));
                }
                msg.addMessageElement(nameSpace, new InputStreamMessageElement(remPipeTag, MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msg.addMessageElement(nameSpace, new InputStreamMessageElement(remPeerTag, MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msgr.sendMessage(msg);
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"error getting element stream", t);
            }
        }
    }

    protected static PipeAdvertisement newInputPipe(PeerGroup group, PipeAdvertisement pipeadv) {
        PipeAdvertisement adv = null;
        adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        adv.setPipeID(IDFactory.newPipeID(group.getPeerGroupID()));
        adv.setName(pipeadv.getName());
        adv.setType(pipeadv.getType());
        return adv;
    }

    public StructuredDocument getCredentialDoc() {
        return this.myCredentialDoc;
    }

    public void setCredentialDoc(StructuredDocument doc) {
        this.myCredentialDoc = doc;
    }
}

