/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.credential.Credential;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.FixedFlowControl;
import net.jxta.impl.util.pipe.reliable.OutgoingMsgrAdaptor;
import net.jxta.impl.util.pipe.reliable.ReliableInputStream;
import net.jxta.impl.util.pipe.reliable.ReliableOutputStream;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaServerPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaBiDiPipe
implements PipeMsgListener,
OutputPipeListener,
ReliableInputStream.MsgListener {
    private static final Logger LOG = Logger.getLogger((String)JxtaBiDiPipe.class.getName());
    private PipeAdvertisement remotePipeAdv;
    private PeerID peerid;
    private PeerAdvertisement remotePeerAdv;
    private int timeout = 60000;
    private UnbiasedQueue queue;
    protected PeerGroup group;
    protected PipeAdvertisement pipeAdv;
    protected PipeAdvertisement myPipeAdv;
    protected PipeService pipeSvc;
    protected InputPipe in;
    protected OutputPipe connectOutpipe;
    protected Messenger msgr;
    protected InputStream stream;
    protected String closeLock = new String("closeLock");
    protected String acceptLock = new String("acceptLock");
    protected String finalLock = new String("finalLock");
    protected boolean closed = false;
    protected boolean bound = false;
    protected PipeMsgListener listener;
    protected Credential credential = null;
    protected boolean waiting;
    protected boolean isReliable = false;
    protected OutgoingMsgrAdaptor outgoing = null;
    protected ReliableInputStream ris = null;
    protected ReliableOutputStream ros = null;
    protected StructuredDocument credentialDoc = null;
    protected StructuredDocument myCredentialDoc = null;

    protected JxtaBiDiPipe(PeerGroup group, Messenger msgr, PipeAdvertisement pipe, StructuredDocument credDoc, boolean isReliable) throws IOException {
        if (msgr == null) {
            throw new IOException("Null Messenger");
        }
        this.group = group;
        this.pipeAdv = pipe;
        this.credentialDoc = credDoc;
        this.pipeSvc = group.getPipeService();
        this.credentialDoc = JxtaBiDiPipe.getCredDoc(group);
        this.in = this.pipeSvc.createInputPipe(pipe, this);
        this.msgr = msgr;
        this.isReliable = isReliable;
        this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
        this.createRLib();
        this.setBound();
    }

    public JxtaBiDiPipe() {
    }

    public JxtaBiDiPipe(PeerGroup group, PipeAdvertisement pipeAd, PipeMsgListener listener) throws IOException {
        this.connect(group, null, pipeAd, this.timeout, listener);
    }

    public JxtaBiDiPipe(PeerGroup group, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener) throws IOException {
        this.connect(group, null, pipeAd, timeout, listener);
    }

    public JxtaBiDiPipe(PeerGroup group, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener, boolean reliable) throws IOException {
        this.connect(group, null, pipeAd, timeout, listener, reliable);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        this.connect(group, pipeAd, this.timeout);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd, int timeout) throws IOException {
        this.connect(group, null, pipeAd, timeout, null);
    }

    public void connect(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener) throws IOException {
        this.connect(group, null, pipeAd, timeout, listener, this.isReliable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener, boolean reliable) throws IOException {
        Message openMsg;
        block22: {
            if (this.isBound()) {
                throw new IOException("Pipe already bound");
            }
            this.pipeAdv = pipeAd;
            this.group = group;
            this.listener = listener;
            this.isReliable = reliable;
            this.pipeSvc = group.getPipeService();
            this.timeout = timeout;
            this.peerid = peerid;
            this.myPipeAdv = JxtaServerPipe.newInputPipe(group, pipeAd);
            this.in = this.pipeSvc.createInputPipe(this.myPipeAdv, this);
            this.credentialDoc = JxtaBiDiPipe.getCredDoc(group);
            openMsg = this.createOpenMessage(group, this.myPipeAdv);
            if (peerid == null) {
                this.pipeSvc.createOutputPipe(pipeAd, this);
            } else {
                this.pipeSvc.createOutputPipe(pipeAd, peerid, (OutputPipeListener)this);
            }
            try {
                String string = this.acceptLock;
                synchronized (string) {
                    if (this.connectOutpipe == null) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Waiting for " + timeout + " msec"));
                        }
                        this.acceptLock.wait(timeout);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block22;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
        }
        if (this.connectOutpipe == null) {
            throw new IOException("connection timeout");
        }
        this.waiting = true;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Sending a backchannel message");
        }
        this.connectOutpipe.send(openMsg);
        try {
            String ie = this.finalLock;
            synchronized (ie) {
                if (this.waiting) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Waiting for " + timeout + " msec for back channel to be established"));
                    }
                    this.finalLock.wait(timeout);
                    if (this.msgr == null) {
                        throw new IOException("connection timeout");
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
            throw new IOException("Interrupted");
        }
        if (listener == null) {
            this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
        }
        this.setBound();
    }

    private void createRLib() {
        if (this.isReliable) {
            if (this.outgoing == null) {
                this.outgoing = new OutgoingMsgrAdaptor(this.msgr, this.timeout);
            }
            if (this.ros == null) {
                this.ros = new ReliableOutputStream(this.outgoing, new FixedFlowControl(20));
            }
            if (this.ris == null) {
                this.ris = new ReliableInputStream(this.outgoing, this.timeout, this);
            }
        }
    }

    public void setReliable(boolean reliable) throws IOException {
        if (this.isBound()) {
            throw new IOException("Can not set reliability after pipe is bound");
        }
        this.isReliable = reliable;
    }

    protected static StructuredDocument getCredDoc(PeerGroup group) {
        block3: {
            try {
                MembershipService membership = group.getMembershipService();
                Credential credential = membership.getDefaultCredential();
                if (credential != null) {
                    return credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
        return null;
    }

    public StructuredDocument getCredentialDoc() {
        return this.credentialDoc;
    }

    public void setCredentialDoc(StructuredDocument doc) {
        this.myCredentialDoc = doc;
    }

    protected Message createOpenMessage(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        Message msg = new Message();
        PeerAdvertisement peerAdv = group.getPeerAdvertisement();
        if (this.myCredentialDoc == null) {
            this.myCredentialDoc = JxtaBiDiPipe.getCredDoc(group);
        }
        if (this.myCredentialDoc == null && pipeAd.getType().equals("JxtaUnicastSecure")) {
            throw new IOException("No credentials established to initiate a secure connection");
        }
        try {
            if (this.myCredentialDoc != null) {
                msg.addMessageElement("JXTABIP", new InputStreamMessageElement("Cred", MimeMediaType.XMLUTF8, this.myCredentialDoc.getStream(), null));
            }
            msg.addMessageElement("JXTABIP", new InputStreamMessageElement("reqPipe", MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            msg.addMessageElement("JXTABIP", new StringMessageElement("reliable", Boolean.toString(this.isReliable), null));
            msg.addMessageElement("JXTABIP", new InputStreamMessageElement("remPeer", MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            return msg;
        }
        catch (Throwable t) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error getting element stream", t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accept(JxtaBiDiPipe s) throws IOException {
        block8: {
            if (this.closed) {
                throw new IOException("Pipe is closed");
            }
            if (!this.isBound()) {
                throw new IOException("Pipe not bound");
            }
            try {
                String string = this.acceptLock;
                synchronized (string) {
                    if (this.connectOutpipe == null) {
                        this.acceptLock.wait(this.timeout);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block8;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
        }
    }

    void setBound() {
        this.bound = true;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe Bound :true");
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public InputPipe getInputPipe() throws IOException {
        return this.in;
    }

    public Messenger getMessenger() throws IOException {
        if (this.isReliable) {
            throw new IOException("Can not access the messenger in reliable mode, use sendMessage instead");
        }
        if (this.msgr == null) {
            int count = -1;
            while (this.msgr == null && !this.closed) {
                if (++count * 500 >= this.timeout) {
                    throw new IOException("JxtaBiDiPipe timed out");
                }
                this.waiter(500);
            }
        }
        if (this.closed) {
            throw new IOException("JxtaBiDiPipe is closed");
        }
        return this.msgr;
    }

    protected synchronized void waiter(int timeMilisecs) {
        try {
            this.wait(timeMilisecs);
        }
        catch (Exception e) {
            LOG.error((Object)"error waiting", (Throwable)e);
        }
    }

    public PeerAdvertisement getRemotePeerAdvertisement() {
        return this.remotePeerAdv;
    }

    public PipeAdvertisement getRemotePipeAdvertisement() {
        return this.remotePipeAdv;
    }

    protected void setRemotePeerAdvertisement(PeerAdvertisement peer) {
        this.remotePeerAdv = peer;
    }

    protected void setRemotePipeAdvertisement(PipeAdvertisement pipe) {
        this.remotePipeAdv = pipe;
    }

    public void close() throws IOException {
        this.sendClose();
        this.closePipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePipe() throws IOException {
        String string = this.closeLock;
        synchronized (string) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.bound = false;
        }
        if (this.isReliable) {
            long quitAt = System.currentTimeMillis() + (long)this.timeout;
            while (this.ros != null) {
                this.ros.setClosing();
                if (this.ros.getMaxAck() == this.ros.getSeqNumber()) break;
                long left = 0L;
                if (this.timeout != 0 && (left = quitAt - System.currentTimeMillis()) < 0L) {
                    this.sendClose();
                    throw new IOException("Close timeout");
                }
                try {
                    this.ros.waitQueueEvent(left);
                }
                catch (InterruptedException ie) {
                    throw new IOException("Close interrupted");
                }
            }
            this.ris.close();
        }
        this.in.close();
        this.msgr.close();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe close complete");
        }
    }

    protected void setInputPipe(InputPipe in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Empty event");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe message arrived");
        }
        MessageElement element2 = null;
        if (!this.bound && (element2 = message.getMessageElement("JXTABIP", "remPipe")) != null) {
            block21: {
                try {
                    StructuredDocument CredDoc = null;
                    InputStream in = element2.getStream();
                    this.remotePipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Recevied a pipe Advertisement :" + this.remotePipeAdv.getName()));
                    }
                    if ((element2 = message.getMessageElement("JXTABIP", "remPeer")) != null) {
                        in = element2.getStream();
                        this.remotePeerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Recevied an Peer Advertisement :" + this.remotePeerAdv.getName()));
                        }
                    } else {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)" BAD connect response");
                        }
                        return;
                    }
                    element2 = message.getMessageElement("JXTABIP", "Cred");
                    if (element2 != null) {
                        in = element2.getStream();
                        CredDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), in);
                    }
                    if ((CredDoc == null || !this.checkCred(CredDoc)) && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"BAD CredDoc");
                        return;
                    }
                    element2 = message.getMessageElement("JXTABIP", "reliable");
                    if (element2 != null) {
                        this.isReliable = Boolean.valueOf(element2.toString());
                    }
                    this.msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, this.remotePipeAdv, this.remotePeerAdv);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Reliability set to :" + this.isReliable));
                    }
                    if (this.isReliable) {
                        this.createRLib();
                    }
                    String string = this.finalLock;
                    synchronized (string) {
                        this.waiting = false;
                        this.finalLock.notifyAll();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block21;
                    LOG.error((Object)"failed to process response message", (Throwable)e);
                }
            }
            return;
        }
        if (this.isReliable) {
            this.receiveMessage(message);
            return;
        }
        if (!this.hasClose(message)) {
            this.push(event);
        }
    }

    private boolean hasClose(Message message) {
        MessageElement element2 = message.getMessageElement("JXTABIP", "close");
        if (element2 != null) {
            block4: {
                try {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Recevied a pipe close request, closing pipes");
                    }
                    this.closePipe();
                }
                catch (IOException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                    LOG.warn((Object)"failed during close", (Throwable)ie);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(Message message) {
        Message.ElementIterator i = message.getMessageElements("jxtarel", Defs.MIME_TYPE_ACK);
        if (i.hasNext()) {
            if (this.ros != null) {
                this.ros.recv(message);
            }
            return;
        }
        i = message.getMessageElements("jxtarel", Defs.MIME_TYPE_BLOCK);
        if (i.hasNext()) {
            try {
                String string = this.finalLock;
                synchronized (string) {
                    while (this.waiting) {
                        this.finalLock.wait(this.timeout);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.ris != null) {
                this.ris.recv(message);
            }
        }
    }

    public void processIncomingMessage(Message message) {
        if (!this.hasClose(message)) {
            PipeMsgEvent event = new PipeMsgEvent(this, message, (PipeID)this.in.getPipeID());
            this.push(event);
        }
    }

    private void push(PipeMsgEvent event) {
        if (this.listener == null) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"push message onto queue");
                }
                this.queue.push(event, -1L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.dequeue();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"calling message listener");
            }
            this.listener.pipeMsgEvent(event);
        }
    }

    public boolean sendMessage(Message msg) throws IOException {
        if (this.isReliable) {
            int seqn = this.ros.send(msg);
            return seqn > 0;
        }
        return this.msgr.sendMessage(msg);
    }

    private void dequeue() {
        while (this.queue != null && this.queue.getCurrentInQueue() > 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"dequeing messages onto message listener");
            }
            this.listener.pipeMsgEvent((PipeMsgEvent)this.queue.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPipeEvent(OutputPipeEvent event) {
        OutputPipe op = event.getOutputPipe();
        if (op.getAdvertisement() == null && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"The output pipe has no internal pipe advertisement. Continueing anyway.");
        }
        if (op.getAdvertisement() == null || this.pipeAdv.equals(op.getAdvertisement())) {
            String string = this.acceptLock;
            synchronized (string) {
                if (this.connectOutpipe == null) {
                    this.connectOutpipe = op;
                    op = null;
                }
                this.acceptLock.notifyAll();
            }
            if (op != null) {
                op.close();
            }
        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Unexpected OutputPipe :" + op));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static Messenger lightweightOutputPipe(PeerGroup group, PipeAdvertisement pipeAdv, PeerAdvertisement peer) {
        void var6_6;
        EndpointAddress addr;
        EndpointService endpoint = group.getEndpointService();
        ID opId = pipeAdv.getPipeID();
        String destPeer = peer.getPeerID().getUniqueValue().toString();
        if (pipeAdv.getType().equals("JxtaUnicast")) {
            addr = new EndpointAddress("jxta", destPeer, "PipeService", opId.toString());
        } else if (pipeAdv.getType().equals("JxtaUnicastSecure")) {
            addr = new EndpointAddress("jxtatls", destPeer, "PipeService", opId.toString());
        } else {
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Creating a lightweightOutputPipe()");
        }
        return endpoint.getMessenger((EndpointAddress)var6_6);
    }

    protected boolean checkCred(StructuredDocument cred) {
        return true;
    }

    private void sendClose() {
        block2: {
            Message msg = new Message();
            msg.addMessageElement("JXTABIP", new StringMessageElement("close", "close", null));
            try {
                this.sendMessage(msg);
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.error((Object)"failed during close", (Throwable)ie);
            }
        }
    }

    public PipeMsgListener getListener() {
        return this.listener;
    }

    public void setListener(PipeMsgListener listener) {
        this.listener = listener;
        this.dequeue();
    }

    public Message getMessage(int timeout) throws InterruptedException {
        if (this.queue == null || this.listener != null) {
            return null;
        }
        PipeMsgEvent ev = (PipeMsgEvent)this.queue.pop(timeout);
        if (ev != null) {
            return ev.getMessage();
        }
        return null;
    }

    public PipeAdvertisement getPipeAdvertisement() {
        return this.pipeAdv;
    }
}

