/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.IDFactory;
import net.jxta.impl.util.ProducerBiasedQueue;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaMulticastSocket
extends MulticastSocket
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger((String)JxtaMulticastSocket.class.getName());
    public static final String NAMESPACE = "JXTAMCAST";
    public static final String DATATAG = "DATAGRAM";
    public static final String SRCIDTAG = "SRCID";
    protected PipeAdvertisement pipeAdv;
    protected PipeService pipeSvc;
    protected InputPipe in;
    protected PeerGroup group;
    protected SocketAddress socketAddress;
    protected InetAddress localAddress;
    protected OutputPipe outputPipe;
    protected boolean closed = false;
    protected boolean bound = false;
    protected ProducerBiasedQueue queue = new ProducerBiasedQueue();
    protected Credential credential = null;
    protected StructuredDocument credentialDoc = null;
    private int timeout = 60000;
    private byte[] fauxip = new byte[4];
    private boolean jxtamode = false;
    private MessageElement srcElement = null;

    public JxtaMulticastSocket(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        this.joinGroup(group, pipeAd);
    }

    public void joinGroup(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        if (pipeAd.getType() != null && !pipeAd.getType().equals("JxtaPropagate")) {
            throw new IOException("Only propagate pipe advertisements are supported");
        }
        if (pipeAd.getPipeID() == null) {
            throw new IOException("Invalid pipe advertisement");
        }
        this.group = group;
        this.pipeAdv = pipeAd;
        this.pipeSvc = group.getPipeService();
        this.in = this.pipeSvc.createInputPipe(pipeAd, this);
        this.credentialDoc = JxtaMulticastSocket.getCredDoc(group);
        this.outputPipe = this.pipeSvc.createOutputPipe(pipeAd, 1L);
        String id = group.getPeerID().getUniqueValue().toString();
        this.srcElement = new StringMessageElement(SRCIDTAG, id, null);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Statring JxtaMulticastSocket on pipe id :" + this.pipeAdv.getID()));
        }
        String pipeStr = pipeAd.getPipeID().getUniqueValue().toString();
        this.localAddress = InetAddress.getByAddress(pipeStr, this.fauxip);
        this.socketAddress = new InetSocketAddress(this.localAddress, 0);
        this.bound = true;
    }

    protected static StructuredDocument getCredDoc(PeerGroup group) {
        block3: {
            try {
                MembershipService membership = group.getMembershipService();
                Enumeration enumeration = membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    Credential credential = (Credential)enumeration.nextElement();
                    return credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isBound() {
        return this.bound;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.bound = false;
        this.closed = true;
        this.in.close();
        this.outputPipe.close();
        this.queue.close();
        this.in = null;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        block5: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            MessageElement element2 = null;
            element2 = message.getMessageElement(NAMESPACE, DATATAG);
            if (element2 == null) {
                return;
            }
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Pushing a message onto queue");
                }
                this.queue.push(message, -1L);
            }
            catch (InterruptedException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                LOG.debug((Object)"Interrupted", (Throwable)e);
            }
        }
    }

    public synchronized int getSoTimeout() {
        return this.timeout;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkState();
        this.timeout = timeout;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private void checkState() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("MulticastSocket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("MulticastSocket not bound");
        }
    }

    public void send(DatagramPacket packet) throws IOException {
        this.checkState();
        byte[] data = packet.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Message msg = new Message();
        msg.addMessageElement(NAMESPACE, this.srcElement);
        msg.addMessageElement(NAMESPACE, new InputStreamMessageElement(DATATAG, MimeMediaType.AOS, bais, null));
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Sending a data packet");
        }
        InetAddress address = packet.getAddress();
        PeerID pid = null;
        if (address != null) {
            String pidStr = address.getHostName();
            try {
                pid = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(pidStr));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (pid != null) {
            OutputPipe op = this.pipeSvc.createOutputPipe(this.pipeAdv, pid, 1L);
            op.send(msg);
            op.close();
        } else {
            this.outputPipe.send(msg);
        }
    }

    public void receive(DatagramPacket packet) throws IOException {
        this.checkState();
        Message msg = null;
        MessageElement del = null;
        MessageElement sel = null;
        try {
            msg = (Message)this.queue.pop(this.timeout);
            if (msg == null) {
                throw new SocketException("Socket timeout reached");
            }
            del = msg.getMessageElement(NAMESPACE, DATATAG);
            sel = msg.getMessageElement(NAMESPACE, SRCIDTAG);
            if (del == null || sel == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Message contains no data element, returning");
                }
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Popped a message off the queue");
            }
        }
        catch (InterruptedException e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Exception occured", (Throwable)e);
            }
            throw new IOException(e.toString());
        }
        if (del.getByteLength() > (long)packet.getLength()) {
            throw new IOException("Datagram can not accomodate message of size :" + del.getByteLength());
        }
        String addrStr = new String(sel.getBytes(false), 0, (int)sel.getByteLength(), "UTF8");
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Src Address :" + addrStr));
        }
        InetAddress address = InetAddress.getByAddress(addrStr, this.fauxip);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Setting Data, and Src Address :" + address));
        }
        packet.setAddress(address);
        packet.setData(del.getBytes(false));
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        return this.localAddress;
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        return this.socketAddress;
    }

    public void bind(SocketAddress addr) throws SocketException {
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
    }
}

