/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;

public abstract class PipeAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private String name = null;
    private String type = null;
    private ID pipeId = ID.nullID;
    private Element description = null;
    public static final String IdTag = "Id";
    public static final String TypeTag = "Type";
    public static final String NameTag = "Name";
    public static final String descTag = "Desc";

    public static String getAdvertisementType() {
        return "jxta:PipeAdvertisement";
    }

    public final String getBaseAdvType() {
        return PipeAdvertisement.getAdvertisementType();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public ID getID() {
        if (this.pipeId.equals(ID.nullID)) {
            throw new IllegalStateException("Pipe has no assigned ID");
        }
        return this.pipeId;
    }

    public ID getPipeID() {
        return this.pipeId;
    }

    public void setPipeID(ID pipeId) {
        if (null == pipeId) {
            throw new IllegalArgumentException("pipeId may not be null");
        }
        this.pipeId = pipeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, descTag, description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }
}

