/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleSpecID;

public abstract class PeerGroupAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private PeerGroupID gid = null;
    private ModuleSpecID specId = null;
    private String name = null;
    private String description = null;
    private Hashtable serviceParams = new Hashtable();

    public static String getAdvertisementType() {
        return "jxta:PGA";
    }

    public final String getBaseAdvType() {
        return PeerGroupAdvertisement.getAdvertisementType();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleSpecID getModuleSpecID() {
        return this.specId;
    }

    public void setModuleSpecID(ModuleSpecID sid) {
        this.specId = sid;
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid;
    }

    public void setPeerGroupID(PeerGroupID gid) {
        this.gid = gid;
    }

    public ID getID() {
        return this.gid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServiceParams(Hashtable params) {
        if (params == null) {
            this.serviceParams = new Hashtable();
            return;
        }
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)params.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key, newDoc);
        }
        this.serviceParams = copy;
    }

    public Hashtable getServiceParams() {
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        Enumeration keys = this.serviceParams.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)this.serviceParams.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key, newDoc);
        }
        return copy;
    }

    public void putServiceParam(ID key, Element param) {
        if (param == null) {
            this.serviceParams.remove(key);
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.serviceParams.put(key, newDoc);
    }

    public StructuredDocument getServiceParam(ID key) {
        Element param = (Element)this.serviceParams.get(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = (Element)this.serviceParams.remove(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }
}

