/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.pipe.OutputPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class OutgoingPipeAdaptor
implements Outgoing,
Runnable {
    private static final Logger LOG = Logger.getLogger((String)OutgoingPipeAdaptor.class.getName());
    private OutputPipe pipe = null;
    private long lastAccessed = 0L;
    private List outQueue = null;
    private Thread pusher = null;

    public OutgoingPipeAdaptor(OutputPipe pipe) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe cannot be null");
        }
        this.pipe = pipe;
        this.lastAccessed = TimeUtils.timeNow();
        this.outQueue = new ArrayList();
        this.pusher = new Thread((Runnable)this, "Reliable OutgoingPipe Message Push Thread");
        this.pusher.setDaemon(true);
        this.pusher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Message msg) throws IOException {
        List list = this.outQueue;
        synchronized (list) {
            while (this.outQueue.size() >= 100) {
                try {
                    this.outQueue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.outQueue.add(msg);
            this.outQueue.notifyAll();
        }
        return true;
    }

    public void close() throws IOException {
        this.pipe.close();
    }

    public long getMinIdleReconnectTime() {
        return 600000L;
    }

    public long getIdleTimeout() {
        return Long.MAX_VALUE;
    }

    public long getMaxRetryAge() {
        return 120000L;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long time) {
        this.lastAccessed = time;
    }

    public String toString() {
        return this.pipe.toString() + " lastAccessed=" + Long.toString(this.lastAccessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: while (true) {
            try {
                while (true) {
                    Message msg = null;
                    List list = this.outQueue;
                    synchronized (list) {
                        while (this.outQueue.isEmpty()) {
                            try {
                                this.outQueue.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        msg = (Message)this.outQueue.remove(0);
                        this.outQueue.notifyAll();
                    }
                    try {
                        this.pipe.send(msg);
                        continue block9;
                    }
                    catch (IOException ex) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)("Failed to send message " + msg));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                return;
            }
        }
    }
}

