/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import net.jxta.endpoint.Message;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.pipe.InputPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class IncomingPipeAdaptor
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)IncomingPipeAdaptor.class.getName());
    private InputPipe pipe = null;
    private Incoming incoming = null;
    private Thread puller = null;

    public IncomingPipeAdaptor(InputPipe pipe, Incoming incoming) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe cannot be null");
        }
        this.pipe = pipe;
        if (incoming == null) {
            throw new IllegalArgumentException("incoming cannot be null");
        }
        this.incoming = incoming;
        this.puller = new Thread((Runnable)this, "Reliable IncomingPipe Message Pull Thread");
        this.puller.setDaemon(true);
        this.puller.start();
    }

    public void run() {
        try {
            while (true) {
                Message msg = null;
                try {
                    msg = this.pipe.waitForMessage();
                }
                catch (InterruptedException ignore) {
                    continue;
                }
                if (msg == null) continue;
                this.incoming.recv(msg);
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            return;
        }
    }
}

