/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;

public class EndpointServiceStatsFilter
implements EndpointFilterListener {
    long lastMessageTime;
    Hashtable channelTrafficTable = new Hashtable();
    Hashtable sourceCountTable = new Hashtable();
    Hashtable destCountTable = new Hashtable();

    public Message processIncomingMessage(Message msg, EndpointAddress source, EndpointAddress dest) {
        Message.ElementIterator e = msg.getMessageElements();
        while (e.hasNext()) {
            MessageElement el = (MessageElement)e.next();
            String namespace = e.getNamespace();
            String name = el.getElementName();
            this.incrementCount(this.channelTrafficTable, source.getProtocolName() + "://" + source.getProtocolAddress() + "/" + namespace, (int)el.getByteLength());
            this.incrementCount(this.channelTrafficTable, source.getProtocolName() + "://" + source.getProtocolAddress() + "/" + name, (int)el.getByteLength());
        }
        if (source != null) {
            this.incrementCount(this.sourceCountTable, source, 1);
        }
        if (dest != null) {
            this.incrementCount(this.destCountTable, dest, 1);
        }
        this.lastMessageTime = System.currentTimeMillis();
        return msg;
    }

    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    public long getTrafficOnChannel(String channel) {
        return this.getCount(this.channelTrafficTable, channel);
    }

    public Enumeration getChannelNames() {
        return this.channelTrafficTable.keys();
    }

    public long getMessageCountFrom(EndpointAddress addr) {
        return this.getCount(this.sourceCountTable, addr);
    }

    public long getMessageCountTo(EndpointAddress addr) {
        return this.getCount(this.destCountTable, addr);
    }

    private long getCount(Hashtable table, Object key) {
        Counter counter = (Counter)table.get(key);
        return counter == null ? -1L : counter.value;
    }

    private void incrementCount(Hashtable table, Object key, int incr) {
        Counter counter = (Counter)table.get(key);
        if (counter == null) {
            counter = new Counter();
            table.put(key, counter);
        }
        counter.value += (long)incr;
    }

    private static final class Counter {
        long value;

        private Counter() {
        }
    }
}

