/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.ResolverSrdiMsgImpl;
import net.jxta.impl.resolver.InternalQueryHandler;
import net.jxta.impl.resolver.ResolverServiceInterface;
import net.jxta.impl.resolver.resolverMeter.ResolverMeter;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitor;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ResolverServiceImpl
implements ResolverService,
EndpointListener {
    private static final transient Logger LOG = Logger.getLogger((String)ResolverServiceImpl.class.getName());
    public static final String outQueNameShort = "ORes";
    public static final String inQueNameShort = "IRes";
    public static final String srdiQueNameShort = "Srdi";
    private static final MimeMediaType GZIP_MEDIA_TYPE = new MimeMediaType("application/gzip");
    private String outQueName = "ORes";
    private String inQueName = "IRes";
    private String srdiQueName = "Srdi";
    private String handlerName = null;
    private PeerGroup myGroup = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private EndpointService endpoint;
    private RendezVousService rendezvous = null;
    private MembershipService membership = null;
    private EndpointRouter endpointRouter;
    private RouteControl routeControl = null;
    private Hashtable handlers = new Hashtable(5);
    private Hashtable srdiHandlers = new Hashtable(5);
    private String localPeerId = null;
    private CredentialListener membershipCredListener = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private RecvDemux recvMux = null;
    private SrdiDemux srdiDemux = null;
    private boolean srdiOn = false;
    private ResolverServiceMonitor resolverServiceMonitor;
    private ResolverMeter resolverMeter;
    private Map pendingDestinations = new HashMap();
    private ResolverService resolverInterface = null;

    private static final EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        Enumeration param;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myGroup = g;
        this.localPeerId = g.getPeerID().toString();
        this.handlerName = assignedID.toString();
        String uniqueStr = g.getPeerGroupID().getUniqueValue().toString();
        this.outQueName = uniqueStr + outQueNameShort;
        this.inQueName = uniqueStr + inQueNameShort;
        this.srdiQueName = uniqueStr + srdiQueNameShort;
        this.localPeerId = g.getPeerID().toString();
        this.recvMux = new RecvDemux();
        StructuredTextDocument params = (StructuredTextDocument)this.implAdvertisement.getParam();
        if (params != null && (param = params.getChildren(srdiQueNameShort)) != null) {
            this.srdiOn = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue());
        }
        this.srdiOn = true;
        if (this.srdiOn) {
            this.srdiDemux = new SrdiDemux();
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Resolver Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + this.myGroup.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + this.myGroup.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + this.myGroup.getPeerID());
            configInfo.append("\n\tFrom Adv:");
            configInfo.append("\n\t\tSRDI Enabled: " + this.srdiOn);
            configInfo.append("\n\tConfiguration:");
            configInfo.append("\n\t\tIn Queue name: " + this.outQueName);
            configInfo.append("\n\t\tOut Queue name: " + this.inQueName);
            configInfo.append("\n\t\tSRDI Queue name: " + this.srdiQueName);
            LOG.info((Object)configInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] arg) {
        this.endpoint = this.myGroup.getEndpointService();
        if (null == this.endpoint) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Stalled until there is an endpoint service");
            }
            return 2;
        }
        this.membership = this.myGroup.getMembershipService();
        if (null == this.membership) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Stalled until there is a membership service");
            }
            return 2;
        }
        this.rendezvous = this.myGroup.getRendezVousService();
        try {
            if (null != this.rendezvous) {
                if (!this.endpoint.addIncomingMessageListener(this, this.handlerName, this.outQueName)) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Cannot register listener (already registered)");
                    }
                } else {
                    this.rendezvous.addPropagateListener(this.handlerName, this.outQueName, this);
                }
                if (!this.endpoint.addIncomingMessageListener(this.recvMux, this.handlerName, this.inQueName)) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Cannot register listener (already registered)");
                    }
                } else {
                    this.rendezvous.addPropagateListener(this.handlerName, this.inQueName, this.recvMux);
                }
                if (this.srdiOn) {
                    if (!this.endpoint.addIncomingMessageListener(this.srdiDemux, this.handlerName, this.srdiQueName)) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"Cannot register listener (already registered)");
                        }
                    } else {
                        this.rendezvous.addPropagateListener(this.handlerName, this.srdiQueName, this.srdiDemux);
                    }
                }
            }
            this.endpointRouter = (EndpointRouter)this.endpoint.getMessageTransport("jxta");
            if (this.endpointRouter != null) {
                this.routeControl = (RouteControl)this.endpointRouter.transportControl(EndpointRouter.GET_ROUTE_CONTROL, null);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"failed to add listeners", (Throwable)e);
            }
            return 1;
        }
        ResolverServiceImpl resolverServiceImpl = this;
        synchronized (resolverServiceImpl) {
            block24: {
                try {
                    this.credential = this.membership.getDefaultCredential();
                    this.credentialDoc = null != this.credential ? this.credential.getDocument(MimeMediaType.XMLUTF8) : null;
                }
                catch (Exception all) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block24;
                    LOG.warn((Object)"could not get credential", (Throwable)all);
                }
            }
            this.membershipCredListener = new CredentialListener();
            this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopApp() {
        if (this.rendezvous != null) {
            this.endpoint.removeIncomingMessageListener(this.handlerName, this.outQueName);
            this.rendezvous.removePropagateListener(this.handlerName, this.outQueName, this);
            this.endpoint.removeIncomingMessageListener(this.handlerName, this.inQueName);
            this.rendezvous.removePropagateListener(this.handlerName, this.inQueName, this.recvMux);
            if (this.srdiOn) {
                this.endpoint.removeIncomingMessageListener(this.handlerName, this.srdiQueName);
                this.rendezvous.removePropagateListener(this.handlerName, this.srdiQueName, this.srdiDemux);
            }
        }
        PendingDestination[] left = null;
        Map map = this.pendingDestinations;
        synchronized (map) {
            left = this.pendingDestinations.values().toArray(new PendingDestination[0]);
            this.pendingDestinations.clear();
        }
        int i = left.length;
        while (i-- > 0) {
            left[i].close();
            left[i] = null;
        }
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.membershipCredListener = null;
        this.endpointRouter = null;
        this.routeControl = null;
        this.rendezvous = null;
        this.membership = null;
        this.myGroup = null;
    }

    public synchronized Service getInterface() {
        if (this.resolverInterface == null) {
            this.resolverInterface = new ResolverServiceInterface(this);
        }
        return this.resolverInterface;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public synchronized QueryHandler registerHandler(String name, QueryHandler handler) {
        return this.handlers.put(name, handler);
    }

    public synchronized QueryHandler unregisterHandler(String name) {
        return (QueryHandler)this.handlers.remove(name);
    }

    public QueryHandler getHandler(String name) {
        return (QueryHandler)this.handlers.get(name);
    }

    public synchronized SrdiHandler registerSrdiHandler(String name, SrdiHandler handler) {
        return this.srdiHandlers.put(name, handler);
    }

    public synchronized SrdiHandler unregisterSrdiHandler(String name) {
        return (SrdiHandler)this.srdiHandlers.remove(name);
    }

    public SrdiHandler getSrdiHandler(String name) {
        return (SrdiHandler)this.srdiHandlers.get(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendQuery(String rdvPeer, ResolverQueryMsg query) {
        if (this.rendezvous == null) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sending query to resolver handler: " + query.getHandlerName()));
        }
        if (!this.myGroup.isRendezvous() && query.getSrcPeerRoute() == null && this.routeControl != null) {
            RouteAdvertisement route = this.routeControl.getMyLocalRoute();
            query.setSrcPeerRoute((RouteAdvertisement)route.clone());
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("sending query with route info to " + route.getDestPeerID()));
            }
        }
        Message propagateMsg = new Message();
        String queryHandlerName = query.getHandlerName();
        Object queryHandlerMeter = null;
        if (rdvPeer == null) {
            try {
                propagateMsg.addMessageElement("jxta", new TextDocumentMessageElement(this.outQueName, (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8), null));
                if (this.srdiOn) {
                    int ttl = 1;
                    if (this.myGroup.isRendezvous()) {
                        ttl = this.myGroup.getRendezVousService().getLocalWalkView().size();
                    }
                    this.rendezvous.walk((Message)propagateMsg.clone(), this.handlerName, this.outQueName, ttl);
                    this.rendezvous.propagateToNeighbors(propagateMsg, this.handlerName, this.outQueName, 2);
                    return;
                }
                this.rendezvous.propagateInGroup(propagateMsg, this.handlerName, this.outQueName, 7, null);
                return;
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Error during propagate", e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (!(e instanceof RuntimeException)) return;
                throw (RuntimeException)e;
            }
        }
        try {
            boolean success = this.sendMessage(rdvPeer, this.handlerName, this.outQueName, this.outQueName, (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8), false);
            return;
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Error while unicasting query", e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (!(e instanceof RuntimeException)) return;
            throw (RuntimeException)e;
        }
    }

    private void propagateQuery(Message msg, ResolverQueryMsg query) {
        block7: {
            if (!this.myGroup.isRendezvous()) {
                return;
            }
            if (query.getHopCount() > 3) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("discarding ResolverQuery hopCount exceeded : " + query.getHopCount()));
                }
                return;
            }
            msg.replaceMessageElement("jxta", new TextDocumentMessageElement(this.outQueName, (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8), null));
            try {
                if (this.srdiOn) {
                    int ttl = this.myGroup.getRendezVousService().getLocalWalkView().size();
                    this.rendezvous.walk((Message)msg.clone(), this.handlerName, this.outQueName, ttl);
                    this.rendezvous.propagateToNeighbors(msg, this.handlerName, this.outQueName, 2);
                } else {
                    this.rendezvous.propagateInGroup(msg, this.handlerName, this.outQueName, 7, this.localPeerId);
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block7;
                LOG.debug((Object)"Error propagating query", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"demuxing a query");
        }
        ResolverQuery query = null;
        Object queryHandlerMeter = null;
        Object queryHandlerName = null;
        MessageElement element2 = message.getMessageElement("jxta", this.outQueName);
        int ttl = 0;
        if (element2 != null) {
            try {
                StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), element2.getStream());
                query = new ResolverQuery(asDoc);
                if (this.myGroup.isRendezvous() && query.getHopCount() == 0) {
                    ttl = this.myGroup.getRendezVousService().getLocalWalkView().size() + 1;
                } else if (query.getHopCount() > 2) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                    LOG.debug((Object)("Query hopCount > 2 :" + query.getHopCount()));
                    return;
                }
                int res = this.processQuery(query, srcAddr);
                int msgTTL = this.getMessageTTL(message);
                if ((msgTTL < 0 || msgTTL >= ttl) && query.getHopCount() > 1) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                    LOG.debug((Object)("Message TTL : " + msgTTL));
                    return;
                }
                if (res != -1) return;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Repropagating query");
                }
                this.propagateQuery(message, query);
                return;
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                LOG.debug((Object)"Could not parse message element, discarding query", (Throwable)e);
                return;
            }
        } else {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
            LOG.debug((Object)"Message does not contain a query. Discarding message");
            return;
        }
    }

    private int getMessageTTL(Message message) {
        LimitedRangeRdvMsg rdvMsg = null;
        MessageElement el = message.getMessageElement("jxta", "LimitedRangeRdvMessage");
        if (el == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Message TTL element does not exist");
            }
            return -1;
        }
        try {
            StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(el.getMimeType(), el.getStream());
            rdvMsg = new LimitedRangeRdvMsg((TextElement)((Object)asDoc));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Failed to parse LimitedRangeRdvMsg from stream", (Throwable)e);
            }
            return -1;
        }
        return rdvMsg.getTTL();
    }

    private int processQuery(ResolverQueryMsg query, EndpointAddress srcAddr) {
        QueryHandler theHandler;
        String queryHandlerName = ((ResolverQuery)query).getHandlerName();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + queryHandlerName));
        }
        if ((theHandler = this.getHandler(queryHandlerName)) == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Discarding query, no handler for " + queryHandlerName));
            }
            return -1;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + queryHandlerName));
        }
        Object queryHandlerMeter = null;
        long startTime = 0L;
        try {
            int result = theHandler instanceof InternalQueryHandler ? ((InternalQueryHandler)theHandler).processQuery(query, srcAddr) : theHandler.processQuery(query);
            return result;
        }
        catch (Throwable any) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("processQuery : Uncaught Throwable from handler for: " + queryHandlerName), any);
            }
            return 0;
        }
    }

    private void processResponse(ResolverResponseMsg resp) {
        this.processResponse(resp, null);
    }

    private void processResponse(ResolverResponseMsg resp, EndpointAddress srcAddr) {
        block9: {
            QueryHandler theHandler;
            String handlerName = resp.getHandlerName();
            if (handlerName == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"missing handlername in response");
                }
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Calling " + handlerName + ".processResponse()"));
            }
            if ((theHandler = this.getHandler(handlerName)) != null) {
                Object queryHandlerMeter = null;
                long startTime = 0L;
                try {
                    if (theHandler instanceof InternalQueryHandler) {
                        ((InternalQueryHandler)theHandler).processResponse(resp, srcAddr);
                        break block9;
                    }
                    theHandler.processResponse(resp);
                }
                catch (Throwable all) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("processResponse : Uncaught Throwable from handler for: " + handlerName), all);
                    }
                    break block9;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("No handler registered :" + handlerName));
            }
        }
    }

    private void processSrdiMsg(ResolverSrdiMsg srdi, EndpointAddress srcAddr) {
        SrdiHandler theHandler;
        String handlerName = srdi.getHandlerName();
        if (handlerName == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"missing handlername in response");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("pushing a srdi msg for " + handlerName));
        }
        if ((theHandler = this.getSrdiHandler(handlerName)) != null) {
            Object srdiHandlerMeter = null;
            try {
                long startTime = 0L;
                theHandler.processSrdi(srdi);
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("processSrdi : Uncaught Throwable from handler for: " + handlerName), all);
                }
            }
        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("No srdi handler registered :" + handlerName));
        }
    }

    public void sendResponse(String destPeer, ResolverResponseMsg response) {
        block11: {
            if (destPeer == null) {
                this.propagateResponse(response);
            } else {
                String queryHandlerName = response.getHandlerName();
                Object queryHandlerMeter = null;
                try {
                    RouteAdvertisement route = response.getSrcPeerRoute();
                    if (route == null) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"No route info available to send a response");
                        }
                    } else if (this.routeControl.addRoute(route) == -1) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("Failed to add route" + route.display()));
                        }
                    } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Add route to issuer " + route.getDestPeerID()));
                    }
                    boolean success = this.sendMessage(destPeer, this.handlerName, this.inQueName, this.inQueName, (XMLDocument)response.getDocument(MimeMediaType.XMLUTF8), false);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                    LOG.warn((Object)"error in sending response", (Throwable)e);
                }
            }
        }
    }

    public void sendSrdi(String destPeer, ResolverSrdiMsg srdi) {
        block7: {
            String srdiHandlerName = srdi.getHandlerName();
            Object srdiHandlerMeter = null;
            if (destPeer == null) {
                if (this.rendezvous == null) {
                    return;
                }
                Message propagateMsg = new Message();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gos = new GZIPOutputStream(baos);
                    srdi.getDocument(MimeMediaType.XMLUTF8).sendToStream(gos);
                    gos.finish();
                    gos.close();
                    propagateMsg.addMessageElement("jxta", new ByteArrayMessageElement(this.srdiQueName, GZIP_MEDIA_TYPE, baos.toByteArray(), null));
                    this.rendezvous.walk((Message)propagateMsg.clone(), this.handlerName, this.srdiQueName, 1);
                    this.rendezvous.propagateToNeighbors(propagateMsg, this.handlerName, this.srdiQueName, 2);
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"failure sending srdi message", (Throwable)e);
                    }
                    break block7;
                }
            }
            try {
                boolean success = this.sendMessage(destPeer, this.handlerName, this.srdiQueName, this.srdiQueName, (XMLDocument)srdi.getDocument(MimeMediaType.XMLUTF8), true);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"error in sending srdi message", (Throwable)e);
            }
        }
    }

    private void propagateResponse(ResolverResponseMsg response) {
        block5: {
            if (this.rendezvous == null) {
                return;
            }
            Message propagateMsg = new Message();
            String queryHandlerName = response.getHandlerName();
            Object queryHandlerMeter = null;
            try {
                XMLDocument responseDoc = (XMLDocument)response.getDocument(MimeMediaType.XMLUTF8);
                propagateMsg.addMessageElement("jxta", new TextDocumentMessageElement(this.inQueName, responseDoc, null));
                if (this.srdiOn) {
                    this.rendezvous.walk((Message)propagateMsg.clone(), this.handlerName, this.inQueName, 1);
                    this.rendezvous.propagateToNeighbors(propagateMsg, this.handlerName, this.inQueName, 1);
                } else {
                    this.rendezvous.propagateInGroup(propagateMsg, this.handlerName, this.inQueName, 1, null);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                LOG.debug((Object)"failure on propagateResponse", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessage(String destPeer, String pName, String pParam, String tagName, StructuredTextDocument response, boolean gzip) throws IOException {
        ID dest;
        try {
            dest = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException badpeer) {
            IOException failure = new IOException("bad destination peer");
            failure.initCause(badpeer);
            throw failure;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("destPeer :" + destPeer + "\n\tsendMessage to " + pName + "  " + pParam + " " + tagName));
        }
        Message msg = new Message();
        try {
            MessageElement msgEl;
            if (gzip) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                response.sendToStream(gos);
                gos.finish();
                gos.close();
                msgEl = new ByteArrayMessageElement(tagName, GZIP_MEDIA_TYPE, baos.toByteArray(), null);
            } else {
                msgEl = new TextDocumentMessageElement(tagName, response, null);
            }
            msg.addMessageElement("jxta", msgEl);
        }
        catch (Exception ez1) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed building message", (Throwable)ez1);
            }
            return false;
        }
        EndpointAddress destAddress = ResolverServiceImpl.mkAddress(dest, pName, pParam);
        PendingDestination pending = null;
        int attempts = 2;
        while (attempts-- > 0) {
            Map map = this.pendingDestinations;
            synchronized (map) {
                pending = (PendingDestination)this.pendingDestinations.get(destAddress);
                if (pending == null) {
                    pending = new PendingDestination(this.endpoint, destAddress, (PeerID)dest, this.srdiHandlers);
                    this.pendingDestinations.put(destAddress, pending);
                }
            }
            if (!pending.sendMessage(msg)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePendingDestination(EndpointAddress toRemove) {
        Map map = this.pendingDestinations;
        synchronized (map) {
            this.pendingDestinations.remove(toRemove);
        }
    }

    class PendingDestination
    implements MessengerEventListener,
    OutgoingMessageEventListener {
        private static final int MAXPENDING = 4;
        private EndpointAddress destAddress = null;
        private Messenger messenger = null;
        private List pendingMessages = null;
        private EndpointService endpoint = null;
        private boolean isClosed = true;
        private int messageCount = 0;
        private PeerID peerid = null;
        private Hashtable handlers = null;

        PendingDestination(EndpointService endpoint, EndpointAddress destAddress, PeerID peerid, Hashtable srdiHandlers) {
            this.endpoint = endpoint;
            this.destAddress = destAddress;
            this.peerid = peerid;
            this.handlers = srdiHandlers;
            this.isClosed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ResolverServiceImpl.this.removePendingDestination(this.destAddress);
            Messenger closeIt = null;
            PendingDestination pendingDestination = this;
            synchronized (pendingDestination) {
                this.isClosed = true;
                closeIt = this.messenger;
                this.messenger = null;
                if (this.pendingMessages != null) {
                    this.pendingMessages.clear();
                    this.pendingMessages = null;
                }
            }
            if (closeIt != null) {
                closeIt.close();
            }
        }

        public void finalize() {
            if (this.isClosed) {
                return;
            }
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean messengerReady(MessengerEvent e) {
            List sendMe = null;
            Messenger useMe = null;
            PendingDestination pendingDestination = this;
            synchronized (pendingDestination) {
                if (this.messenger != null) {
                    return false;
                }
                useMe = e.getMessenger();
                if (useMe != null) {
                    this.messenger = useMe;
                    sendMe = this.pendingMessages;
                    this.pendingMessages = null;
                }
            }
            if (useMe != null) {
                if (sendMe != null) {
                    Iterator msgs = sendMe.iterator();
                    while (msgs.hasNext()) {
                        useMe.sendMessage((Message)msgs.next(), null, null, this);
                    }
                    sendMe.clear();
                }
                return true;
            }
            Iterator it = this.handlers.values().iterator();
            while (it.hasNext()) {
                SrdiHandler theHandler = (SrdiHandler)it.next();
                theHandler.messageSendFailed(this.peerid, null);
            }
            this.close();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSendSucceeded(OutgoingMessageEvent e) {
            PendingDestination pendingDestination = this;
            synchronized (pendingDestination) {
                if (--this.messageCount != 0) {
                    return;
                }
            }
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSendFailed(OutgoingMessageEvent e) {
            if (e.getFailure() == null) {
                return;
            }
            PendingDestination pendingDestination = this;
            synchronized (pendingDestination) {
                if (--this.messageCount != 0) {
                    return;
                }
            }
            Iterator it = this.handlers.values().iterator();
            while (it.hasNext()) {
                SrdiHandler theHandler = (SrdiHandler)it.next();
                theHandler.messageSendFailed(this.peerid, e);
            }
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sendMessage(Message msg) {
            if (msg == null) {
                return true;
            }
            Messenger m = null;
            boolean pending = false;
            PendingDestination pendingDestination = this;
            synchronized (pendingDestination) {
                if (this.isClosed) {
                    return false;
                }
                if (this.messenger == null) {
                    boolean bl = pending = this.pendingMessages != null;
                    if (!pending) {
                        this.pendingMessages = new ArrayList(4);
                        this.pendingMessages.add(msg);
                    } else if (this.pendingMessages.size() <= 4) {
                        this.pendingMessages.add(msg);
                    }
                } else {
                    m = this.messenger;
                }
                ++this.messageCount;
            }
            if (m != null) {
                m.sendMessage(msg, null, null, this);
                return true;
            }
            if (pending) {
                return true;
            }
            this.endpoint.getMessenger(this, this.destAddress, null);
            return true;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PendingDestination)) {
                return false;
            }
            PendingDestination pending = (PendingDestination)other;
            return pending.destAddress.equals(this.destAddress);
        }

        public int hashCode() {
            return this.destAddress.hashCode();
        }

        public String toString() {
            return this.destAddress.toString();
        }
    }

    class SrdiDemux
    implements EndpointListener {
        SrdiDemux() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            MessageElement element2;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("demuxing an srdi message from : " + srcAddr));
            }
            if ((element2 = message.getMessageElement("jxta", ResolverServiceImpl.this.srdiQueName)) != null) {
                ResolverSrdiMsgImpl resp = null;
                try {
                    if (element2.getMimeType().equals(GZIP_MEDIA_TYPE)) {
                        StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new GZIPInputStream(element2.getStream()));
                        resp = new ResolverSrdiMsgImpl(asDoc, ResolverServiceImpl.this.membership);
                    } else {
                        StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), element2.getStream());
                        resp = new ResolverSrdiMsgImpl(asDoc, ResolverServiceImpl.this.membership);
                    }
                    ResolverServiceImpl.this.processSrdiMsg(resp, srcAddr);
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Ill formatted resolver srdi message, ignoring.", (Throwable)e);
                    }
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Message does not contain a SRDI element. Discarding message");
            }
        }
    }

    class RecvDemux
    implements EndpointListener {
        RecvDemux() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            MessageElement element2;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("demuxing a response from : " + dstAddr));
            }
            if ((element2 = message.getMessageElement("jxta", ResolverServiceImpl.this.inQueName)) != null) {
                try {
                    StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), element2.getStream());
                    ResolverResponse resp = new ResolverResponse(asDoc);
                    ResolverServiceImpl.this.processResponse(resp, srcAddr);
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Ill formatted resolver response, ignoring.", (Throwable)e);
                    }
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Message does not contain a response. Discarding message");
            }
        }
    }

    private class CredentialListener
    implements PropertyChangeListener {
        private CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"New default credential event");
                }
                ResolverServiceImpl resolverServiceImpl = ResolverServiceImpl.this;
                synchronized (resolverServiceImpl) {
                    ResolverServiceImpl.this.credential = (Credential)evt.getNewValue();
                    if (null != ResolverServiceImpl.this.credential) {
                        try {
                            ResolverServiceImpl.this.credentialDoc = ResolverServiceImpl.this.credential.getDocument(MimeMediaType.XMLUTF8);
                        }
                        catch (Exception all) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"could not get credential", (Throwable)all);
                            }
                        }
                    } else {
                        ResolverServiceImpl.this.credentialDoc = null;
                    }
                }
            }
        }
    }
}

