/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.rpv.PeerViewDestination;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewEvent;
import net.jxta.impl.rendezvous.rpv.PeerViewListener;
import net.jxta.impl.rendezvous.rpv.PeerViewRandomStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewRandomWithReplaceStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewSequentialStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewStrategy;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PeerView
implements EndpointListener,
RendezvousListener {
    private static final transient Logger LOG = Logger.getLogger((String)PeerView.class.getName());
    static final String SERVICE_NAME = "PeerView";
    static final String MESSAGE_NAMESPACE = "jxta";
    static final String MESSAGE_ELEMENT_NAME = "PeerView.PeerAdv";
    static final String RESPONSE_ELEMENT_NAME = "PeerView.PeerAdv.Response";
    static final String CACHED_RADV_ELEMENT_NAME = "PeerView.Cached";
    static final MessageElement CACHED_RADV_ELEMENT = new StringMessageElement("PeerView.Cached", Boolean.TRUE.toString(), null);
    static final String SRCROUTEADV_ELEMENT_NAME = "PeerView.SrcRouteAdv";
    static final String EDGE_ELEMENT_NAME = "PeerView.EdgePeer";
    static final MessageElement EDGE_ELEMENT = new StringMessageElement("PeerView.EdgePeer", Boolean.TRUE.toString(), null);
    static final String FAILURE_ELEMENT_NAME = "PeerView.Failure";
    static final MessageElement FAILURE_ELEMENT = new StringMessageElement("PeerView.Failure", Boolean.TRUE.toString(), null);
    private static final long DEFAULT_SEEDING_PERIOD = 5000L;
    private static final long WATCHDOG_PERIOD = 30000L;
    private static final long WATCHDOG_GRACE_DELAY = 300000L;
    private static final long DEFAULT_BOOTSTRAP_KICK_INTERVAL = 3000L;
    private static final int MIN_BOOTLEVEL = 0;
    private static final int BOOTLEVEL_INCREMENT = 1;
    private static final int MAX_EDGE_PEER_BOOTLEVEL = 8;
    private static final int MAX_RDV_PEER_BOOTLEVEL = 6;
    private static final long DEFAULT_RADV_LIFETIME = 86400000L;
    private static final long DEFAULT_RADV_EXPIRATION = 3600000L;
    private static final int DEFAULT_SEEDING_RDVPEERS = 5;
    private PeerGroup group;
    private PeerGroup advertisingGroup;
    private RendezVousServiceImpl rdvService;
    private EndpointService endpoint;
    private final String name;
    private long seedingRdvConnDelay = 0L;
    private boolean probeRelays = false;
    private boolean useOnlySeeds = false;
    private int minHappyPeerView = 4;
    private List seedHosts = new ArrayList();
    private Timer timer;
    private static final Random random = new Random();
    private final Set scheduledTasks = Collections.synchronizedSet(new HashSet());
    private int bootLevel = 0;
    private final String uniqueGroupId;
    private Set rpvListeners = Collections.synchronizedSet(new HashSet());
    private InputPipe wirePipeInputPipe = null;
    private OutputPipe wirePipeOutputPipe = null;
    private InputPipe localGroupWirePipeInputPipe = null;
    private OutputPipe localGroupWirePipeOutputPipe = null;
    private long earliestReseed = 0L;
    private volatile boolean closed = false;
    private WatchdogTask watchdogTask = null;
    private final SortedSet localView = Collections.synchronizedSortedSet(new TreeSet());
    private PeerViewElement self = null;
    private PeerViewElement upPeer = null;
    private PeerViewElement downPeer = null;
    private PeerViewStrategy replyStrategy;
    private PeerViewStrategy kickRecipientStrategy;
    private PeerViewStrategy kickAdvertisementStrategy;
    private PeerViewStrategy refreshRecipientStrategy;
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private final PipeAdvertisement localGroupWirePipeAdv;
    private final PipeAdvertisement advGroupPropPipeAdv;

    public PeerView(PeerGroup group, PeerGroup advertisingGroup, RendezVousServiceImpl rdvService, String name) {
        this.group = group;
        this.rdvService = rdvService;
        this.name = name;
        this.endpoint = group.getEndpointService();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TimerThreadNamer("PeerView Timer for " + group.getPeerGroupID()), 0L);
        ConfigParams confAdv = group.getConfigAdvertisement();
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                StructuredTextDocument configDoc = (StructuredTextDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof RdvConfigAdv) {
                RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)adv;
                this.seedHosts.addAll(Arrays.asList(rdvConfigAdv.getSeedRendezvous()));
                this.useOnlySeeds = rdvConfigAdv.getUseOnlySeeds();
                if (0L != rdvConfigAdv.getSeedRendezvousConnectDelay()) {
                    this.seedingRdvConnDelay = rdvConfigAdv.getSeedRendezvousConnectDelay();
                }
                this.probeRelays = rdvConfigAdv.getProbeRelays();
                if (0 != rdvConfigAdv.getMinHappyPeerView()) {
                    this.minHappyPeerView = rdvConfigAdv.getMinHappyPeerView();
                }
            }
        }
        this.advertisingGroup = advertisingGroup;
        this.uniqueGroupId = group.getPeerGroupID().getUniqueValue().toString();
        this.refreshSelf();
        this.endpoint.addIncomingMessageListener(this, SERVICE_NAME, this.uniqueGroupId);
        rdvService.addListener(this);
        this.replyStrategy = new PeerViewRandomWithReplaceStrategy(this.localView);
        this.kickRecipientStrategy = new PeerViewRandomStrategy(this.localView);
        this.kickAdvertisementStrategy = new PeerViewRandomWithReplaceStrategy(this.localView);
        this.refreshRecipientStrategy = new PeerViewSequentialStrategy(this.localView);
        this.localGroupWirePipeAdv = this.makeWirePipeAdvertisement(group);
        this.advGroupPropPipeAdv = null != advertisingGroup ? this.makeWirePipeAdvertisement(advertisingGroup) : null;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("PeerView created for group \"" + group.getPeerGroupName() + "\" [" + group.getPeerGroupID() + "] name \"" + name + "\""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        PeerViewElement sendpve;
        PeerViewElement pve;
        boolean isFromEdge;
        boolean isCached;
        RdvAdvertisement radv;
        boolean isResponse;
        boolean localIsEdge;
        block38: {
            DiscoveryService discovery;
            MessageElement me;
            block37: {
                Advertisement adv;
                localIsEdge = !this.rdvService.isRendezVous();
                isResponse = false;
                me = msg.getMessageElement(MESSAGE_NAMESPACE, MESSAGE_ELEMENT_NAME);
                if (me == null) {
                    me = msg.getMessageElement(MESSAGE_NAMESPACE, RESPONSE_ELEMENT_NAME);
                    if (me == null) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("Discarding damaged " + msg + "."));
                        }
                        return;
                    }
                    isResponse = true;
                }
                try {
                    adv = AdvertisementFactory.newAdvertisement(me.getMimeType(), me.getStream());
                }
                catch (IOException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Failed building rdv advertisement", (Throwable)failed);
                    }
                    return;
                }
                catch (NoSuchElementException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Could not build rdv advertisement", (Throwable)failed);
                    }
                    return;
                }
                if (!(adv instanceof RdvAdvertisement)) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Response does not contain radv (" + adv.getAdvertisementType() + ")"));
                    }
                    return;
                }
                radv = (RdvAdvertisement)adv;
                me = msg.getMessageElement(MESSAGE_NAMESPACE, SRCROUTEADV_ELEMENT_NAME);
                if (me != null) {
                    try {
                        Advertisement routeAdv = AdvertisementFactory.newAdvertisement(me.getMimeType(), me.getStream());
                        if (!(routeAdv instanceof RouteAdvertisement)) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Advertisement is not a RouteAdvertisement");
                            }
                        } else {
                            RouteAdvertisement rdvRouteAdv = (RouteAdvertisement)radv.getRouteAdv().clone();
                            RouteAdvertisement.stichRoute(rdvRouteAdv, (RouteAdvertisement)routeAdv);
                            radv.setRouteAdv(rdvRouteAdv);
                        }
                    }
                    catch (IOException failed) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block37;
                        LOG.warn((Object)"Failed getting stream for message element", (Throwable)failed);
                    }
                }
            }
            me = null;
            if (this.group.getPeerID().equals(radv.getPeerID())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Received a PeerView message about self. Discard.");
                }
                return;
            }
            boolean isFailure = msg.getMessageElement(MESSAGE_NAMESPACE, FAILURE_ELEMENT_NAME) != null;
            isCached = msg.getMessageElement(MESSAGE_NAMESPACE, CACHED_RADV_ELEMENT_NAME) != null;
            boolean bl = isFromEdge = msg.getMessageElement(MESSAGE_NAMESPACE, EDGE_ELEMENT_NAME) != null;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Received a" + (isCached ? " cached" : "") + (isResponse ? " response" : "") + (isFailure ? " failure" : "") + " message" + (isFromEdge ? " from edge" : "") + " regarding \"" + radv.getName() + "\" from " + srcAddr));
            }
            if (isFailure) {
                this.notifyFailure(radv.getPeerID(), false);
                return;
            }
            if (!isFromEdge && !isCached && (discovery = this.group.getDiscoveryService()) != null) {
                try {
                    discovery.publish(radv, 86400000L, 3600000L);
                }
                catch (IOException ex) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block38;
                    LOG.warn((Object)("Could not publish " + radv.getName()), (Throwable)ex);
                }
            }
        }
        boolean isNewbie = false;
        boolean added = false;
        int viewSize = 0;
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            PeerViewElement newbie = new PeerViewElement(this.endpoint, radv);
            pve = this.getPeerViewElement(newbie);
            if (null == pve) {
                pve = newbie;
                isNewbie = true;
            }
            if (!(isFromEdge || isCached || this.useOnlySeeds && !this.isSeedRdv(radv))) {
                if (isNewbie) {
                    added = this.addPeerViewElement(pve);
                } else {
                    pve.setRdvAdvertisement(radv);
                }
            }
            viewSize = this.localView.size();
        }
        if (added) {
            this.generateEvent(10, pve);
        }
        if (!(isCached || localIsEdge || isResponse)) {
            boolean status = this.send(pve, this.self, true, false);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Type 1 (Respond with self) : Sent to " + pve + " result=" + status));
            }
        }
        if ((isCached && isNewbie && (!isResponse || viewSize < this.minHappyPeerView) || !isCached && isNewbie && !isResponse && !isFromEdge) && !this.useOnlySeeds) {
            boolean status = this.send(pve, this.self, false, false);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Type 2 (Probe PVE) : Probed " + pve + " result=" + status));
            }
        }
        if (!(isCached || isResponse || (sendpve = this.replyStrategy.next()) == null || pve.equals(sendpve) || this.self.equals(sendpve))) {
            boolean status = this.send(pve, sendpve, true, false);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Type 3 (Respond with random pve) : Sent " + sendpve + " to " + pve + " result=" + status));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendezvousEvent(RendezvousEvent event) {
        if (this.closed) {
            return;
        }
        boolean notifyFailure = false;
        PeerView peerView = this;
        synchronized (peerView) {
            int theEventType = event.getType();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + "] Processing  " + event));
            }
            this.refreshSelf();
            if ((8 == theEventType || 9 == theEventType) && null != this.watchdogTask) {
                this.removeTask(this.watchdogTask);
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
            switch (theEventType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    this.openWirePipes();
                    this.watchdogTask = new WatchdogTask();
                    this.addTask(this.watchdogTask, 30000L, 30000L);
                    this.rescheduleKick(true);
                    break;
                }
                case 9: {
                    this.openWirePipes();
                    if (!this.localView.isEmpty()) {
                        notifyFailure = true;
                    }
                    this.rescheduleKick(true);
                    break;
                }
                default: {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                    LOG.warn((Object)("[" + this.group.getPeerGroupName() + "] Unexpected RDV event : " + event));
                }
            }
        }
        if (notifyFailure) {
            this.notifyFailure(this.self, true);
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PeerView peerView = this;
        synchronized (peerView) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.rdvService.isRendezVous()) {
            this.notifyFailure(this.self, true);
        }
        peerView = this;
        synchronized (peerView) {
            if (this.watchdogTask != null) {
                this.removeTask(this.watchdogTask);
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
            this.endpoint.removeIncomingMessageListener(SERVICE_NAME, this.uniqueGroupId);
            this.rdvService.removeListener(this);
            Set set = this.scheduledTasks;
            synchronized (set) {
                Iterator eachTask = this.scheduledTasks.iterator();
                while (eachTask.hasNext()) {
                    try {
                        TimerTask task = (TimerTask)eachTask.next();
                        task.cancel();
                        eachTask.remove();
                    }
                    catch (Exception ez1) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"Cannot cancel task: ", (Throwable)ez1);
                    }
                }
            }
            this.closeWirePipes();
            this.downPeer = null;
            this.upPeer = null;
            this.self = null;
            this.localView.clear();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.rpvListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(TimerTask task, long delay, long interval) {
        Set set = this.scheduledTasks;
        synchronized (set) {
            if (this.scheduledTasks.contains(task) && LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Task list already contains specified task.");
            }
            this.scheduledTasks.add(task);
        }
        if (interval >= 1L) {
            this.timer.schedule(task, delay, interval);
        } else {
            this.timer.schedule(task, delay);
        }
    }

    protected void removeTask(TimerTask task) {
        this.scheduledTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeed(URI seed) {
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            if (!this.seedHosts.contains(seed)) {
                this.seedHosts.add(seed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean probeAddress(EndpointAddress address, Object hint) {
        PeerViewElement holdIt = null;
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            holdIt = this.self;
        }
        return this.send(address, hint, holdIt, false, false);
    }

    public void seed() {
        long reseedRemaining = this.earliestReseed - TimeUtils.timeNow();
        if (reseedRemaining > 0L) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Still Seeding for " + reseedRemaining + "ms."));
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"New Seeding...");
        }
        long iterations = 0L;
        if (this.useOnlySeeds || this.localView.size() < this.minHappyPeerView) {
            ArrayList seedRdvs = new ArrayList(this.seedHosts);
            Collections.shuffle(seedRdvs);
            while (seedRdvs.size() > 0) {
                if (!this.sendRandomByAddr(seedRdvs, 5, this.seedingRdvConnDelay + 5000L * iterations)) continue;
                ++iterations;
            }
        }
        if (this.useOnlySeeds) {
            this.earliestReseed = TimeUtils.timeNow() + this.seedingRdvConnDelay + 5000L * iterations;
            return;
        }
        this.timedSend(this.self, (EndpointAddress)null, 10000L);
        if (this.localView.size() >= this.minHappyPeerView) {
            return;
        }
        if (this.advertisingGroup != null) {
            this.scheduleAdvertisingGroupQuery(10000L);
        }
        List rdvs = this.discoverRdvAdverisements();
        Collections.shuffle(rdvs);
        while (rdvs.size() > 0) {
            if (!this.sendRandomByAdv(rdvs, 5, 5000L * iterations)) continue;
            ++iterations;
        }
        if (this.probeRelays) {
            List relays = this.getRelayPeers();
            Collections.shuffle(relays);
            while (relays.size() > 0) {
                if (!this.sendRandomByAdv(relays, 5, 5000L * iterations)) continue;
                ++iterations;
            }
        }
        this.earliestReseed = TimeUtils.timeNow() + 5000L * iterations;
    }

    private boolean isSeedRdv(RdvAdvertisement rdvAdv) {
        RouteAdvertisement radv = rdvAdv.getRouteAdv();
        if (radv == null) {
            return false;
        }
        AccessPointAdvertisement apAdv = radv.getDest();
        if (apAdv == null) {
            return false;
        }
        List addrVect = (List)apAdv.getVectorEndpointAddresses().clone();
        if (addrVect == null || addrVect.size() == 0) {
            return false;
        }
        ListIterator<URI> eachAddr = addrVect.listIterator();
        while (eachAddr.hasNext()) {
            String anAddr = (String)eachAddr.next();
            try {
                eachAddr.set(URI.create(anAddr));
            }
            catch (IllegalArgumentException badURI) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Skipping bad URI : " + anAddr));
            }
        }
        addrVect.retainAll(this.seedHosts);
        return addrVect.size() > 0;
    }

    private void scheduleOpenPipes(long delay) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Scheduling open pipes attempt in " + delay + "ms."));
        }
        this.addTask(new OpenPipesTask(), delay, -1L);
    }

    private boolean send(PeerViewElement dest, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        boolean result = dest.sendMessage(msg, SERVICE_NAME, this.uniqueGroupId);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending " + msg + " to " + dest + " success = " + result));
        }
        return result;
    }

    private boolean send(EndpointAddress dest, Object hint, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        if (null != dest) {
            EndpointAddress realAddr = new EndpointAddress(dest, SERVICE_NAME, this.uniqueGroupId);
            Messenger messenger = this.rdvService.endpoint.getMessengerImmediate(realAddr, hint);
            if (null != messenger) {
                try {
                    boolean result = messenger.sendMessage(msg);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sending " + msg + " to " + dest + " success = " + result));
                    }
                    return result;
                }
                catch (IOException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Could not send " + msg + " to " + dest), (Throwable)failed);
                    }
                    return false;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not get messenger for " + dest));
            }
            return false;
        }
        try {
            this.endpoint.propagate(msg, SERVICE_NAME, this.uniqueGroupId);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sent " + msg + " via propagate"));
            }
            return true;
        }
        catch (IOException ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not propagate " + msg), (Throwable)ez);
            }
            return false;
        }
    }

    private boolean send(OutputPipe dest, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        try {
            return dest.send(msg);
        }
        catch (IOException ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not send " + msg), (Throwable)ez);
            }
            return false;
        }
    }

    private Message makeMessage(PeerViewElement content, boolean response, boolean failure) {
        Message msg;
        block6: {
            msg = new Message();
            if (!this.rdvService.isRendezVous()) {
                msg.addMessageElement(MESSAGE_NAMESPACE, EDGE_ELEMENT);
            }
            if (failure) {
                msg.addMessageElement(MESSAGE_NAMESPACE, FAILURE_ELEMENT);
            }
            this.refreshSelf();
            RdvAdvertisement radv = content.getRdvAdvertisement();
            TextDocument doc = (TextDocument)radv.getDocument(MimeMediaType.XMLUTF8);
            String msgName = response ? RESPONSE_ELEMENT_NAME : MESSAGE_ELEMENT_NAME;
            TextDocumentMessageElement msge = new TextDocumentMessageElement(msgName, doc, null);
            msg.addMessageElement(MESSAGE_NAMESPACE, msge);
            if (!content.equals(this.self)) {
                msg.addMessageElement(MESSAGE_NAMESPACE, CACHED_RADV_ELEMENT);
                RouteAdvertisement localra = this.getRouteAdv(this.lastPeerAdv);
                if (localra != null) {
                    try {
                        TextDocument radoc = (TextDocument)localra.getDocument(MimeMediaType.XMLUTF8);
                        msge = new TextDocumentMessageElement(SRCROUTEADV_ELEMENT_NAME, radoc, null);
                        msg.addMessageElement(MESSAGE_NAMESPACE, msge);
                    }
                    catch (Exception ez1) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                        LOG.warn((Object)("Could not create optional src route adv for " + content), (Throwable)ez1);
                    }
                }
            }
        }
        return msg;
    }

    public void notifyFailure(PeerID pid, boolean propagate) {
        PeerViewElement pve = this.getPeerViewElement(pid);
        if (null != pve) {
            this.notifyFailure(pve, propagate);
        }
    }

    void notifyFailure(PeerViewElement pve, boolean propagateFailure) {
        block7: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Notifying failure of " + pve));
            }
            try {
                OutputPipe op;
                boolean emptyPeerView;
                boolean removedFromPeerView = this.removePeerViewElement(pve);
                propagateFailure &= removedFromPeerView || this.self == pve;
                if (removedFromPeerView) {
                    this.generateEvent(12, pve);
                }
                if ((emptyPeerView = this.localView.isEmpty()) && removedFromPeerView) {
                    this.rescheduleKick(true);
                }
                if (propagateFailure && null != (op = this.localGroupWirePipeOutputPipe)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Propagating failure of " + pve));
                    }
                    this.send(op, pve, true, true);
                }
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)("Failure while generating noficiation of failure of PeerView : " + pve), (Throwable)ez);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kick() {
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Begun kick() in " + this.group.getPeerGroupID()));
            }
            this.seed();
            PeerViewElement refreshee = this.refreshRecipientStrategy.next();
            if (refreshee != null && this.self != refreshee) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Refresh " + refreshee));
                }
                this.send(refreshee, this.self, false, false);
            }
            if (!this.rdvService.isRendezVous()) {
                return;
            }
            PeerViewElement recipient = this.kickRecipientStrategy.next();
            if (recipient == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No recipient to send adv ");
                }
                return;
            }
            PeerViewElement rpve = this.kickAdvertisementStrategy.next();
            if (rpve == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No adv to send");
                }
                return;
            }
            if (rpve.equals(recipient) || this.self.equals(recipient)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"adv to send is same as recipient: Nothing to do.");
                }
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending adv " + rpve + " to " + recipient));
            }
            this.send(recipient, rpve, true, false);
        }
        finally {
            this.rescheduleKick(false);
        }
    }

    private int adjustBootLevel() {
        boolean areWeHappy = this.localView.size() >= this.minHappyPeerView;
        int increment = areWeHappy ? 1 : 2;
        int maxbootlevel = this.rdvService.isRendezVous() ? 6 : 8;
        this.bootLevel = Math.min(maxbootlevel -= areWeHappy ? 0 : 1, this.bootLevel + increment);
        return this.bootLevel;
    }

    private synchronized void rescheduleKick(boolean now) {
        block6: {
            if (this.closed) {
                return;
            }
            try {
                if (now) {
                    this.bootLevel = 0;
                } else {
                    this.adjustBootLevel();
                }
                long tilNextKick = 3000L * ((1L << this.bootLevel) - 1L);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Scheduling kick in " + tilNextKick / 1000L + " seconds at bootLevel " + this.bootLevel + " in group " + this.group.getPeerGroupID()));
                }
                KickerTask task = new KickerTask();
                this.addTask(task, tilNextKick, -1L);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                LOG.error((Object)"Cannot set timer. RPV will not work.", (Throwable)ez1);
            }
        }
    }

    private boolean sendRandomByAdv(List rdvs, int maxNb, long delay) {
        if (rdvs.isEmpty()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No RDV peers to send queries");
            }
            return false;
        }
        int counter = Math.min(maxNb, rdvs.size());
        while (counter-- > 0) {
            RdvAdvertisement radv = (RdvAdvertisement)rdvs.remove(0);
            PeerViewElement pve = new PeerViewElement(this.endpoint, radv);
            this.timedSend(this.self, pve, delay);
        }
        return true;
    }

    private boolean sendRandomByAddr(List rdvs, int maxNb, long delay) {
        if (rdvs.isEmpty()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"No RDV peers to send queries");
            }
            return false;
        }
        int counter = Math.min(maxNb, rdvs.size());
        while (counter-- > 0) {
            EndpointAddress dest = new EndpointAddress((URI)rdvs.remove(0));
            this.timedSend(this.self, dest, delay);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private List discoverRdvAdverisements() {
        void var3_3;
        ArrayList<RdvAdvertisement> v = new ArrayList<RdvAdvertisement>();
        DiscoveryService discovery = this.group.getDiscoveryService();
        if (discovery == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Discovery is not yet enabled.");
            }
            return v;
        }
        try {
            Enumeration rdvs = discovery.getLocalAdvertisements(2, "RdvServiceName", this.name);
            discovery.getRemoteAdvertisements(null, 2, "RdvServiceName", this.name, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed getting RdvAdvertisements from local discovery", (Throwable)e);
            }
            return v;
        }
        while (var3_3.hasMoreElements()) {
            RdvAdvertisement rdv;
            Advertisement adv = (Advertisement)var3_3.nextElement();
            if (!(adv instanceof RdvAdvertisement) || !(rdv = (RdvAdvertisement)adv).getGroupID().equals(this.group.getPeerGroupID()) || this.group.getPeerID().equals(rdv.getPeerID())) continue;
            v.add(rdv);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSelf() {
        DiscoveryService discovery;
        RdvAdvertisement radv = null;
        PeerView peerView = this;
        synchronized (peerView) {
            PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.lastPeerAdv != newPadv || this.lastModCount != newModCount) {
                this.lastPeerAdv = newPadv;
                this.lastModCount = newModCount;
                radv = this.createRdvAdvertisement(this.lastPeerAdv);
                if (radv != null) {
                    if (null == this.self) {
                        this.self = new PeerViewElement(this.endpoint, radv);
                    } else {
                        this.self.setRdvAdvertisement(radv);
                    }
                }
            }
        }
        if (radv != null && null != (discovery = this.group.getDiscoveryService())) {
            try {
                if (this.rdvService.isRendezVous()) {
                    discovery.publish(radv, 86400000L, 3600000L);
                } else {
                    discovery.flushAdvertisement(radv);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private RouteAdvertisement getRouteAdv(PeerAdvertisement padv) {
        RouteAdvertisement route = null;
        TextElement endpParam = (TextElement)((Object)padv.getServiceParam(PeerGroup.endpointClassID));
        if (endpParam == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"no Endpoint Params");
            }
            return null;
        }
        Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
        TextElement param = null;
        if (!paramChilds.hasMoreElements()) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)" no Endpoint Route Adv");
            }
            return null;
        }
        param = (TextElement)paramChilds.nextElement();
        route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
        route.setDestPeerID(padv.getPeerID());
        return route;
    }

    private RdvAdvertisement createRdvAdvertisement(PeerAdvertisement padv) {
        try {
            RdvAdvertisement rdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
            rdv.setPeerID(padv.getPeerID());
            rdv.setGroupID(padv.getPeerGroupID());
            rdv.setServiceName(this.name);
            rdv.setName(padv.getName());
            RouteAdvertisement ra = this.getRouteAdv(padv);
            rdv.setRouteAdv(ra);
            return rdv;
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot create Local RdvAdvertisement: ", (Throwable)ez);
            }
            return null;
        }
    }

    public boolean addListener(PeerViewListener listener) {
        boolean added = this.rpvListeners.add(listener);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Registered PeerViewEvent Listener (" + listener.getClass().getName() + ")"));
        }
        return added;
    }

    public boolean removeListener(PeerViewListener listener) {
        boolean removed = this.rpvListeners.remove(listener);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Removed PeerViewEvent Listener (" + listener.getClass().getName() + ")"));
        }
        return removed;
    }

    private void generateEvent(int type, PeerViewElement element2) {
        PeerViewEvent newevent = new PeerViewEvent(this, type, element2);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Calling listeners for " + newevent + " in group " + this.group.getPeerGroupID()));
        }
        Iterator<Object> eachListener = Arrays.asList(this.rpvListeners.toArray()).iterator();
        while (eachListener.hasNext()) {
            PeerViewListener pvl = (PeerViewListener)eachListener.next();
            try {
                pvl.peerViewEvent(newevent);
            }
            catch (Throwable ignored) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                LOG.error((Object)("Uncaught Throwable in PeerViewEvent listener : (" + pvl.getClass().getName() + ")"), ignored);
            }
        }
    }

    private PipeAdvertisement makeWirePipeAdvertisement(PeerGroup destGroup) {
        PipeAdvertisement adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        PipeID pipeId = IDFactory.newPipeID(destGroup.getPeerGroupID(), (SERVICE_NAME + this.group.getPeerGroupID().getUniqueValue().toString() + this.name).getBytes());
        adv.setPipeID(pipeId);
        adv.setType("JxtaPropagate");
        adv.setName("PeerView pipe for " + this.group.getPeerGroupID());
        return adv;
    }

    private synchronized void openWirePipes() {
        PipeService pipes = this.group.getPipeService();
        if (null == pipes) {
            this.scheduleOpenPipes(1000L);
            return;
        }
        try {
            if (this.rdvService.isRendezVous()) {
                if (null == this.localGroupWirePipeInputPipe) {
                    this.localGroupWirePipeInputPipe = pipes.createInputPipe(this.localGroupWirePipeAdv, new WirePipeListener());
                }
                if (null == this.localGroupWirePipeOutputPipe) {
                    this.localGroupWirePipeOutputPipe = pipes.createOutputPipe(this.localGroupWirePipeAdv, 1000L);
                }
                if (this.localGroupWirePipeOutputPipe == null && LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Cannot get OutputPipe for current group");
                }
            } else {
                if (null != this.localGroupWirePipeInputPipe) {
                    this.localGroupWirePipeInputPipe.close();
                    this.localGroupWirePipeInputPipe = null;
                }
                if (null != this.localGroupWirePipeOutputPipe) {
                    this.localGroupWirePipeOutputPipe.close();
                    this.localGroupWirePipeOutputPipe = null;
                }
            }
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not open pipes in local group. Trying again in 1 second.", (Throwable)failed);
            }
            this.scheduleOpenPipes(1000L);
            return;
        }
        if (this.advertisingGroup != null) {
            try {
                pipes = this.advertisingGroup.getPipeService();
                if (null == pipes) {
                    this.scheduleOpenPipes(1000L);
                    return;
                }
                if (this.rdvService.isRendezVous()) {
                    if (null == this.wirePipeInputPipe) {
                        this.wirePipeInputPipe = pipes.createInputPipe(this.advGroupPropPipeAdv, new WirePipeListener());
                    }
                } else if (this.wirePipeInputPipe != null) {
                    this.wirePipeInputPipe.close();
                    this.wirePipeInputPipe = null;
                }
                if (null == this.wirePipeOutputPipe) {
                    this.wirePipeOutputPipe = pipes.createOutputPipe(this.advGroupPropPipeAdv, 1000L);
                }
                if (this.wirePipeOutputPipe == null && LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Cannot get OutputPipe for current group");
                }
            }
            catch (Exception failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Could not open pipes in local group. Trying again in 1 second.", (Throwable)failed);
                }
                this.scheduleOpenPipes(1000L);
                return;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Propagate Pipes opened.");
        }
    }

    private synchronized void closeWirePipes() {
        if (this.localGroupWirePipeInputPipe != null) {
            this.localGroupWirePipeInputPipe.close();
            this.localGroupWirePipeInputPipe = null;
        }
        if (this.localGroupWirePipeOutputPipe != null) {
            this.localGroupWirePipeOutputPipe.close();
            this.localGroupWirePipeOutputPipe = null;
        }
        if (this.wirePipeInputPipe != null) {
            this.wirePipeInputPipe.close();
            this.wirePipeInputPipe = null;
        }
        if (this.wirePipeOutputPipe != null) {
            this.wirePipeOutputPipe.close();
            this.wirePipeOutputPipe = null;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Propagate Pipes closed.");
        }
    }

    private synchronized void scheduleAdvertisingGroupQuery(long delay) {
        if (this.closed) {
            return;
        }
        AdvertisingGroupQueryTask task = new AdvertisingGroupQueryTask();
        this.addTask(task, delay, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getView() {
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            return new TreeSet(this.localView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPeerViewElement(PeerViewElement pve) {
        boolean added;
        if (null == pve.getRdvAdvertisement()) {
            throw new IllegalStateException("Cannot add a seed pve to local view");
        }
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            added = this.localView.add(pve);
            if (added) {
                this.updateUpAndDownPeers();
            }
        }
        if (added) {
            pve.setPeerView(this);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePeerViewElement(PeerViewElement pve) {
        boolean removed;
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            removed = this.localView.remove(pve);
            if (removed) {
                this.updateUpAndDownPeers();
            }
        }
        if (removed) {
            pve.setPeerView(null);
        }
        return removed;
    }

    public PeerViewElement getPeerViewElement(PeerViewDestination wanted) {
        try {
            PeerViewElement found = (PeerViewElement)this.localView.tailSet(wanted).first();
            if (wanted.equals(found)) {
                return found;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public PeerViewElement getPeerViewElement(ID pid) {
        return this.getPeerViewElement(new PeerViewDestination(pid));
    }

    public PeerViewElement getDownPeer() {
        return this.downPeer;
    }

    public PeerViewElement getSelf() {
        return this.self;
    }

    public PeerViewElement getUpPeer() {
        return this.upPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUpAndDownPeers() {
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            PeerViewElement oldDown = this.downPeer;
            PeerViewElement oldUp = this.upPeer;
            SortedSet<PeerViewElement> headSet = this.localView.headSet(this.self);
            this.downPeer = headSet.size() > 0 ? headSet.last() : null;
            SortedSet<PeerViewElement> tailSet = this.localView.tailSet(this.self);
            if (tailSet.size() > 0) {
                if (this.self.equals(tailSet.first())) {
                    Iterator eachTail = tailSet.iterator();
                    eachTail.next();
                    this.upPeer = eachTail.hasNext() ? (PeerViewElement)eachTail.next() : null;
                } else {
                    this.upPeer = tailSet.first();
                }
            } else {
                this.upPeer = null;
            }
            if (oldDown != this.downPeer && this.downPeer != null) {
                this.downPeer.setLastUpdateTime(TimeUtils.timeNow());
            }
            if (oldUp != this.upPeer && this.upPeer != null) {
                this.upPeer.setLastUpdateTime(TimeUtils.timeNow());
            }
        }
    }

    private List getRelayPeers() {
        ArrayList<EndpointAddress> res;
        block4: {
            res = new ArrayList<EndpointAddress>();
            try {
                EndpointService ep = this.group.getEndpointService();
                Iterator it = ep.getAllMessageTransports();
                while (it.hasNext()) {
                    RelayClient er;
                    Vector v;
                    MessageTransport mt = (MessageTransport)it.next();
                    if (!(mt instanceof RelayClient) || (v = (er = (RelayClient)mt).getActiveRelays(null)) == null) continue;
                    Iterator eachRelay = v.iterator();
                    while (eachRelay.hasNext()) {
                        PeerID peerid = ((AccessPointAdvertisement)eachRelay.next()).getPeerID();
                        res.add(new EndpointAddress(MESSAGE_NAMESPACE, peerid.getUniqueValue().toString(), null, null));
                    }
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)"Unexpected error getting relays", (Throwable)ez1);
            }
        }
        return res;
    }

    private synchronized void timedSend(PeerViewElement pve, PeerViewElement dest, long delay) {
        if (this.closed) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Timed send of " + pve + " to " + dest + " in " + delay / 1000L + " seconds"));
        }
        TimedSendTask task = new TimedSendTask(dest, pve);
        this.addTask(task, delay, -1L);
    }

    private synchronized void timedSend(PeerViewElement pve, EndpointAddress destAddr, long delay) {
        if (this.closed) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Timed send of " + pve + " to " + destAddr + " in " + delay / 1000L + " seconds"));
        }
        TimedSendTask task = new TimedSendTask(destAddr, pve);
        this.addTask(task, delay, -1L);
    }

    private final class TimedSendTask
    extends TimerTask {
        private PeerViewElement pve = null;
        private PeerViewElement destpve = null;
        private EndpointAddress destaddr = null;

        public TimedSendTask(EndpointAddress dest, PeerViewElement pve) {
            this.destaddr = dest;
            this.pve = pve;
        }

        public TimedSendTask(PeerViewElement destpve, PeerViewElement pve) {
            this.destpve = destpve;
            this.pve = pve;
        }

        public synchronized boolean cancel() {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Canceling TimedSendTask for : " + this.pve));
            }
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (PeerView.this.closed) {
                    return;
                }
                if (null != this.destpve) {
                    boolean status = PeerView.this.send(this.destpve, this.pve, false, false);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("pv.send to " + this.destpve + " status=" + status));
                    }
                } else {
                    boolean status = PeerView.this.send(this.destaddr, null, this.pve, false, false);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("pv.send to " + this.destaddr + " status=" + status));
                    }
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), all);
                }
            }
            finally {
                PeerView.this.removeTask(this);
            }
        }
    }

    private final class KickerTask
    extends TimerTask {
        private KickerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (PeerView.this.closed) {
                    return;
                }
                PeerView.this.kick();
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
            finally {
                PeerView.this.removeTask(this);
            }
        }
    }

    private final class WatchdogTask
    extends TimerTask {
        private WatchdogTask() {
        }

        public void run() {
            block14: {
                try {
                    PeerViewElement down;
                    PeerViewElement up;
                    if (PeerView.this.closed) {
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Watchdog task executing for group " + PeerView.this.group.getPeerGroupID()));
                    }
                    if ((up = PeerView.this.getUpPeer()) != null) {
                        if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), up.getLastUpdateTime()) > 300000L) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("UP peer has gone MIA : " + up));
                            }
                            PeerView.this.notifyFailure(up, true);
                        } else {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Checking on UP peer : " + up));
                            }
                            PeerView.this.send(up, PeerView.this.getSelf(), false, false);
                        }
                    }
                    if ((down = PeerView.this.getDownPeer()) != null) {
                        if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), down.getLastUpdateTime()) > 300000L) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("DOWN peer has gone MIA : " + down));
                            }
                            PeerView.this.notifyFailure(down, true);
                        } else {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Checking on DOWN peer : " + down));
                            }
                            PeerView.this.send(down, PeerView.this.getSelf(), false, false);
                        }
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block14;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private final class AdvertisingGroupQueryTask
    extends TimerTask {
        private AdvertisingGroupQueryTask() {
        }

        public boolean cancel() {
            boolean res = super.cancel();
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (PeerView.this.closed) {
                    return;
                }
                OutputPipe op = PeerView.this.wirePipeOutputPipe;
                if (null != op) {
                    Message msg = PeerView.this.makeMessage(PeerView.this.self, false, false);
                    op.send(msg);
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
            finally {
                PeerView.this.removeTask(this);
            }
        }
    }

    private class WirePipeListener
    implements PipeMsgListener {
        private WirePipeListener() {
        }

        public void pipeMsgEvent(PipeMsgEvent event) {
            block5: {
                int randinview;
                int viewsize;
                boolean response;
                Message msg = event.getMessage();
                boolean failure = null != msg.getMessageElement(PeerView.MESSAGE_NAMESPACE, PeerView.FAILURE_ELEMENT_NAME);
                boolean bl = response = null != msg.getMessageElement(PeerView.MESSAGE_NAMESPACE, PeerView.RESPONSE_ELEMENT_NAME);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Received a PeerView " + (failure ? "failure " : "") + (response ? "response " : "") + "message [" + msg + "] on propagated pipe " + event.getPipeID()));
                }
                if (!failure && !response && (viewsize = PeerView.this.localView.size()) > PeerView.this.minHappyPeerView && (randinview = random.nextInt(viewsize)) >= PeerView.this.minHappyPeerView) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Ignoring " + msg + " from pipe " + event.getPipeID()));
                    }
                    return;
                }
                EndpointAddress src = new EndpointAddress(event.getPipeID(), PeerView.SERVICE_NAME, null);
                EndpointAddress dest = new EndpointAddress(event.getPipeID(), PeerView.SERVICE_NAME, null);
                try {
                    PeerView.this.processIncomingMessage(msg, src, dest);
                }
                catch (Throwable ez) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)("Failed processing " + msg + " from pipe " + event.getPipeID()), ez);
                }
            }
        }
    }

    private class OpenPipesTask
    extends TimerTask {
        private OpenPipesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (PeerView.this.closed) {
                    return;
                }
                PeerView.this.openWirePipes();
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread: " + Thread.currentThread().getName()), all);
                }
            }
            finally {
                PeerView.this.removeTask(this);
            }
        }
    }
}

