/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousServiceInterface;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.adhoc.AdhocPeerRdvService;
import net.jxta.impl.rendezvous.edge.EdgePeerRdvService;
import net.jxta.impl.rendezvous.rdv.RdvPeerRdvService;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezVousStatus;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class RendezVousServiceImpl
implements RendezVousService {
    private static final transient Logger LOG = Logger.getLogger((String)RendezVousServiceImpl.class.getName());
    private static final double DEMOTION_FACTOR = 0.05;
    private static final long DEMOTION_MIN_PEERVIEW_COUNT = 5L;
    private static final long DEMOTION_MIN_CLIENT_COUNT = 3L;
    protected static final int MAX_MSGIDS = 1000;
    private static Random random = new Random();
    private PeerGroup group = null;
    private PeerGroup advGroup = null;
    private ID assignedID = null;
    public EndpointService endpoint = null;
    private RendezvousServiceMonitor rendezvousServiceMonitor;
    private RdvConfigAdv.RendezVousConfiguration config = RdvConfigAdv.RendezVousConfiguration.EDGE;
    private boolean autoRendezvous = false;
    private String[] savedArgs = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    volatile RendezVousServiceProvider provider = null;
    private Set eventListeners = Collections.synchronizedSet(new HashSet());
    private Map propListeners = new HashMap();
    private RendezVousMonitor monitor = null;
    private RendezVousManager manager = null;
    private Timer timer = null;
    private long rdv_watchdog_default = 300000L;
    private long rdv_watchdog_interval = 300000L;
    private List msgIds = new ArrayList(1000);
    private int messagesReceived;
    private Boolean rdvProviderSwitchLock = Boolean.FALSE;
    public volatile PeerView rpv = null;

    protected static RouteAdvertisement extractRouteAdv(PeerAdvertisement adv) {
        try {
            XMLElement endpParam = (XMLElement)((Object)adv.getServiceParam(PeerGroup.endpointClassID));
            if (endpParam == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No Endpoint Params");
                }
                return null;
            }
            Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
            XMLElement param = null;
            if (!paramChilds.hasMoreElements()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No Route Adv in Peer Adv");
                }
                return null;
            }
            param = (XMLElement)paramChilds.nextElement();
            RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
            route.setDestPeerID(adv.getPeerID());
            return route;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"failed to extract radv", (Throwable)e);
            }
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.stopApp();
    }

    public Service getInterface() {
        return new RendezVousServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public ID getAssignedID() {
        return this.assignedID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PeerGroup g, ID assignedID, Advertisement impl) {
        ConfigParams confAdv;
        this.group = g;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.advGroup = g.getParentGroup();
        if (null == this.advGroup || PeerGroupID.worldPeerGroupID.equals(this.advGroup.getPeerGroupID())) {
            this.advGroup = this.group;
        }
        if ((confAdv = g.getConfigAdvertisement()) != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(this.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof RdvConfigAdv) {
                RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)adv;
                this.config = rdvConfigAdv.getConfiguration();
                this.autoRendezvous = rdvConfigAdv.getAutoRendezvousCheckInterval() > 0L;
                this.rdv_watchdog_default = rdvConfigAdv.getAutoRendezvousCheckInterval();
            }
        }
        if (PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            this.config = RdvConfigAdv.RendezVousConfiguration.AD_HOC;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring RendezVous Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + this.group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + this.group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null != this.advGroup) {
                configInfo.append("\n\t\tAdvertising group : " + this.advGroup.getPeerGroupName() + " [" + this.advGroup.getPeerGroupID() + "]");
            } else {
                configInfo.append("\n\t\tAdvertising group : (none)");
            }
            configInfo.append("\n\t\tRendezVous : " + this.config);
            configInfo.append("\n\t\tAuto RendezVous : " + this.autoRendezvous);
            configInfo.append("\n\t\tRendezVous Watchdog Delay : " + this.rdv_watchdog_interval);
            LOG.info((Object)configInfo);
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            this.rdvProviderSwitchLock = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Stalled until there is an endpoint service");
            }
            return 2;
        }
        MembershipService needed = this.group.getMembershipService();
        if (null == needed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Stalled until there is a membership service");
            }
            return 2;
        }
        if (RdvConfigAdv.RendezVousConfiguration.AD_HOC != this.config) {
            this.rpv = new PeerView(this.group, this.advGroup, this, this.getAssignedID().toString() + this.group.getPeerGroupID().getUniqueValue().toString());
            this.rpv.start();
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (RdvConfigAdv.RendezVousConfiguration.AD_HOC == this.config) {
                this.provider = new AdhocPeerRdvService(this.group, this);
            } else if (RdvConfigAdv.RendezVousConfiguration.EDGE == this.config) {
                this.provider = new EdgePeerRdvService(this.group, this);
            } else if (RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS == this.config) {
                this.provider = new RdvPeerRdvService(this.group, this);
            } else {
                throw new IllegalStateException("Unrecognized rendezvous configuration");
            }
            this.provider.startApp(null);
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
        if (this.autoRendezvous && !PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            this.startWatchDogTimer();
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Rendezvous Serivce started");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopApp() {
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopApp();
                this.provider = null;
            }
        }
        if (this.rpv != null) {
            this.rpv.stop();
            this.rpv = null;
        }
        Iterator eachListener = this.propListeners.keySet().iterator();
        while (eachListener.hasNext()) {
            String aListener = (String)eachListener.next();
            try {
                this.endpoint.removeIncomingMessageListener(aListener, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            eachListener.remove();
        }
        this.propListeners.clear();
        this.monitor = null;
        this.manager = null;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.msgIds.clear();
        this.eventListeners.clear();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Rendezvous Serivce stopped");
        }
    }

    public boolean isRendezVous() {
        RendezVousStatus currentStatus = this.getRendezVousStatus();
        return RendezVousStatus.AUTO_RENDEZVOUS == currentStatus || RendezVousStatus.RENDEZVOUS == currentStatus;
    }

    public RendezVousStatus getRendezVousStatus() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            return RendezVousStatus.NONE;
        }
        if (currentProvider instanceof AdhocPeerRdvService) {
            return RendezVousStatus.ADHOC;
        }
        if (currentProvider instanceof EdgePeerRdvService) {
            return this.autoRendezvous ? RendezVousStatus.AUTO_EDGE : RendezVousStatus.EDGE;
        }
        if (currentProvider instanceof RdvPeerRdvService) {
            return this.autoRendezvous ? RendezVousStatus.AUTO_RENDEZVOUS : RendezVousStatus.RENDEZVOUS;
        }
        return RendezVousStatus.UNKNOWN;
    }

    public boolean setAutoStart(boolean auto) {
        return this.setAutoStart(auto, this.rdv_watchdog_default);
    }

    public synchronized boolean setAutoStart(boolean auto, long period) {
        this.rdv_watchdog_interval = period;
        boolean old = this.autoRendezvous;
        this.autoRendezvous = auto;
        if (auto && !old) {
            this.startWatchDogTimer();
        } else if (old && !auto) {
            this.stopWatchDogTimer();
        }
        return old;
    }

    public RendezVousMonitor getMonitor() {
        return this.monitor;
    }

    public final RendezVousMonitor setMonitor(RendezVousMonitor handler) {
        RendezVousMonitor old = this.monitor;
        this.monitor = handler;
        return old;
    }

    public RendezVousManager getManager() {
        return this.manager;
    }

    public void setManager(RendezVousManager manager) {
        this.manager = manager;
    }

    private void connectToRendezVous(EndpointAddress addr, RouteAdvertisement routeHint) throws IOException {
        PeerView currView = this.rpv;
        if (null == currView) {
            throw new IOException("No PeerView");
        }
        currView.addSeed(addr.toURI());
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.setChoiceDelay(0L);
        }
        if (!currView.probeAddress(addr, routeHint)) {
            throw new IOException("Could not probe:" + addr);
        }
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        EndpointAddress addr = new EndpointAddress("jxta", adv.getPeerID().getUniqueValue().toString(), null, null);
        this.connectToRendezVous(addr, RendezVousServiceImpl.extractRouteAdv(adv));
    }

    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        this.connectToRendezVous(addr, null);
    }

    public void challengeRendezVous(ID peer, long delay) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.challengeRendezVous(peer, delay);
        }
    }

    public void disconnectFromRendezVous(ID peerId) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.disconnectFromRendezVous(peerId);
        }
    }

    public Enumeration getConnectedRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedRendezVous();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getDisconnectedRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getDisconnectedRendezVous();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getConnectedPeers() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedPeers();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Vector getConnectedPeerIDs() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedPeerIDs();
        }
        return new Vector();
    }

    public boolean isConnectedToRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.isConnectedToRendezVous();
        }
        return false;
    }

    public void startRendezVous() {
        block2: {
            try {
                this.startRendezVous(null);
            }
            catch (IOException failure) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"Failed to start rendezvous", (Throwable)failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRendezVous(RendezVousManager manager) throws IOException {
        if (this.isRendezVous() || PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            return;
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (this.rdvProviderSwitchLock.booleanValue()) {
                IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed to start rendezvous", (Throwable)failed);
                }
                throw failed;
            }
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopApp();
                this.provider = null;
            }
            this.config = RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS;
            this.provider = new RdvPeerRdvService(this.group, this);
            this.setManager(manager);
            this.provider.startApp(this.savedArgs);
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRendezVous() {
        if (!this.isRendezVous()) {
            return;
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (this.rdvProviderSwitchLock.booleanValue()) {
                IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed to stop rendezvous", (Throwable)failed);
                }
            }
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopApp();
                this.provider = null;
            }
            this.config = RdvConfigAdv.RendezVousConfiguration.EDGE;
            this.provider = new EdgePeerRdvService(this.group, this);
            this.provider.startApp(this.savedArgs);
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
    }

    public synchronized boolean addPropagateListener(String name, EndpointListener listener) {
        EndpointListener current;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Adding listener (" + listener + ") for name= " + name));
        }
        if ((current = this.propListeners.put(name, listener)) != null && current != listener) {
            this.propListeners.put(name, current);
            return false;
        }
        return true;
    }

    public boolean addPropagateListener(String serviceName, String serviceParam, EndpointListener listener) {
        return this.addPropagateListener(serviceName + serviceParam, listener);
    }

    public synchronized EndpointListener getListener(String str) {
        return (EndpointListener)this.propListeners.get(str);
    }

    public synchronized EndpointListener removePropagateListener(String name, EndpointListener listener) {
        EndpointListener current;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Removing listener (" + listener + ") for name= " + name));
        }
        if ((current = (EndpointListener)this.propListeners.remove(name)) != null && current != listener) {
            this.propListeners.put(name, current);
            return null;
        }
        return current;
    }

    public EndpointListener removePropagateListener(String serviceName, String serviceParam, EndpointListener listener) {
        return this.removePropagateListener(serviceName + serviceParam, listener);
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(msg, serviceName, serviceParam, defaultTTL);
    }

    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    public void walk(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(msg, serviceName, serviceParam, defaultTTL);
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    public Vector getLocalWalkView() {
        Vector<RdvAdvertisement> tmp = new Vector<RdvAdvertisement>();
        PeerView currView = this.rpv;
        if (null == currView) {
            return tmp;
        }
        Iterator<Object> eachPVE = Arrays.asList(currView.getView().toArray()).iterator();
        while (eachPVE.hasNext()) {
            PeerViewElement peer = (PeerViewElement)eachPVE.next();
            RdvAdvertisement adv = peer.getRdvAdvertisement();
            tmp.add(adv);
        }
        return tmp;
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl, String prunePeer) throws IOException {
        this.propagateToNeighbors(msg, serviceName, serviceParam, ttl);
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateToNeighbors(msg, serviceName, serviceParam, ttl);
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl, String prunePeer) throws IOException {
        this.propagateInGroup(msg, serviceName, serviceParam, ttl);
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateInGroup(msg, serviceName, serviceParam, ttl);
    }

    public final void addListener(RendezvousListener listener) {
        this.eventListeners.add(listener);
    }

    public final boolean removeListener(RendezvousListener listener) {
        return this.eventListeners.remove(listener);
    }

    public final void generateEvent(int type, ID regarding) {
        Iterator<Object> eachListener = Arrays.asList(this.eventListeners.toArray()).iterator();
        RendezvousEvent event = new RendezvousEvent(this.getInterface(), type, regarding);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Calling listeners for " + event));
        }
        while (eachListener.hasNext()) {
            RendezvousListener aListener = (RendezvousListener)eachListener.next();
            try {
                aListener.rendezvousEvent(event);
            }
            catch (Throwable ignored) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Uncaught Throwable in listener (" + aListener + ")"), ignored);
            }
        }
    }

    private synchronized void startWatchDogTimer() {
        block2: {
            try {
                this.stopWatchDogTimer();
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)new TimerThreadNamer("RendezVousServiceImpl Timer for " + this.group.getPeerGroupID()), 0L);
                this.timer.schedule((TimerTask)new RdvWatchdogTask(), this.rdv_watchdog_interval, this.rdv_watchdog_interval);
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"Cannot set RDV Watchdog timer: ", (Throwable)ez);
            }
        }
    }

    private synchronized void stopWatchDogTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMsgIdRecorded(UUID id) {
        boolean found;
        List list = this.msgIds;
        synchronized (list) {
            found = this.msgIds.contains(id);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)(id + " = " + found));
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMsgId(UUID id) {
        List list = this.msgIds;
        synchronized (list) {
            if (this.isMsgIdRecorded(id)) {
                return false;
            }
            if (this.msgIds.size() < 1000) {
                this.msgIds.add(id);
            } else {
                this.msgIds.set(this.messagesReceived % 1000, id);
            }
            ++this.messagesReceived;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Added Message ID : " + id));
        }
        return true;
    }

    public UUID createMsgId() {
        return UUIDFactory.newSeqUUID();
    }

    private class RdvWatchdogTask
    extends TimerTask {
        private RdvWatchdogTask() {
        }

        public synchronized void run() {
            block9: {
                try {
                    if (!RendezVousServiceImpl.this.isRendezVous()) {
                        Enumeration rdvs = RendezVousServiceImpl.this.getConnectedRendezVous();
                        if (!rdvs.hasMoreElements()) {
                            RendezVousServiceImpl.this.startRendezVous();
                        }
                    } else {
                        boolean isFewClients;
                        int numberOfClients = RendezVousServiceImpl.this.getConnectedPeerIDs().size();
                        int peerViewSize = RendezVousServiceImpl.this.getLocalWalkView().size();
                        boolean isManyElementsInPeerView = (long)peerViewSize > 5L;
                        boolean bl = isFewClients = (long)numberOfClients < 3L;
                        if (isManyElementsInPeerView) {
                            if (numberOfClients == 0) {
                                RendezVousServiceImpl.this.stopRendezVous();
                            } else if (isFewClients && random.nextDouble() < 0.05) {
                                RendezVousServiceImpl.this.stopRendezVous();
                            }
                        }
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block9;
                    LOG.error((Object)("Uncaught Throwable in Timer : " + Thread.currentThread().getName()), all);
                }
            }
        }
    }
}

