/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.id.ID;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PeerConnection
implements OutgoingMessageEventListener {
    private static final transient Logger LOG = Logger.getLogger((String)PeerConnection.class.getName());
    protected PeerGroup group;
    protected RendezVousServiceImpl rdvService;
    protected ID peerid;
    protected volatile boolean connected = true;
    protected long leasedTil;
    protected String peerName = null;
    protected Messenger cachedMessenger = null;

    public PeerConnection(PeerGroup group, RendezVousServiceImpl rdvService, ID peer) {
        this.group = group;
        this.rdvService = rdvService;
        this.peerName = peer.toString();
        this.setPeerID(peer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeerConnection) {
            return this.peerid.equals(((PeerConnection)obj).peerid);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    public int hashCode() {
        return this.peerid.hashCode();
    }

    public String toString() {
        return this.getPeerName() + (this.connected ? " C" : " c") + " : " + Long.toString(TimeUtils.toRelativeTimeMillis(this.leasedTil));
    }

    public void messageSendFailed(OutgoingMessageEvent event) {
        if (event.getFailure() == null) {
            return;
        }
        this.disconnect();
    }

    public void messageSendSucceeded(OutgoingMessageEvent event) {
    }

    private void setPeerID(ID peerid) {
        this.peerid = peerid;
    }

    public ID getPeerID() {
        return this.peerid;
    }

    public String getPeerName() {
        return this.peerName;
    }

    public void setPeerName(String name) {
        this.peerName = name;
    }

    protected void setLease(long leaseDuration) {
        this.leasedTil = TimeUtils.toAbsoluteTimeMillis(leaseDuration);
    }

    public long getLeaseEnd() {
        return this.leasedTil;
    }

    protected void connect(long leaseDuration) {
        this.setLease(leaseDuration);
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected && TimeUtils.toRelativeTimeMillis(this.leasedTil) >= 0L;
    }

    public void disconnect() {
        this.connected = false;
    }

    public Messenger getCachedMessenger() {
        Messenger result = this.cachedMessenger;
        if (null == result || result.isClosed()) {
            PeerAdvertisement padv = null;
            DiscoveryService discovery = this.group.getDiscoveryService();
            if (null != discovery) {
                try {
                    Enumeration enumeration = discovery.getLocalAdvertisements(0, "PID", this.peerid.toString());
                    if (enumeration.hasMoreElements()) {
                        padv = (PeerAdvertisement)enumeration.nextElement();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            result = this.getCachedMessenger(padv);
        }
        return result;
    }

    protected synchronized Messenger getCachedMessenger(PeerAdvertisement padv) {
        if (null != padv && !this.peerid.equals(padv.getPeerID())) {
            throw new IllegalArgumentException("Peer Advertisement does not match connection");
        }
        if (null != padv && null != padv.getName()) {
            this.setPeerName(padv.getName());
        }
        if (null != padv && null != this.cachedMessenger) {
            this.cachedMessenger.close();
        }
        this.cachedMessenger = null;
        if (this.isConnected()) {
            EndpointAddress destAddress = PeerConnection.mkAddress(this.peerid, null, null);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Getting cached Messenger for " + this.peerName));
            }
            RouteAdvertisement hint = null;
            if (null != padv) {
                hint = RendezVousServiceImpl.extractRouteAdv(padv);
            }
            this.cachedMessenger = this.rdvService.endpoint.getMessenger(destAddress, hint);
            if (null == this.cachedMessenger) {
                this.disconnect();
            }
        }
        return this.cachedMessenger;
    }

    public void sendMessage(Message msg, String service, String param) {
        Messenger messenger = this.getCachedMessenger();
        if (null != messenger) {
            messenger.sendMessage(msg, service, param, this);
        }
    }

    private static EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }
}

