/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.proxy;

import java.io.IOException;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.proxy.ProxyService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Requestor {
    private static final Logger LOG = Logger.getLogger((String)Requestor.class.getName());
    private PeerGroup group;
    private EndpointAddress address;
    private MessageElement requestId;
    private Messenger messenger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Message message) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("send to " + this.address.toString()));
        }
        try {
            Requestor requestor = this;
            synchronized (requestor) {
                if (null == this.messenger || this.messenger.isClosed()) {
                    this.messenger = null;
                    this.messenger = this.group.getEndpointService().getMessenger(this.address);
                    if (null == this.messenger) {
                        LOG.warn((Object)("Could not get messenger for " + this.address));
                        return false;
                    }
                }
            }
            this.messenger.sendMessage(message);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not send message to requestor for " + this.address), (Throwable)e);
            return false;
        }
        ProxyService.logMessage(message, LOG);
        return true;
    }

    public boolean send(Advertisement adv, String resultType) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("send " + adv));
        }
        Message message = new Message();
        if (resultType == null) {
            resultType = "";
        }
        this.setString(message, "response", resultType);
        if (this.requestId != null) {
            message.addMessageElement("proxy", this.requestId);
        }
        if (adv instanceof PeerAdvertisement) {
            PeerAdvertisement peerAdv = (PeerAdvertisement)adv;
            message.addMessageElement("proxy", new StringMessageElement("type", "PEER", null));
            message.addMessageElement("proxy", new StringMessageElement("name", peerAdv.getName(), null));
            message.addMessageElement("proxy", new StringMessageElement("id", peerAdv.getPeerID().toString(), null));
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("send PeerAdvertisement name=" + peerAdv.getName() + " id=" + peerAdv.getPeerID().toString()));
            }
        } else if (adv instanceof PeerGroupAdvertisement) {
            PeerGroupAdvertisement groupAdv = (PeerGroupAdvertisement)adv;
            message.addMessageElement("proxy", new StringMessageElement("type", "GROUP", null));
            message.addMessageElement("proxy", new StringMessageElement("name", groupAdv.getName(), null));
            message.addMessageElement("proxy", new StringMessageElement("id", groupAdv.getPeerGroupID().toString(), null));
            LOG.debug((Object)("send GroupAdvertisement name=" + groupAdv.getName() + " id=" + groupAdv.getPeerGroupID().toString()));
        } else if (adv instanceof PipeAdvertisement) {
            PipeAdvertisement pipeAdv = (PipeAdvertisement)adv;
            message.addMessageElement("proxy", new StringMessageElement("type", "PIPE", null));
            message.addMessageElement("proxy", new StringMessageElement("name", pipeAdv.getName(), null));
            message.addMessageElement("proxy", new StringMessageElement("id", pipeAdv.getPipeID().toString(), null));
            message.addMessageElement("proxy", new StringMessageElement("arg", pipeAdv.getType(), null));
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("send PipeAdvertisement name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
            }
        } else {
            return false;
        }
        return this.send(message);
    }

    public boolean notifySuccess() {
        LOG.debug((Object)"notifySuccess");
        Message message = new Message();
        message.addMessageElement("proxy", new StringMessageElement("response", "success", null));
        if (this.requestId != null) {
            message.addMessageElement("proxy", this.requestId);
        }
        return this.send(message);
    }

    public boolean notifyError(String errorString) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("notifyError " + errorString));
        }
        Message message = new Message();
        if (this.requestId != null) {
            message.addMessageElement("proxy", this.requestId);
        }
        if (errorString != null && errorString.length() > 0) {
            message.addMessageElement("proxy", new StringMessageElement("error", errorString, null));
        }
        return this.send(message);
    }

    public boolean equals(Object obj) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)(this + " equals " + obj));
        }
        if (obj instanceof Requestor) {
            Requestor dest = (Requestor)obj;
            if (this.address != null && dest.address != null && dest.address.toString().equals(this.address.toString())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Requestor " + this.address.toString();
    }

    private Requestor(PeerGroup group, EndpointAddress address, MessageElement requestId) throws IOException {
        this.group = group;
        this.address = address;
        this.requestId = requestId;
    }

    public static Requestor createRequestor(PeerGroup group, Message message, EndpointAddress address) throws IOException {
        Requestor requestor = null;
        LOG.debug((Object)("create new Requestor - " + address.toString()));
        if (address != null) {
            MessageElement elem = message.getMessageElement("requestId");
            requestor = new Requestor(group, address, elem);
            message.removeMessageElement(elem);
        }
        return requestor;
    }

    private void setString(Message message, String tag, String value) {
        StringMessageElement sme = new StringMessageElement(tag, value, null);
        message.addMessageElement("proxy", sme);
    }
}

