/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.util.BASE64InputStream;
import net.jxta.impl.util.BASE64OutputStream;
import net.jxta.protocol.SignedAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SignedAdv
extends SignedAdvertisement {
    private static final transient Logger LOG = Logger.getLogger((String)SignedAdv.class.getName());
    private static final String ADV_TYPE = "jxta:SA";
    private static final String[] INDEX_FIELDS = new String[0];
    private byte[] signature = null;

    public static String getAdvertisementType() {
        return ADV_TYPE;
    }

    SignedAdv() {
    }

    SignedAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(SignedAdv.getAdvertisementType()) && !SignedAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Element elem = (Element)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    public final String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public ID getID() {
        return ID.nullID;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if ("Credential".equals(elem.getName())) {
            this.signer = new PSECredential(elem);
            return true;
        }
        if ("Signature".equals(elem.getName())) {
            try {
                int c;
                StringReader signatureB64 = new StringReader(elem.getTextValue());
                BASE64InputStream bis = new BASE64InputStream(signatureB64);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while (-1 != (c = ((InputStream)bis).read())) {
                    bos.write(c);
                }
                ((InputStream)bis).close();
                bos.close();
                this.signature = bos.toByteArray();
                return true;
            }
            catch (IOException failed) {
                IllegalArgumentException failure = new IllegalArgumentException("Could not process Signature");
                failure.initCause(failed);
                throw failure;
            }
        }
        if ("Advertisement".equals(elem.getName())) {
            try {
                int c;
                StringReader advertisementB64 = new StringReader(elem.getTextValue());
                BASE64InputStream bis = new BASE64InputStream(advertisementB64);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while (-1 != (c = ((InputStream)bis).read())) {
                    bos.write(c);
                }
                byte[] advbytes = bos.toByteArray();
                Signature verifier = ((PSECredential)this.signer).getSignatureVerifier("SHA1withRSA");
                verifier.update(advbytes);
                boolean matched = verifier.verify(this.signature);
                if (!matched) {
                    throw new IllegalArgumentException("Advertisement could not be verified");
                }
                advertisementB64 = new StringReader(elem.getTextValue());
                bis = new BASE64InputStream(advertisementB64);
                this.adv = AdvertisementFactory.newAdvertisement(elem.getRoot().getMimeType(), bis);
                return true;
            }
            catch (IOException failed) {
                IllegalArgumentException failure = new IllegalArgumentException("Could not process Advertisement");
                failure.initCause(failed);
                throw failure;
            }
            catch (NoSuchAlgorithmException failed) {
                IllegalArgumentException failure = new IllegalArgumentException("Could not process Advertisement");
                failure.initCause(failed);
                throw failure;
            }
            catch (SignatureException failed) {
                IllegalArgumentException failure = new IllegalArgumentException("Could not process Advertisement");
                failure.initCause(failed);
                throw failure;
            }
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        if (null == this.adv) {
            throw new IllegalStateException("Advertisement not initialized");
        }
        if (null == this.signer) {
            throw new IllegalStateException("Signer Credential not initialized");
        }
        if (!(this.signer instanceof PSECredential)) {
            throw new IllegalStateException("Signer Credential not initialized");
        }
        StructuredDocument doc = (StructuredDocument)super.getDocument(encodeAs);
        StructuredDocument advDoc = (StructuredDocument)this.adv.getDocument(encodeAs);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            advDoc.sendToStream(bos);
            bos.close();
            byte[] advData = bos.toByteArray();
            PSECredential psecred = (PSECredential)this.signer;
            Signature advSigner = psecred.getSigner("SHA1withRSA");
            advSigner.update(advData);
            byte[] signature = advSigner.sign();
            StringWriter signatureB64 = new StringWriter();
            StringWriter advertisementB64 = new StringWriter();
            BASE64OutputStream signatureOut = new BASE64OutputStream(signatureB64);
            signatureOut.write(signature);
            ((OutputStream)signatureOut).close();
            BASE64OutputStream advertisementOut = new BASE64OutputStream(advertisementB64, 72);
            advertisementOut.write(advData);
            ((OutputStream)advertisementOut).close();
            StructuredDocument creddoc = this.signer.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(doc, doc, creddoc, "Credential");
            Element elem = doc.createElement("Signature", signatureB64.toString());
            doc.appendChild(elem);
            elem = doc.createElement("Advertisement", advertisementB64.toString());
            doc.appendChild(elem);
            if (doc instanceof Attributable) {
                ((Attributable)((Object)elem)).addAttribute("type", this.adv.getAdvType());
            }
        }
        catch (Exception failed) {
            if (failed instanceof RuntimeException) {
                throw (RuntimeException)failed;
            }
            throw new UndeclaredThrowableException(failed, "Failure building document");
        }
        return doc;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return SignedAdv.ADV_TYPE;
        }

        public Advertisement newInstance() {
            return new SignedAdv();
        }

        public Advertisement newInstance(Element root) {
            return new SignedAdv(root);
        }
    }
}

