/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class RdvConfigAdv
extends ExtendableAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)RdvConfigAdv.class.getName());
    private static final String advType = "jxta:RdvConfig";
    private static final String RDV_CONFIG_ATTR = "config";
    private static final String MAX_TTL_ATTR = "maxTTL";
    private static final String AUTO_RDV_INTERVAL_ATTR = "autoRendezvousInterval";
    private static final String PROBE_RELAYS_ATTR = "probeRelays";
    private static final String MAX_CLIENTS_ATTR = "maxClients";
    private static final String LEASE_DURATION_ATTR = "leaseDuration";
    private static final String LEASE_MARGIN_ATTR = "leaseMargin";
    private static final String MIN_HAPPY_PEERVIEW_ATTR = "minHappyPeerView";
    private static final String SEEDS_RDV_ELEMENT = "seeds";
    private static final String USE_ONLY_SEEDS_ATTR = "useOnlySeeds";
    private static final String CONNECT_DELAY_ATTR = "connectDelay";
    private static final String SEED_RDV_ADDR_ELEMENT = "addr";
    private static final String PROPAGATE_RESPOND_ATTR = "propagateRespondProbability";
    private static final String[] fields = new String[0];
    private RendezVousConfiguration configuration = RendezVousConfiguration.EDGE;
    private long autoRendezvousCheckInterval = 0L;
    private boolean probeRelays = false;
    private int maxClients = 0;
    private int maximumTTL = -1;
    private long leaseDuration = 0L;
    private long leaseMargin = 0L;
    private int minHappyPeerView = 0;
    private boolean useOnlySeeds = false;
    private long seedRendezvousConnectDelay = 0L;
    private List seedRendezvous = new ArrayList();

    RdvConfigAdv() {
    }

    RdvConfigAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RdvConfigAdv.getAdvertisementType()) && !RdvConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aRdvAttr = (Attribute)eachAttr.nextElement();
            if (RDV_CONFIG_ATTR.equals(aRdvAttr.getName())) {
                String config = aRdvAttr.getValue().trim();
                if ("adhoc".equals(config)) {
                    this.configuration = RendezVousConfiguration.AD_HOC;
                    continue;
                }
                if ("client".equals(config)) {
                    this.configuration = RendezVousConfiguration.EDGE;
                    continue;
                }
                if ("rendezvous".equals(config)) {
                    this.configuration = RendezVousConfiguration.RENDEZVOUS;
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized Rendezvous configuration :" + config);
            }
            if (MAX_TTL_ATTR.equals(aRdvAttr.getName())) {
                this.maximumTTL = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (AUTO_RDV_INTERVAL_ATTR.equals(aRdvAttr.getName())) {
                this.autoRendezvousCheckInterval = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (PROBE_RELAYS_ATTR.equals(aRdvAttr.getName())) {
                this.probeRelays = Boolean.valueOf(aRdvAttr.getValue().trim());
                continue;
            }
            if (MAX_CLIENTS_ATTR.equals(aRdvAttr.getName())) {
                this.maxClients = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (LEASE_DURATION_ATTR.equals(aRdvAttr.getName())) {
                this.leaseDuration = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (LEASE_MARGIN_ATTR.equals(aRdvAttr.getName())) {
                this.leaseMargin = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (MIN_HAPPY_PEERVIEW_ATTR.equals(aRdvAttr.getName())) {
                this.minHappyPeerView = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (PROPAGATE_RESPOND_ATTR.equals(aRdvAttr.getName()) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandled Attribute: " + aRdvAttr.getName()));
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandled Element: " + elem.toString()));
        }
        if (this.autoRendezvousCheckInterval < 0L) {
            throw new IllegalArgumentException("Auto Rendezvous Check Interval must be >= 0");
        }
        if (this.seedRendezvousConnectDelay < 0L) {
            throw new IllegalArgumentException("Seed Rendezvous Connect Delay must be >= 0");
        }
        if (this.minHappyPeerView < 0) {
            throw new IllegalArgumentException("Min Happy Peer View must be >= 0");
        }
        if (this.seedRendezvous.isEmpty() && this.useOnlySeeds && this.configuration == RendezVousConfiguration.EDGE) {
            throw new IllegalArgumentException("Must specify rendezvous if 'useOnlySeeds' is enabled and configured as client");
        }
    }

    public Object clone() {
        RdvConfigAdv result = new RdvConfigAdv();
        return result;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return RdvConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return RdvConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        return ID.nullID;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (SEEDS_RDV_ELEMENT.equals(elem.getName())) {
            Enumeration eachSeedElem = elem.getChildren();
            while (eachSeedElem.hasMoreElements()) {
                XMLElement aSeedElem = (XMLElement)eachSeedElem.nextElement();
                if (SEED_RDV_ADDR_ELEMENT.equals(aSeedElem.getName())) {
                    String endpAddrString = aSeedElem.getTextValue();
                    if (null == endpAddrString) continue;
                    URI endpAddr = URI.create(endpAddrString.trim());
                    this.seedRendezvous.add(endpAddr);
                    continue;
                }
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Unhandled Element: " + aSeedElem.getName()));
            }
            Enumeration eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute aSeedAttr = (Attribute)eachAttr.nextElement();
                if (USE_ONLY_SEEDS_ATTR.equals(aSeedAttr.getName())) {
                    this.useOnlySeeds = Boolean.valueOf(aSeedAttr.getValue().trim());
                    continue;
                }
                if (CONNECT_DELAY_ATTR.equals(aSeedAttr.getName())) {
                    this.seedRendezvousConnectDelay = Long.parseLong(aSeedAttr.getValue().trim());
                    continue;
                }
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Unhandled Attribute: " + aSeedAttr.getName()));
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable) {
            Attributable attrDoc = (Attributable)((Object)adv);
            if (RendezVousConfiguration.AD_HOC == this.configuration) {
                attrDoc.addAttribute(RDV_CONFIG_ATTR, "adhoc");
            } else if (RendezVousConfiguration.EDGE == this.configuration) {
                attrDoc.addAttribute(RDV_CONFIG_ATTR, "client");
            } else if (RendezVousConfiguration.RENDEZVOUS == this.configuration) {
                attrDoc.addAttribute(RDV_CONFIG_ATTR, "rendezvous");
            }
            if (this.maximumTTL != -1) {
                if (this.maximumTTL <= 0) {
                    throw new IllegalStateException("Maximum TTL must be >= 0");
                }
                attrDoc.addAttribute(MAX_TTL_ATTR, Integer.toString(this.maximumTTL));
            }
            if (this.seedRendezvous.isEmpty() && this.useOnlySeeds && this.configuration == RendezVousConfiguration.EDGE) {
                throw new IllegalStateException("Must specify rendezvous if 'useOnlySeeds' is enabled and configured as client");
            }
            if (0L != this.autoRendezvousCheckInterval) {
                if (this.autoRendezvousCheckInterval < 0L) {
                    throw new IllegalStateException("Auto Rendezvous Check Interval must be >= 0");
                }
                attrDoc.addAttribute(AUTO_RDV_INTERVAL_ATTR, Long.toString(this.autoRendezvousCheckInterval));
            }
            if (this.probeRelays) {
                attrDoc.addAttribute(PROBE_RELAYS_ATTR, Boolean.toString(this.probeRelays));
            }
            if (0 != this.maxClients) {
                if (this.maxClients < 0) {
                    throw new IllegalStateException("Max Clients must be >= 0");
                }
                attrDoc.addAttribute(MAX_CLIENTS_ATTR, Integer.toString(this.maxClients));
            }
            if (0L != this.leaseDuration) {
                if (this.leaseDuration < 0L) {
                    throw new IllegalStateException("Lease Duration must be >= 0");
                }
                attrDoc.addAttribute(LEASE_DURATION_ATTR, Long.toString(this.leaseDuration));
            }
            if (0L != this.leaseMargin) {
                if (this.leaseMargin < 0L) {
                    throw new IllegalStateException("Lease Margin must be >= 0");
                }
                attrDoc.addAttribute(LEASE_MARGIN_ATTR, Long.toString(this.leaseMargin));
            }
            if (0 != this.minHappyPeerView) {
                if (this.minHappyPeerView < 0) {
                    throw new IllegalStateException("Min Happy Peer View must be >= 0");
                }
                attrDoc.addAttribute(MIN_HAPPY_PEERVIEW_ATTR, Integer.toString(this.minHappyPeerView));
            }
        }
        if (this.seedRendezvous.size() > 0) {
            Element elem = adv.createElement(SEEDS_RDV_ELEMENT);
            adv.appendChild(elem);
            if (adv instanceof Attributable) {
                Attributable attrDoc = (Attributable)((Object)adv);
                if (this.useOnlySeeds) {
                    attrDoc.addAttribute(USE_ONLY_SEEDS_ATTR, Boolean.toString(this.useOnlySeeds));
                }
                if (0L != this.seedRendezvousConnectDelay) {
                    if (this.seedRendezvousConnectDelay < 0L) {
                        throw new IllegalStateException("Seed Rendezvous Connect Delay must be >= 0");
                    }
                    attrDoc.addAttribute(CONNECT_DELAY_ATTR, Long.toString(this.seedRendezvousConnectDelay));
                }
            }
            Iterator eachSeed = this.seedRendezvous.iterator();
            while (eachSeed.hasNext()) {
                Element aSeed = adv.createElement(SEED_RDV_ADDR_ELEMENT, eachSeed.next().toString());
                elem.appendChild(aSeed);
            }
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public RendezVousConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RendezVousConfiguration newstate) {
        this.configuration = newstate;
    }

    public long getAutoRendezvousCheckInterval() {
        return this.autoRendezvousCheckInterval;
    }

    public void setAutoRendezvousCheckInterval(long newvalue) {
        if (newvalue < 0L) {
            throw new IllegalArgumentException("Auto Rendezvous Check Interval must be >= 0");
        }
        this.autoRendezvousCheckInterval = newvalue;
    }

    public boolean getProbeRelays() {
        return this.probeRelays;
    }

    public void setProbeRelays(boolean doProbe) {
        this.probeRelays = doProbe;
    }

    public URI[] getSeedRendezvous() {
        return this.seedRendezvous.toArray(new URI[this.seedRendezvous.size()]);
    }

    public void addSeedRendezvous(URI addr) {
        this.seedRendezvous.add(addr);
    }

    public void addSeedRendezvous(String addr) {
        this.seedRendezvous.add(URI.create(addr));
    }

    public boolean removeSeedRendezvous(URI addr) {
        return this.seedRendezvous.remove(addr);
    }

    public void clearSeedRendezvous() {
        this.seedRendezvous.clear();
    }

    public boolean getUseOnlySeeds() {
        return this.probeRelays;
    }

    public void setUseOnlySeeds(boolean doProbe) {
        this.probeRelays = doProbe;
    }

    public long getSeedRendezvousConnectDelay() {
        return this.seedRendezvousConnectDelay;
    }

    public void setSeedRendezvousConnectDelay(long newvalue) {
        if (newvalue < 0L) {
            throw new IllegalArgumentException("Seed Rendezvous Connect Delay must be >= 0");
        }
        this.seedRendezvousConnectDelay = newvalue;
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(long newvalue) {
        if (newvalue < 0L) {
            throw new IllegalArgumentException("Lease Duration must be >= 0");
        }
        this.leaseDuration = newvalue;
    }

    public long getLeaseMargin() {
        return this.leaseMargin;
    }

    public void setLeaseMargin(long newvalue) {
        if (newvalue < 0L) {
            throw new IllegalArgumentException("Lease Margin must be >= 0");
        }
        this.leaseMargin = newvalue;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public void setMaxClients(int newvalue) {
        if (newvalue < 0) {
            throw new IllegalArgumentException("Max Clients must be >= 0");
        }
        this.maxClients = newvalue;
    }

    public int getMaxTTL() {
        return this.maximumTTL;
    }

    public void setMaxTTL(int newvalue) {
        if (-1 != newvalue && newvalue < 0) {
            throw new IllegalArgumentException("Max TTL must be >= 0");
        }
        this.maximumTTL = newvalue;
    }

    public int getMinHappyPeerView() {
        return this.minHappyPeerView;
    }

    public void setMinHappyPeerView(int newvalue) {
        if (newvalue < 0) {
            throw new IllegalArgumentException("Min Happy Peer View size must be >= 0");
        }
        this.minHappyPeerView = newvalue;
    }

    public static class RendezVousConfiguration {
        public static final RendezVousConfiguration AD_HOC = new RendezVousConfiguration(){

            public String toString() {
                return "AD HOC";
            }
        };
        public static final RendezVousConfiguration EDGE = new RendezVousConfiguration(){

            public String toString() {
                return "EDGE";
            }
        };
        public static final RendezVousConfiguration RENDEZVOUS = new RendezVousConfiguration(){

            public String toString() {
                return "RENDEZVOUS";
            }
        };

        private RendezVousConfiguration() {
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RdvConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new RdvConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RdvConfigAdv(root);
        }
    }
}

