/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.ConfigParams;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PlatformConfig
extends ConfigParams {
    private static final String advType = "jxta:PlatformConfig";
    private static final Logger LOG = Logger.getLogger((String)PlatformConfig.class.getName());
    private static final String DEBUG_TAG = "Dbg";
    private static final String DEBUG_TAG_DEFAULT = "user default";
    private static final String PID_TAG = "PID";
    private static final String NAME_TAG = "Name";
    private static final String DESC_TAG = "Desc";
    private static final String SVC_TAG = "Svc";
    private static final String MCID_TAG = "MCID";
    private static final String PARAM_TAG = "Parm";
    private static final String[] fields = new String[]{"Name", "PID"};
    private PeerID pid = null;
    private String name = null;
    private Element description = null;
    private String debugLevel = "user default";

    PlatformConfig() {
    }

    PlatformConfig(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PlatformConfig.getAdvertisementType()) && !PlatformConfig.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Element elem = (Element)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    public Object clone() {
        PlatformConfig result = new PlatformConfig();
        result.setPeerID(this.getPeerID());
        result.setName(this.getName());
        result.setDesc(this.getDesc());
        result.setDebugLevel(this.getDebugLevel());
        Iterator eachEntry = this.getServiceParamsEntrySet().iterator();
        while (eachEntry.hasNext()) {
            Map.Entry anEntry = (Map.Entry)eachEntry.next();
            result.putServiceParam((ID)anEntry.getKey(), (Element)anEntry.getValue());
        }
        return result;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return PlatformConfig.getAdvertisementType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
    }

    public ID getID() {
        return this.pid;
    }

    public String getDescription() {
        return null == this.description ? (String)null : (String)this.description.getValue();
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, DESC_TAG, description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public String getDebugLevel() {
        return this.debugLevel.trim();
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(PID_TAG)) {
            try {
                URL pID = IDFactory.jxtaURL(elem.getTextValue());
                this.setPeerID((PeerID)IDFactory.fromURL(pID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement: " + elem.getTextValue());
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(NAME_TAG)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(DESC_TAG)) {
            this.setDesc(elem);
            return true;
        }
        if (DEBUG_TAG.equals(elem.getName())) {
            this.setDebugLevel(elem.getTextValue());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String debugLvl;
        StructuredDocument desc;
        Element e;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        PeerID peerID = this.getPeerID();
        if (null != peerID && !ID.nullID.equals(peerID)) {
            e = adv.createElement(PID_TAG, peerID.toString());
            adv.appendChild(e);
        }
        if (this.getName() != null) {
            e = adv.createElement(NAME_TAG, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        if ((debugLvl = this.getDebugLevel()) != null && !DEBUG_TAG_DEFAULT.equals(debugLvl)) {
            e = adv.createElement(DEBUG_TAG, debugLvl);
            adv.appendChild(e);
        }
        super.addDocumentElements(adv);
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PlatformConfig.advType;
        }

        public Advertisement newInstance() {
            return new PlatformConfig();
        }

        public Advertisement newInstance(Element root) {
            return new PlatformConfig(root);
        }
    }
}

