/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ModuleImplAdv
extends ModuleImplAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)ModuleImplAdv.class.getName());
    private static final String msidTag = "MSID";
    private static final String compTag = "Comp";
    private static final String codeTag = "Code";
    private static final String uriTag = "PURI";
    private static final String provTag = "Prov";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String[] fields = new String[]{"MSID"};

    public ModuleImplAdv() {
    }

    public ModuleImplAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(ModuleImplAdv.getAdvertisementType()) && !ModuleImplAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        ModuleSpecID moduleID = this.getModuleSpecID();
        if (null == moduleID || moduleID.equals(ID.nullID)) {
            throw new IllegalArgumentException("Module Spec ID was not initialized by advertisement");
        }
        if (null == this.getCode() || 0 == this.getCode().length()) {
            throw new IllegalArgumentException("Code was not initialized by advertisement");
        }
        StructuredDocument compat = this.getCompat();
        if (null == compat) {
            throw new IllegalArgumentException("Compatibility statement was not initialized by advertisement");
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String nm = elem.getName();
        if (nm.equals(msidTag)) {
            try {
                URL spID = IDFactory.jxtaURL(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(spID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad module spec ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (nm.equals(compTag)) {
            this.setCompat(elem);
            return true;
        }
        if (nm.equals(codeTag)) {
            this.setCode(elem.getTextValue());
            return true;
        }
        if (nm.equals(uriTag)) {
            this.setUri(elem.getTextValue());
            return true;
        }
        if (nm.equals(provTag)) {
            this.setProvider(elem.getTextValue());
            return true;
        }
        if (nm.equals(descTag)) {
            this.setDescription(elem.getTextValue());
            return true;
        }
        if (nm.equals(paramTag)) {
            this.setParam(elem);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument param;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        ModuleSpecID moduleID = this.getModuleSpecID();
        if (null == moduleID || moduleID.equals(ID.nullID)) {
            throw new IllegalStateException("Module Spec ID is not initialized.");
        }
        if (null == this.getCode() || 0 == this.getCode().length()) {
            throw new IllegalStateException("Code is not initialized.");
        }
        StructuredDocument compat = this.getCompatPriv();
        if (null == compat) {
            throw new IllegalStateException("Compatibility statement is not initialized.");
        }
        Element e = adv.createElement(msidTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        StructuredDocumentUtils.copyElements(adv, adv, compat, compTag);
        if (this.getCode() != null) {
            e = adv.createElement(codeTag, this.getCode());
            adv.appendChild(e);
        }
        if (this.getUri() != null) {
            e = adv.createElement(uriTag, this.getUri());
            adv.appendChild(e);
        }
        if (this.getProvider() != null) {
            e = adv.createElement(provTag, this.getProvider());
            adv.appendChild(e);
        }
        if (this.getDescription() != null) {
            e = adv.createElement(descTag, this.getDescription());
            adv.appendChild(e);
        }
        if ((param = this.getParamPriv()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, param, paramTag);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleImplAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleImplAdv();
        }

        public Advertisement newInstance(Element root) {
            return new ModuleImplAdv(root);
        }
    }
}

