/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.protocol.LimitedRangeRdvMessage;

public class LimitedRangeRdvMsg
extends LimitedRangeRdvMessage {
    public LimitedRangeRdvMsg() {
    }

    public LimitedRangeRdvMsg(Element root) {
        this.initialize(root);
    }

    public ID getID() {
        return ID.nullID;
    }

    protected void initialize(Element root) {
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(LimitedRangeRdvMsg.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + LimitedRangeRdvMsg.getAdvertisementType());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals("TTL")) {
                this.setTTL(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals("Dir")) {
                this.setDirection(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals("SrcRouteAdv")) {
                this.setSrcRouteAdv(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals("SrcPeerID")) {
                this.setSrcPeerID(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals("SrcSvcName")) {
                this.setSrcSvcName(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals("SrcSvcParams")) continue;
            this.setSrcSvcParams(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType mediaType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mediaType, LimitedRangeRdvMsg.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        TextElement e = null;
        e = adv.createElement("TTL", Integer.toString(this.getTTL()));
        adv.appendChild(e);
        e = adv.createElement("Dir", Integer.toString(this.getDirection()));
        adv.appendChild(e);
        if (this.getSrcPeerID() != null) {
            e = adv.createElement("SrcPeerID", this.getSrcPeerID());
            adv.appendChild(e);
        }
        if (this.getSrcSvcName() != null) {
            e = adv.createElement("SrcSvcName", this.getSrcSvcName());
            adv.appendChild(e);
        }
        if (this.getSrcSvcParams() != null) {
            e = adv.createElement("SrcSvcParams", this.getSrcSvcParams());
            adv.appendChild(e);
        }
        if (this.getSrcRouteAdv() != null) {
            e = adv.createElement("SrcRouteAdv", this.getSrcRouteAdv());
            adv.appendChild(e);
        }
        return adv;
    }
}

