/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HTTPAdv
extends TransportAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)HTTPAdv.class.getName());
    private static final String[] fields = new String[0];
    private static final String ProtocolTag = "Protocol";
    private static final String ProxyTag = "Proxy";
    private static final String ServerTag = "Server";
    private static final String PortTag = "Port";
    private static final String IntfAddrTag = "InterfaceAddress";
    private static final String ConfModeTag = "ConfigMode";
    private static final String FlagsTag = "Flags";
    private static final String PublicAddressOnlyAttr = "PublicAddressOnly";
    private static final String ProxyOffTag = "ProxyOff";
    private static final String ServerOffTag = "ServerOff";
    private static final String ClientOffTag = "ClientOff";
    private String proxy = null;
    private String server = null;
    private int listenPort = -1;
    private String interfaceAddress = null;
    private String configMode = null;
    private boolean publicAddressOnly = false;
    private boolean proxyEnabled = true;
    private boolean serverEnabled = true;
    private boolean clientEnabled = true;

    public static String getAdvertisementType() {
        return "jxta:HTTPTransportAdvertisement";
    }

    private HTTPAdv() {
    }

    private HTTPAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(HTTPAdv.getAdvertisementType()) && !HTTPAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Attribute attr = doc.getAttribute(FlagsTag);
        if (attr != null) {
            String options = attr.getValue();
            this.publicAddressOnly = options.indexOf(PublicAddressOnlyAttr) != -1;
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (this.proxy == null) {
            this.proxyEnabled = false;
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String tag = elem.getName();
        if (tag.equals(ProxyOffTag)) {
            this.proxyEnabled = false;
            return true;
        }
        if (tag.equals(ServerOffTag)) {
            this.serverEnabled = false;
            return true;
        }
        if (tag.equals(ClientOffTag)) {
            this.clientEnabled = false;
            return true;
        }
        String value = elem.getTextValue();
        if (tag.equals(ProtocolTag)) {
            this.setProtocol(value);
            return true;
        }
        if (tag.equals(IntfAddrTag)) {
            this.setInterfaceAddress(value);
            return true;
        }
        if (tag.equals(ConfModeTag)) {
            this.setConfigMode(value);
            return true;
        }
        if (tag.equals(PortTag)) {
            this.setPort(Integer.parseInt(value.trim()));
            return true;
        }
        if (tag.equals(ProxyTag)) {
            this.proxy = value;
            return true;
        }
        if (tag.equals(ServerTag)) {
            this.server = value;
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        Element ext;
        if (this.listenPort < 1) {
            throw new IllegalStateException("Illegal Listen Port Value");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable && this.publicAddressOnly) {
            ((Attributable)((Object)adv)).addAttribute(FlagsTag, PublicAddressOnlyAttr);
        }
        Element e1 = adv.createElement(ProtocolTag, this.getProtocol());
        adv.appendChild(e1);
        Element e2 = adv.createElement(IntfAddrTag, this.getInterfaceAddress());
        adv.appendChild(e2);
        Element e3 = adv.createElement(ConfModeTag, this.getConfigMode());
        adv.appendChild(e3);
        Element e4 = adv.createElement(PortTag, Integer.toString(this.getPort()));
        adv.appendChild(e4);
        if (this.proxy != null) {
            ext = adv.createElement(ProxyTag, this.proxy);
            adv.appendChild(ext);
        }
        if (!this.proxyEnabled) {
            ext = adv.createElement(ProxyOffTag);
            adv.appendChild(ext);
        }
        if (this.server != null) {
            ext = adv.createElement(ServerTag, this.server);
            adv.appendChild(ext);
        }
        if (!this.serverEnabled) {
            ext = adv.createElement(ServerOffTag);
            adv.appendChild(ext);
        }
        if (!this.clientEnabled) {
            ext = adv.createElement(ClientOffTag);
            adv.appendChild(ext);
        }
        return adv;
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String address) {
        this.interfaceAddress = address;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public boolean getPublicAddressOnly() {
        return this.publicAddressOnly;
    }

    public void setPublicAddressOnly(boolean only) {
        this.publicAddressOnly = only;
    }

    public void setConfigMode(String configMode) {
        this.configMode = configMode;
    }

    public int getPort() {
        return this.listenPort;
    }

    public void setPort(int newPort) {
        this.listenPort = newPort;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setProxy(String name) {
        this.proxy = name;
        if (name == null) {
            this.proxyEnabled = false;
        }
    }

    public void setServer(String name) {
        this.server = name;
    }

    public void setProxyEnabled(boolean enabled) {
        this.proxyEnabled = enabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return HTTPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new HTTPAdv();
        }

        public Advertisement newInstance(Element root) {
            return new HTTPAdv(root);
        }
    }
}

