/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryResponse
extends DiscoveryResponseMsg {
    private static final transient Logger LOG = Logger.getLogger((String)DiscoveryResponse.class.getName());
    private static final String countTag = "Count";
    private static final String expirationTag = "Expiration";
    private static final String peerAdvTag = "PeerAdv";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    private static final String responsesTag = "Response";
    private static final String typeTag = "Type";

    public DiscoveryResponse() {
    }

    public DiscoveryResponse(Element root) {
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!DiscoveryResponse.getAdvertisementType().equals(docName)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + docName);
        }
        this.readIt(doc);
    }

    public Enumeration getAdvertisements() {
        if (null == this.advertisements) {
            this.parseAdvertisements();
        }
        if (0 == this.advertisements.size() && this.getPeerAdvertisement() != null && this.type == 0) {
            this.advertisements = Collections.singletonList(this.peerAdvertisement);
        }
        return Collections.enumeration(this.advertisements);
    }

    protected void setAdvertisements(List advs) {
        this.advertisements = new ArrayList(advs);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryResponse.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            ((XMLDocument)adv).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Enumeration advs = this.getResponses();
        Enumeration exps = this.getExpirations();
        TextElement e = adv.createElement(countTag, Integer.toString(this.responses.size()));
        adv.appendChild((Element)e);
        e = adv.createElement(typeTag, Integer.toString(this.type));
        adv.appendChild((Element)e);
        PeerAdvertisement myPeerAdv = this.getPeerAdvertisement();
        if (null != myPeerAdv) {
            e = adv.createElement(peerAdvTag, myPeerAdv.toString());
            adv.appendChild((Element)e);
        }
        if (this.attr != null && this.attr.length() > 0) {
            e = adv.createElement(queryAttrTag, this.getQueryAttr());
            adv.appendChild((Element)e);
            if (this.value != null && this.value.length() > 0) {
                e = adv.createElement(queryValueTag, this.value);
                adv.appendChild((Element)e);
            }
        }
        try {
            while (advs.hasMoreElements()) {
                Long l = (Long)exps.nextElement();
                Object response = advs.nextElement();
                e = response instanceof InputStream ? adv.createElement(responsesTag, this.streamToString((InputStream)response)) : adv.createElement(responsesTag, response.toString());
                adv.appendChild((Element)e);
                if (!(adv instanceof Attributable)) continue;
                ((Attributable)((Object)e)).addAttribute(expirationTag, l.toString());
            }
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Got an Exception during doc creation", (Throwable)failed);
            }
            IllegalStateException failure = new IllegalStateException("Got an Exception during doc creation");
            failure.initCause(failed);
            throw failure;
        }
        return adv;
    }

    private void parseAdvertisements() {
        ArrayList<Advertisement> advertisements = new ArrayList<Advertisement>();
        Enumeration eachResponse = this.getResponses();
        while (eachResponse.hasMoreElements()) {
            Advertisement adv;
            Object response = eachResponse.nextElement();
            if (response instanceof String) {
                String str = (String)response;
                try {
                    adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(str));
                    advertisements.add(adv);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"No advertisements in response element", (Throwable)e);
                }
                continue;
            }
            if (response instanceof InputStream) {
                InputStream is = (InputStream)response;
                try {
                    adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
                    advertisements.add(adv);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Can not parse Response", (Throwable)e);
                }
                continue;
            }
            if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Can not parse Response of type " + response.getClass().getName()));
        }
        this.setAdvertisements(advertisements);
    }

    private void readIt(TextElement doc) {
        Vector<String> res = new Vector<String>();
        Vector<Long> exps = new Vector<Long>();
        try {
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                long exp;
                TextElement elem = (TextElement)elements.nextElement();
                if (elem.getName().equals(typeTag)) {
                    this.type = Integer.parseInt(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(peerAdvTag)) {
                    String peerString = elem.getTextValue();
                    if (null == peerString || (peerString = peerString.trim()).length() <= 0) continue;
                    this.setPeerAdvertisement((PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(elem.getTextValue())));
                    continue;
                }
                if (elem.getName().equals(queryAttrTag)) {
                    this.setQueryAttr(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(queryValueTag)) {
                    this.setQueryValue(elem.getTextValue());
                    continue;
                }
                if (!elem.getName().equals(responsesTag)) continue;
                String aResponse = elem.getTextValue();
                if (null == aResponse) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"Discarding an empty response tag");
                    continue;
                }
                res.add(aResponse);
                if (elem instanceof Attributable) {
                    Attribute attr = ((Attributable)((Object)elem)).getAttribute(expirationTag);
                    if (null != attr) {
                        exp = Long.parseLong(attr.getValue());
                    } else {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Received an old-style DiscoveryResponse.\n You received a response from a peer that does \nnot support advertisement aging. \nSetting expiration to DiscoveryService.DEFAULT_EXPIRATION ");
                        }
                        exp = 0x6DDD00L;
                    }
                } else {
                    exp = 0x6DDD00L;
                }
                exps.add(new Long(exp));
            }
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Got an Exception during Parse ", (Throwable)failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Got an Exception during parse");
            failure.initCause(failed);
            throw failure;
        }
        this.setResponses(res);
        this.setExpirations(exps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream is) {
        StringBuffer stw = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(is);
        char[] buf = new char[512];
        try {
            int c;
            while ((c = reader.read(buf)) != -1) {
                stw.append(buf, 0, c);
            }
        }
        catch (IOException ie) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Got an Exception during stream conversion", (Throwable)ie);
            }
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
        return stw.toString();
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

