/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.id.ID;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.pipe.PipeRegistrar;
import net.jxta.impl.protocol.PipeResolverMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.resolver.InternalQueryHandler;
import net.jxta.impl.util.TimeUtils;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.PipeResolverMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class PipeResolver
implements Srdi.SrdiInterface,
InternalQueryHandler,
SrdiHandler,
PipeRegistrar {
    private static final Logger LOG = Logger.getLogger((String)PipeResolver.class.getName());
    private static final String PipeResolverName = "JxtaPipeResolver";
    private static final String srdiIndexerFileName = "pipeResolverSrdi";
    private static final long GcDelay = 60000L;
    static final int ANYQUERY = 0;
    private static int currentQueryID = 1;
    private PeerGroup myGroup = null;
    private ResolverService resolver = null;
    private DiscoveryService discovery = null;
    private MembershipService membership = null;
    private Srdi srdi = null;
    private Thread srdiThread = null;
    private SrdiIndex srdiIndex = null;
    private CredentialListener membershipCredListener = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private Map localInputPipes = new HashMap();
    private Map outputpipeListeners = new HashMap();

    static synchronized int getNextQueryID() {
        return currentQueryID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PipeResolver(PeerGroup g) {
        this.myGroup = g;
        this.resolver = this.myGroup.getResolverService();
        this.membership = this.myGroup.getMembershipService();
        this.resolver.registerHandler(PipeResolverName, this);
        this.srdiIndex = new SrdiIndex(this.myGroup, srdiIndexerFileName, 60000L);
        this.srdi = new Srdi(this.myGroup, PipeResolverName, this, this.srdiIndex, 120000L, 31536000000L);
        this.srdiThread = new Thread(this.myGroup.getHomeThreadGroup(), this.srdi, "Pipe Resolver Srdi Thread");
        this.srdiThread.setDaemon(true);
        this.srdiThread.start();
        this.resolver.registerSrdiHandler(PipeResolverName, this);
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            block5: {
                try {
                    this.credential = this.membership.getDefaultCredential();
                    this.credentialDoc = null != this.credential ? this.credential.getDocument(MimeMediaType.XMLUTF8) : null;
                }
                catch (Exception all) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)"could not get credential", (Throwable)all);
                }
            }
            this.membershipCredListener = new CredentialListener();
            this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
        }
    }

    public int processQuery(ResolverQueryMsg query) {
        return this.processQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processQuery(ResolverQueryMsg query, EndpointAddress srcAddr) {
        InputPipe ip;
        boolean queryForMe;
        PipeResolverMsg pipeQuery;
        String queryFrom = null != srcAddr ? ("jxta".equals(srcAddr.getProtocolName()) ? "urn:jxta:" + srcAddr.getProtocolAddress() : query.getSrc()) : query.getSrc();
        String responseDest = query.getSrc();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Starting for :" + query.getQueryId() + " from " + srcAddr));
        }
        StringReader queryReader = new StringReader(query.getQuery());
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, queryReader);
        }
        catch (IOException e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"discarding malformed request ", (Throwable)e);
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                ((Reader)queryReader).close();
            }
            catch (IOException ignored) {}
            queryReader = null;
        }
        try {
            pipeQuery = new PipeResolverMsg(doc);
        }
        catch (IllegalArgumentException badDoc) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"discarding malformed request ", (Throwable)badDoc);
            }
            int ignored = 0;
            return ignored;
        }
        finally {
            doc = null;
        }
        if (!pipeQuery.getMsgType().equals(PipeResolverMessage.MessageType.QUERY)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"expected query - discarding.");
            }
            return 0;
        }
        Set destPeers = pipeQuery.getPeerIDs();
        boolean directedQuery = !destPeers.isEmpty();
        boolean bl = queryForMe = !directedQuery;
        if (directedQuery) {
            Iterator eachDestPeer = destPeers.iterator();
            while (eachDestPeer.hasNext()) {
                ID aPeer = (ID)eachDestPeer.next();
                if (!aPeer.equals(this.myGroup.getPeerID())) continue;
                queryForMe = true;
                break;
            }
            if (!queryForMe) {
                if (query.getSrc().equals(queryFrom)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"discarding query. Query not for us.");
                    }
                    return 0;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"responding to 'misdirected' forwarded query.");
                }
                responseDest = queryFrom;
            }
        }
        PeerID peerID = null;
        if (queryForMe && (ip = this.findLocal((PipeID)pipeQuery.getPipeID())) != null && ip.getType().equals(pipeQuery.getPipeType())) {
            peerID = this.myGroup.getPeerID();
        }
        if (null == peerID && !directedQuery) {
            if (this.myGroup.isRendezvous()) {
                Vector results = this.srdiIndex.query(pipeQuery.getPipeType(), "Id", pipeQuery.getPipeID().toString(), 20);
                if (results.size() > 0) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("forwarding query to " + results.size() + " peers"));
                    }
                    Iterator eachPeer = results.iterator();
                    while (eachPeer.hasNext()) {
                        PeerID aPeer = (PeerID)eachPeer.next();
                        this.srdi.forwardQuery(aPeer, query);
                    }
                    return 0;
                }
                return -1;
            }
            if (query.getSrc().equals(queryFrom)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"discarding query.");
                }
                return 0;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"responding to query forwarded for 'misdirected' query.");
            }
            responseDest = queryFrom;
        }
        PipeResolverMsg pipeResp = new PipeResolverMsg();
        pipeResp.setMsgType(PipeResolverMessage.MessageType.ANSWER);
        pipeResp.setPipeID(pipeQuery.getPipeID());
        pipeResp.setPipeType(pipeQuery.getPipeType());
        if (null == peerID) {
            pipeResp.addPeerID(this.myGroup.getPeerID());
            pipeResp.setFound(false);
        } else {
            pipeResp.addPeerID(peerID);
            pipeResp.setFound(true);
            pipeResp.setInputPeerAdv(this.myGroup.getPeerAdvertisement());
        }
        ResolverResponseMsg res = query.makeResponse();
        res.setCredential(this.credentialDoc);
        res.setResponse(((PipeResolverMessage)pipeResp).getDocument(MimeMediaType.XMLUTF8).toString());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending answer for query '" + query.getQueryId() + "' to : " + responseDest));
        }
        this.resolver.sendResponse(responseDest, res);
        return 0;
    }

    public void processResponse(ResolverResponseMsg response) {
        this.processResponse(response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(ResolverResponseMsg response, EndpointAddress srcAddr) {
        PipeResolverMsg pipeResp;
        block36: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("got a response for '" + response.getQueryId() + "'"));
            }
            StringReader resp = new StringReader(response.getResponse());
            StructuredTextDocument doc = null;
            try {
                doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, resp);
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"malformed response - discard", e);
                }
                return;
            }
            finally {
                try {
                    ((Reader)resp).close();
                }
                catch (IOException ignored) {}
                resp = null;
            }
            try {
                pipeResp = new PipeResolverMsg(doc);
            }
            catch (Throwable caught) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"malformed response - discarding.", caught);
                }
                return;
            }
            finally {
                doc = null;
            }
            if (!pipeResp.getMsgType().equals(PipeResolverMessage.MessageType.ANSWER)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"expected response - discarding.");
                }
                return;
            }
            PeerAdvertisement padv = pipeResp.getInputPeerAdv();
            if (null != padv && !this.myGroup.getPeerID().equals(padv.getPeerID())) {
                try {
                    if (null == this.discovery) {
                        this.discovery = this.myGroup.getDiscoveryService();
                    }
                    if (null != this.discovery) {
                        this.discovery.publish(padv, 0x6DDD00L, 0x6DDD00L);
                    }
                }
                catch (IOException ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block36;
                    LOG.warn((Object)"could not publish peer adv");
                }
            }
        }
        String ipId = pipeResp.getPipeID().toString();
        Set peerRsps = pipeResp.getPeerIDs();
        Iterator eachResp = peerRsps.iterator();
        while (eachResp.hasNext()) {
            PeerID peer = (PeerID)eachResp.next();
            if (!pipeResp.isFound()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("NACK for pipe '" + ipId + "' from peer " + peer));
                }
                this.srdiIndex.add(pipeResp.getPipeType(), "Id", ipId, peer, 0L);
            } else {
                long exp = this.getEntryExp(pipeResp.getPipeType(), "Id", ipId, peer);
                if (600000L > exp) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Using Expiration 600000 which is > " + exp));
                    }
                    this.srdiIndex.add(pipeResp.getPipeType(), "Id", ipId, peer, 600000L);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("DB Expiration " + exp + " > " + 600000L + " overriding attempt to decrease lifetime"));
                }
            }
            this.callListener(response.getQueryId(), (PipeID)pipeResp.getPipeID(), pipeResp.getPipeType(), peer, !pipeResp.isFound());
        }
    }

    private long getEntryExp(String pkey, String skey, String value, PeerID peerid) {
        List list = this.srdiIndex.getRecord(pkey, skey, value);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SrdiIndex.Entry entry = (SrdiIndex.Entry)it.next();
            if (!entry.peerid.equals(peerid)) continue;
            return TimeUtils.toRelativeTimeMillis(entry.expiration);
        }
        return -1L;
    }

    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        if (message == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"no SRDI message");
            }
            return false;
        }
        if (message.getPayload() == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"empty SRDI message");
            }
            return false;
        }
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Invalid SRDI message", e);
            }
            return false;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Received an SRDI messsage with " + srdiMsg.getEntries().size() + " entries from " + srdiMsg.getPeerID()));
        }
        Iterator eachEntry = srdiMsg.getEntries().iterator();
        while (eachEntry.hasNext()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)eachEntry.next();
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), entry.key, entry.value, srdiMsg.getPeerID(), entry.expiration);
        }
        if (!"JxtaPropagate".equals(srdiMsg.getPrimaryKey())) {
            this.srdi.replicateEntries(srdiMsg);
        }
        return true;
    }

    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
    }

    public void pushEntries(boolean all) {
        this.pushSrdi((PeerID)null, all);
    }

    void stop() {
        this.resolver.unregisterHandler(PipeResolverName);
        this.resolver.unregisterSrdiHandler(PipeResolverName);
        this.srdiIndex.stop();
        this.srdiIndex = null;
        if (this.srdiThread != null) {
            this.srdi.stop();
        }
        this.srdiThread = null;
        this.srdi = null;
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.membershipCredListener = null;
        this.credential = null;
        this.credentialDoc = null;
        this.myGroup = null;
        this.resolver = null;
        this.discovery = null;
        this.membership = null;
        this.outputpipeListeners.clear();
        Iterator<Object> eachLocalInputPipe = Arrays.asList(this.localInputPipes.values().toArray()).iterator();
        while (eachLocalInputPipe.hasNext()) {
            InputPipe aPipe = (InputPipe)eachLocalInputPipe.next();
            try {
                aPipe.close();
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Failure closing " + aPipe));
            }
        }
        this.localInputPipes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(InputPipe ip) {
        PipeID pipeID = (PipeID)ip.getPipeID();
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            boolean registered;
            if (this.localInputPipes.containsKey(pipeID)) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Existing registered InputPipe for " + pipeID));
                }
                return false;
            }
            if (!ip.getType().equals("JxtaPropagate") && !(registered = this.myGroup.getEndpointService().addIncomingMessageListener((EndpointListener)((Object)ip), "PipeService", pipeID.toString()))) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Existing registered Endpoint Listener for " + pipeID));
                }
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Registering local InputPipe for " + pipeID));
            }
            this.localInputPipes.put(pipeID, ip);
        }
        this.callListener(0, pipeID, ip.getType(), this.myGroup.getPeerID(), false);
        return true;
    }

    public InputPipe findLocal(PipeID pipeID) {
        InputPipe ip;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Find local InputPipe for " + pipeID));
        }
        if (null != (ip = (InputPipe)this.localInputPipes.get(pipeID)) && LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("found local InputPipe for " + pipeID));
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forget(InputPipe pipe) {
        EndpointListener removed;
        InputPipe ip;
        PipeID pipeID = (PipeID)pipe.getPipeID();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Unregistering local InputPipe for " + pipeID));
        }
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            ip = (InputPipe)this.localInputPipes.remove(pipeID);
        }
        if (null != ip && !ip.getType().equals("JxtaPropagate") && (null == (removed = this.myGroup.getEndpointService().removeIncomingMessageListener("PipeService", pipeID.toString())) || pipe != removed) && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"removeIncomingMessageListener() did not remove correct pipe!");
        }
        return ip != null;
    }

    synchronized boolean addListener(PipeID pipeID, Listener listener, int queryID) {
        Integer queryKey;
        boolean alreadyThere;
        HashMap<Integer, Listener> perpipelisteners = (HashMap<Integer, Listener>)this.outputpipeListeners.get(pipeID);
        if (null == perpipelisteners) {
            perpipelisteners = new HashMap<Integer, Listener>();
            this.outputpipeListeners.put(pipeID, perpipelisteners);
        }
        if (!(alreadyThere = perpipelisteners.containsKey(queryKey = new Integer(queryID)))) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("adding listener for " + pipeID + " / " + queryID));
            }
            perpipelisteners.put(queryKey, listener);
        }
        return alreadyThere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callListener(int qid, PipeID pipeID, String type, PeerID peer, boolean NAK) {
        Event newevent = new Event(this, peer, pipeID, type, qid);
        boolean handled = false;
        while (!handled) {
            block10: {
                Listener pl = null;
                PipeResolver pipeResolver = this;
                synchronized (pipeResolver) {
                    Map perpipelisteners = (Map)this.outputpipeListeners.get(pipeID);
                    if (null == perpipelisteners) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("No listener for pipe: " + pipeID));
                        }
                        break;
                    }
                    pl = (Listener)perpipelisteners.get(new Integer(qid));
                }
                if (null != pl) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Calling Pipe resolver listener " + (NAK ? "NAK " : "") + "for pipe : " + pipeID));
                    }
                    try {
                        handled = NAK ? pl.pipeNAKEvent(newevent) : pl.pipeResolveEvent(newevent);
                    }
                    catch (Throwable ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block10;
                        LOG.warn((Object)("Uncaught Throwable in listener for: " + pipeID + "(" + pl.getClass().getName() + ")"), ignored);
                    }
                }
            }
            if (0 == qid) break;
            qid = 0;
        }
    }

    synchronized Listener removeListener(PipeID pipeID, int queryID) {
        Map perpipelisteners = (Map)this.outputpipeListeners.get(pipeID);
        if (null == perpipelisteners) {
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("removing listener for :" + pipeID + " / " + queryID));
        }
        Integer queryKey = new Integer(queryID);
        Listener removedListener = (Listener)perpipelisteners.remove(queryKey);
        if (0 == perpipelisteners.size()) {
            this.outputpipeListeners.remove(pipeID);
        }
        return removedListener;
    }

    int sendPipeQuery(PipeAdvertisement adv, Set acceptablePeers, int queryID) {
        if (0 == queryID) {
            queryID = PipeResolver.getNextQueryID();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)((acceptablePeers.isEmpty() ? "Undirected" : "Directed") + " query (" + queryID + ") for " + adv.getPipeID()));
        }
        Collection targetPeers = acceptablePeers;
        Vector knownLocations = this.srdiIndex.query(adv.getType(), "Id", adv.getPipeID().toString(), 100);
        if (!knownLocations.isEmpty()) {
            if (!acceptablePeers.isEmpty()) {
                knownLocations.retainAll(acceptablePeers);
            }
            if (!knownLocations.isEmpty()) {
                targetPeers = knownLocations;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Using SRDI cache results for directed query (" + queryID + ") for " + adv.getPipeID()));
                }
            }
        }
        PipeResolverMsg pipeQry = new PipeResolverMsg();
        pipeQry.setMsgType(PipeResolverMessage.MessageType.QUERY);
        pipeQry.setPipeID(adv.getPipeID());
        pipeQry.setPipeType(adv.getType());
        Iterator eachPeer = targetPeers.iterator();
        while (eachPeer.hasNext()) {
            pipeQry.addPeerID((PeerID)eachPeer.next());
        }
        StructuredTextDocument asDoc = (StructuredTextDocument)((PipeResolverMessage)pipeQry).getDocument(MimeMediaType.XMLUTF8);
        ResolverQuery query = new ResolverQuery();
        query.setHandlerName(PipeResolverName);
        query.setCredential(this.credentialDoc);
        query.setQueryId(queryID);
        query.setSrc(this.myGroup.getPeerID().toString());
        query.setQuery(asDoc.toString());
        if (targetPeers.isEmpty()) {
            PeerID peer;
            if (this.myGroup.isRendezvous() && null != (peer = this.srdi.getReplicaPeer(pipeQry.getPipeType() + "Id" + pipeQry.getPipeID().toString()))) {
                this.srdi.forwardQuery(peer.toString(), (ResolverQueryMsg)query);
                return queryID;
            }
            this.resolver.sendQuery(null, query);
        } else {
            eachPeer = targetPeers.iterator();
            while (eachPeer.hasNext()) {
                this.resolver.sendQuery(eachPeer.next().toString(), query);
            }
        }
        return queryID;
    }

    SrdiIndex getSrdiIndex() {
        return this.srdiIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSrdi(PeerID peer, boolean all) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Pushing " + (all ? "all" : "deltas") + " SRDI to " + peer));
        }
        HashMap<String, Vector<SrdiMessage.Entry>> types = new HashMap<String, Vector<SrdiMessage.Entry>>();
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            Iterator eachPipe = this.localInputPipes.values().iterator();
            while (eachPipe.hasNext()) {
                InputPipe ip = (InputPipe)eachPipe.next();
                SrdiMessage.Entry entry = new SrdiMessage.Entry("Id", ip.getPipeID().toString(), Long.MAX_VALUE);
                String type = ip.getType();
                Vector<SrdiMessage.Entry> entries = (Vector<SrdiMessage.Entry>)types.get(type);
                if (null == entries) {
                    entries = new Vector<SrdiMessage.Entry>();
                    types.put(type, entries);
                }
                entries.add(entry);
            }
        }
        Iterator eachType = types.keySet().iterator();
        while (eachType.hasNext()) {
            String type = (String)eachType.next();
            Vector entries = (Vector)types.get(type);
            eachType.remove();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending a Pipe SRDI messsage in " + this.myGroup.getPeerGroupID() + " of " + entries.size() + " entries of type " + type));
            }
            SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.myGroup.getPeerID(), 1, type, (List)entries);
            if (null == peer) {
                this.srdi.pushSrdi(null, srdiMsg);
                continue;
            }
            this.srdi.pushSrdi(peer, srdiMsg);
        }
    }

    void pushSrdi(InputPipe ip, boolean adding) {
        block6: {
            this.srdiIndex.add(ip.getType(), "Id", ip.getPipeID().toString(), this.myGroup.getPeerID(), adding ? Long.MAX_VALUE : 0L);
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.myGroup.getPeerID(), 1, ip.getType(), "Id", ip.getPipeID().toString(), adding ? Long.MAX_VALUE : 0L);
                if (this.myGroup.isRendezvous()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Replicating a" + (adding ? "n add" : " remove") + " Pipe SRDI entry for pipe [" + ip.getPipeID() + "] of type " + ip.getType()));
                    }
                    this.srdi.replicateEntries(srdiMsg);
                } else {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sending a" + (adding ? "n add" : " remove") + " Pipe SRDI messsage for pipe [" + ip.getPipeID() + "] of type " + ip.getType()));
                    }
                    this.srdi.pushSrdi(null, srdiMsg);
                }
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Uncaught throwable pushing SRDI entries", e);
            }
        }
    }

    static interface Listener
    extends EventListener {
        public boolean pipeResolveEvent(Event var1);

        public boolean pipeNAKEvent(Event var1);
    }

    static class Event
    extends EventObject {
        private PeerID peerid = null;
        private PipeID pipeid = null;
        private String type = null;
        private int queryID = -1;

        public Event(Object source, PeerID peerid, PipeID pipeid, String type, int queryid) {
            super(source);
            this.peerid = peerid;
            this.pipeid = pipeid;
            this.type = type;
            this.queryID = queryid;
        }

        public PeerID getPeerID() {
            return this.peerid;
        }

        public PipeID getPipeID() {
            return this.pipeid;
        }

        public String getType() {
            return this.type;
        }

        public int getQueryID() {
            return this.queryID;
        }
    }

    private class CredentialListener
    implements PropertyChangeListener {
        private CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"New default credential event");
                }
                PipeResolver pipeResolver = PipeResolver.this;
                synchronized (pipeResolver) {
                    block8: {
                        PipeResolver.this.credential = (Credential)evt.getNewValue();
                        PipeResolver.this.credentialDoc = null;
                        if (null != PipeResolver.this.credential) {
                            try {
                                PipeResolver.this.credentialDoc = PipeResolver.this.credential.getDocument(MimeMediaType.XMLUTF8);
                            }
                            catch (Exception all) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block8;
                                LOG.warn((Object)"Could not generate credential document", (Throwable)all);
                            }
                        }
                    }
                }
            }
        }
    }
}

