/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.PeerGroupInterface;
import net.jxta.peergroup.PeerGroup;
import net.jxta.service.Service;

class RefCountPeerGroupInterface
extends PeerGroupInterface {
    private Map roleMap;

    RefCountPeerGroupInterface(GenericPeerGroup theRealThing) {
        super(theRealThing);
    }

    RefCountPeerGroupInterface(GenericPeerGroup theRealThing, Map roleMap) {
        super(theRealThing);
        this.roleMap = roleMap;
    }

    public int startApp(String[] arg) {
        return ((GenericPeerGroup)this.groupImpl).startApp(arg);
    }

    public void stopApp() {
        this.unref();
    }

    public Service getInterface() {
        return ((GenericPeerGroup)this.groupImpl).getInterface();
    }

    public PeerGroup getWeakInterface() {
        return new PeerGroupInterface(this);
    }

    public void finalize() {
        this.unref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unref() {
        GenericPeerGroup theGrp;
        RefCountPeerGroupInterface refCountPeerGroupInterface = this;
        synchronized (refCountPeerGroupInterface) {
            if (this.groupImpl == null) {
                return;
            }
            theGrp = (GenericPeerGroup)this.groupImpl;
            this.groupImpl = null;
        }
        theGrp.decRefCount();
    }

    public Service lookupService(ID name) throws ServiceNotFoundException {
        return this.lookupService(name, 0);
    }

    public Service lookupService(ID name, int roleIndex) throws ServiceNotFoundException {
        ID[] map;
        if (this.roleMap != null && (map = (ID[])this.roleMap.get(name)) != null) {
            if (roleIndex < 0 || roleIndex >= map.length) {
                throw new ServiceNotFoundException("" + name + "[" + roleIndex + "]");
            }
            return this.groupImpl.lookupService(map[roleIndex]);
        }
        if (roleIndex != 0) {
            throw new ServiceNotFoundException("" + name + "[" + roleIndex + "]");
        }
        return this.groupImpl.lookupService(name);
    }

    public Iterator getRoleMap(ID name) {
        ID[] map;
        if (this.roleMap != null && (map = (ID[])this.roleMap.get(name)) != null) {
            return Collections.unmodifiableList(Arrays.asList(map)).iterator();
        }
        return Collections.singletonList(name).iterator();
    }
}

