/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.cbjx.CbJxDefs;
import net.jxta.impl.membership.PasswdMembershipService;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.peergroup.PlatformConfigurator;
import net.jxta.impl.peergroup.ShadowPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Platform
extends StdPeerGroup {
    private static final Logger LOG = Logger.getLogger((String)Platform.class.getName());
    private PlatformConfigurator configurator = null;
    private static boolean initialized = false;
    private ModuleImplAdvertisement allPurposeImplAdv = null;

    protected synchronized void initFirst(PeerGroup nullParent, ID assignedID, Advertisement impl) throws PeerGroupException {
        ModuleImplAdvertisement implAdv;
        block14: {
            if (initialized) {
                LOG.fatal((Object)"You cannot initialize more than one World PeerGroup!");
                throw new PeerGroupException("You cannot initialize more than one World PeerGroup!");
            }
            implAdv = (ModuleImplAdvertisement)impl;
            try {
                try {
                    String to = System.getProperty("sun.net.client.defaultConnectTimeout");
                    if (to == null) {
                        to = "notset";
                    }
                    Integer.parseInt(to);
                }
                catch (NumberFormatException nfe) {
                    System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
                }
            }
            catch (SecurityException disallowed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block14;
                LOG.warn((Object)"You could not get/set property : sun.net.client.defaultConnectTimeout");
            }
        }
        if (nullParent != null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"World PeerGroup cannot be instantiated with a parent group!");
            }
            throw new PeerGroupException("World PeerGroup cannot be instantiated with a parent group!");
        }
        if (null == implAdv) {
            try {
                implAdv = this.mkPlatformImplAdv();
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)"Fatal Error making Platform Impl Adv", e);
                }
                throw new PeerGroupException("Fatal Error making Platform Impl Adv", e);
            }
        }
        this.setConfigAdvertisement(this.generateConfigAdvertisement());
        this.invalidateConfigAdvertisement();
        super.initFirst(null, PeerGroupID.worldPeerGroupID, implAdv);
        this.saveConfigAdvertisement((PlatformConfig)this.getConfigAdvertisement());
        this.validateConfigAdvertisement();
        try {
            this.publishGroup("World PeerGroup", "Standard World PeerGroup Reference Implementation");
        }
        catch (IOException e) {
            throw new PeerGroupException("Failed to publish World Peer Group Advertisement", e);
        }
    }

    protected synchronized void initLast() throws PeerGroupException {
        super.initLast();
        initialized = true;
        ModuleSpecID id = PasswdMembershipService.passwordMembershipSpecID;
    }

    protected PlatformConfig generateConfigAdvertisement() throws PeerGroupException {
        PlatformConfig pc = null;
        Class c = PeerGroupFactory.getConfiguratorClass();
        if (c != null) {
            try {
                this.configurator = (PlatformConfigurator)c.newInstance();
            }
            catch (InstantiationException ie) {
                LOG.error((Object)("uninstantiatable configurator: " + c), (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                LOG.error((Object)("can't instantiate configurator: " + c), (Throwable)iae);
            }
        }
        if (this.configurator != null) {
            try {
                pc = this.configurator.getPlatformConfig();
            }
            catch (ConfiguratorException ce) {
                throw new PeerGroupException("Configurator failure", ce);
            }
        } else {
            throw new PeerGroupException("null configurator");
        }
        return pc;
    }

    protected void saveConfigAdvertisement(PlatformConfig config) {
        if (this.configurator != null) {
            this.configurator.setPlatformConfig(config);
            try {
                this.configurator.save();
            }
            catch (ConfiguratorException ce) {
                LOG.error((Object)"unable to persist configuration", (Throwable)ce);
            }
        }
    }

    protected void validateConfigAdvertisement() {
        if (this.configurator != null) {
            this.configurator.setReconfigure(false);
        }
    }

    protected void invalidateConfigAdvertisement() {
        if (this.configurator != null) {
            this.configurator.setReconfigure(true);
        }
    }

    protected ModuleImplAdvertisement mkPlatformImplAdv() throws Exception {
        ModuleImplAdvertisement platformDef = this.mkImplAdvBuiltin(PeerGroup.refPlatformSpecID, "World PeerGroup", "Standard World PeerGroup Reference Implementation");
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> protos = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> services = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> apps = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        ModuleImplAdvertisement moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refEndpointSpecID, "net.jxta.impl.endpoint.EndpointServiceImpl", "Reference Implementation of the Endpoint service");
        services.put(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refResolverSpecID, "net.jxta.impl.resolver.ResolverServiceImpl", "Reference Implementation of the Resolver service");
        services.put(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refMembershipSpecID, "net.jxta.impl.membership.none.NoneMembershipService", "Reference Implementation of the None Membership Service");
        services.put(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refAccessSpecID, "net.jxta.impl.access.always.AlwaysAccessService", "Always Access Service");
        services.put(PeerGroup.accessClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refDiscoverySpecID, "net.jxta.impl.discovery.DiscoveryServiceImpl", "Reference Implementation of the Discovery service");
        services.put(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRendezvousSpecID, "net.jxta.impl.rendezvous.RendezVousServiceImpl", "Reference Implementation of the Rendezvous Service");
        services.put(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPeerinfoSpecID, "net.jxta.impl.peer.PeerInfoServiceImpl", "Reference Implementation of the Peerinfo Service");
        services.put(PeerGroup.peerinfoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refTcpProtoSpecID, "net.jxta.impl.endpoint.tcp.TcpTransport", "Reference Implementation of the TCP Message Transport");
        protos.put(PeerGroup.tcpProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refHttpProtoSpecID, "net.jxta.impl.endpoint.servlethttp.ServletHttpTransport", "Reference Implementation of the HTTP Message Transport");
        protos.put(PeerGroup.httpProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refStartNetPeerGroupSpecID, "net.jxta.impl.peergroup.StartNetPeerGroup", "Start Net Peer Group");
        apps.put(applicationClassID, moduleAdv);
        paramAdv.setServices(services);
        paramAdv.setProtos(protos);
        paramAdv.setApps(apps);
        platformDef.setParam((StructuredDocument)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        return platformDef;
    }

    public void stopApp() {
        super.stopApp();
        initialized = false;
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        if (this.allPurposeImplAdv != null) {
            return (ModuleImplAdvertisement)this.allPurposeImplAdv.clone();
        }
        ModuleImplAdvertisement implAdv = this.mkImplAdvBuiltin(PeerGroup.refNetPeerGroupSpecID, ShadowPeerGroup.class.getName(), "Default NetPeerGroup reference implementation.");
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> services = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        ModuleImplAdvertisement moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refEndpointSpecID, "net.jxta.impl.endpoint.EndpointServiceImpl", "Reference Implementation of the Endpoint Service");
        services.put(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refResolverSpecID, "net.jxta.impl.resolver.ResolverServiceImpl", "Reference Implementation of the Resolver Service");
        services.put(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PSEMembershipService.pseMembershipSpecID, "net.jxta.impl.membership.pse.PSEMembershipService", "Reference Implementation of the PSE Membership Service");
        services.put(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refAccessSpecID, "net.jxta.impl.access.always.AlwaysAccessService", "Always Access Service");
        services.put(PeerGroup.accessClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refDiscoverySpecID, "net.jxta.impl.discovery.DiscoveryServiceImpl", "Reference Implementation of the Discovery Service");
        services.put(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRendezvousSpecID, "net.jxta.impl.rendezvous.RendezVousServiceImpl", "Reference Implementation of the Rendezvous Service");
        services.put(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPipeSpecID, "net.jxta.impl.pipe.PipeServiceImpl", "Reference Implementation of the Pipe Service");
        services.put(PeerGroup.pipeClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPeerinfoSpecID, "net.jxta.impl.peer.PeerInfoServiceImpl", "Reference Implementation of the Peerinfo Service");
        services.put(PeerGroup.peerinfoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refProxySpecID, "net.jxta.impl.proxy.ProxyService", "Reference Implementation of the JXME Proxy Service");
        services.put(PeerGroup.proxyClassID, moduleAdv);
        paramAdv.setServices(services);
        Hashtable<ModuleClassID, ModuleImplAdvertisement> protos = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRouterProtoSpecID, "net.jxta.impl.endpoint.router.EndpointRouter", "Reference Implementation of the Router Message Transport");
        protos.put(PeerGroup.routerProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refTlsProtoSpecID, "net.jxta.impl.endpoint.tls.TlsTransport", "Reference Implementation of the JXTA TLS Message Transport");
        protos.put(PeerGroup.tlsProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(CbJxDefs.cbjxMsgTransportSpecID, "net.jxta.impl.endpoint.cbjx.CbJxTransport", "Reference Implementation of the JXTA Cryptobased-ID Message Transport");
        protos.put(CbJxDefs.msgtptClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRelayProtoSpecID, "net.jxta.impl.endpoint.relay.RelayTransport", "Reference Implementation of the Relay Message Transport");
        protos.put(PeerGroup.relayProtoClassID, moduleAdv);
        paramAdv.setProtos(protos);
        ModuleImplAdvertisement newAppAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        newAppAdv.setModuleSpecID(PeerGroup.refShellSpecID);
        newAppAdv.setCompat(implAdv.getCompat());
        newAppAdv.setUri(implAdv.getUri());
        newAppAdv.setProvider(implAdv.getProvider());
        newAppAdv.setDescription("JXTA Shell");
        newAppAdv.setCode("net.jxta.impl.shell.bin.Shell.Shell");
        Hashtable<ModuleClassID, ModuleImplAdvertisement> newApps = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        newApps.put(PeerGroup.applicationClassID, newAppAdv);
        paramAdv.setApps(newApps);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        this.allPurposeImplAdv = implAdv;
        return implAdv;
    }
}

