/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.JxtaError;
import net.jxta.impl.config.Config;
import net.jxta.impl.peergroup.PlatformConfigurator;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.protocol.ConfigParams;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class NullConfigurator
implements PlatformConfigurator {
    private static final transient Logger LOG = Logger.getLogger((String)NullConfigurator.class.getName());
    protected static final String configFileName = "PlatformConfig";
    protected static final String propertiesFileName = "jxta.properties";
    protected File jxtaHomeDir = new File(Config.JXTA_HOME);
    protected File configFile = new File(this.jxtaHomeDir, "PlatformConfig");
    protected File propertiesFile = new File(this.jxtaHomeDir, "jxta.properties");
    protected PlatformConfig advertisement = null;

    public NullConfigurator() throws ConfiguratorException {
        this(null);
    }

    public NullConfigurator(PlatformConfig config) throws ConfiguratorException {
        this.setPlatformConfig(config);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            try {
                LOG.info((Object)("JXTA_HOME = " + this.jxtaHomeDir.getCanonicalPath()));
            }
            catch (IOException caught) {
                LOG.info((Object)("JXTA_HOME (which doesn't seem to exist) = " + this.jxtaHomeDir.getAbsolutePath()));
            }
        }
        if (this.jxtaHomeDir.exists() && !this.jxtaHomeDir.isDirectory()) {
            throw new IllegalArgumentException("'" + Config.JXTA_HOME + "' is not a directory.");
        }
        if (!this.jxtaHomeDir.exists() && !this.jxtaHomeDir.mkdirs()) {
            throw new IllegalStateException("Could not create '" + Config.JXTA_HOME + "'.");
        }
        this.resetFromResource(configFileName, this.configFile);
        this.resetFromResource(propertiesFileName, this.propertiesFile);
        this.load();
        this.adjustLog4JPriority();
    }

    public PlatformConfig getPlatformConfig() {
        return this.advertisement;
    }

    public void setPlatformConfig(PlatformConfig config) {
        if (config != null) {
            this.advertisement = config;
        }
    }

    public ConfigParams getConfigParams() throws ConfiguratorException {
        return this.advertisement;
    }

    public void setConfigParams(ConfigParams pc) {
        this.advertisement = (PlatformConfig)pc;
    }

    public void setReconfigure(boolean reconfigure) {
        throw new UnsupportedOperationException("Unsupported operation for null configurator");
    }

    public boolean isReconfigure() {
        return false;
    }

    public boolean save() throws ConfiguratorException {
        throw new UnsupportedOperationException("Unsupported operation for null configurator");
    }

    public boolean save(File f) throws ConfiguratorException {
        throw new UnsupportedOperationException("Unsupported operation for null configurator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFromResource(String resourceName, File file) {
        block20: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Checkin resource= " + resourceName + " local= " + file.getPath()));
            }
            try {
                if (file.exists()) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)(file.getPath() + " already exists"));
                    }
                    return;
                }
                InputStream in = this.getClass().getResourceAsStream("/" + resourceName);
                if (in == null) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)(resourceName + " does not exist"));
                    }
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)(resourceName + " reset " + file.getPath()));
                }
                FileOutputStream out = null;
                try {
                    int got;
                    out = new FileOutputStream(file);
                    int bufferSize = 16384;
                    byte[] buffer = new byte[bufferSize];
                    while ((got = in.read(buffer)) != -1) {
                        out.write(buffer, 0, got);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    try {
                        if (null != out) {
                            out.close();
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    if (null != out) {
                        out.close();
                    }
                }
                catch (IOException ignored) {}
            }
            catch (IOException ez) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block20;
                LOG.error((Object)("Cannot reset " + resourceName + " from resource."), (Throwable)ez);
            }
        }
    }

    public void load() {
        this.loadFrom(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFrom(File file) {
        block20: {
            FileInputStream advStream;
            block19: {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Reading Platform Config from : " + file.getAbsolutePath()));
                }
                advStream = null;
                advStream = new FileInputStream(file);
                this.advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, advStream);
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block19;
                LOG.debug((Object)("Recovered Platform Config from : " + file.getAbsolutePath()));
            }
            Object var7_3 = null;
            try {
                if (advStream != null) {
                    advStream.close();
                }
                advStream = null;
            }
            catch (Exception ignored) {}
            break block20;
            {
                catch (FileNotFoundException e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Platform Config not found : " + file.getAbsolutePath()));
                    }
                    Object var7_4 = null;
                    try {
                        if (advStream != null) {
                            advStream.close();
                        }
                        advStream = null;
                    }
                    catch (Exception ignored) {}
                    break block20;
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Failed to Recover '" + file.getAbsolutePath() + "' due to : "), (Throwable)e);
                    }
                    try {
                        file.delete();
                    }
                    catch (Exception ex1) {
                        JxtaError failure = new JxtaError("Could not remove " + file.getPath() + ". Removed it by hand before retrying");
                        LOG.fatal((Object)failure);
                        throw failure;
                    }
                    Object var7_5 = null;
                    try {
                        if (advStream != null) {
                            advStream.close();
                        }
                        advStream = null;
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (advStream != null) {
                        advStream.close();
                    }
                    advStream = null;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void adjustLog4JPriority() {
        if (this.advertisement == null || this.advertisement.getDebugLevel() == null) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Log4J logging preference not set, using defaults");
            }
            return;
        }
        String requestedLevel = this.advertisement.getDebugLevel();
        if ("user default".equals(requestedLevel)) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Log4J [user default] requested, not adjusting logging priority");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Setting Log4J priority to [" + requestedLevel + "] based on the user's configuration"));
        }
        Logger jxtaLogger = Logger.getLogger((String)"net.jxta");
        jxtaLogger.setLevel(Level.toLevel((String)requestedLevel));
    }
}

