/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.JxtaError;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.peergroup.ConfigDialog;
import net.jxta.impl.peergroup.NullConfigurator;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import net.jxta.util.AwtUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefaultConfigurator
extends NullConfigurator {
    private static final transient Logger LOG = Logger.getLogger((String)DefaultConfigurator.class.getName());

    public DefaultConfigurator() throws ConfiguratorException {
        this(null);
    }

    public DefaultConfigurator(PlatformConfig config) throws ConfiguratorException {
        super(config);
        if (this.fixAdvertisement()) {
            try {
                AwtUtils.initAsDaemon();
                ConfigDialog ignore = new ConfigDialog(this.jxtaHomeDir, this.advertisement);
                ignore.untilDone();
            }
            catch (Throwable t) {
                if (t instanceof JxtaError) {
                    throw (JxtaError)t;
                }
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Could not initialize graphical config dialog", t);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    while (in.ready()) {
                        in.readLine();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                System.out.println("The window-based configurator does not seem to be usable.");
                System.out.print("Do you want to stop and edit the current configuration ? [no]: ");
                System.out.flush();
                String answer = "no";
                try {
                    answer = in.readLine();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if ("yes".equalsIgnoreCase(answer)) {
                    try {
                        this.save();
                    }
                    catch (ConfiguratorException ce) {
                        LOG.error((Object)"cant' persist configuration", (Throwable)ce);
                    }
                    System.out.println("Exiting; edit the file \"" + this.configFile.getPath() + "\", remove the file \"reconf\", and then launch JXTA again.");
                    throw new JxtaError("Manual Configuration Requested");
                }
                System.out.println("Attempting to continue using the current configuration.");
            }
        }
        this.adjustLog4JPriority();
        this.finishConfig();
        try {
            this.save();
        }
        catch (ConfiguratorException ce) {
            LOG.error((Object)"can't persist configuration", (Throwable)ce);
        }
    }

    public void setReconfigure(boolean reconfigure) {
        block6: {
            File f = new File(this.jxtaHomeDir, "reconf");
            if (reconfigure) {
                try {
                    new FileOutputStream(f).close();
                }
                catch (Exception ex1) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Could not create reconfig flag due to exception : ", (Throwable)ex1);
                        LOG.error((Object)"Create the file 'reconf' by hand before retrying.");
                    }
                    break block6;
                }
            }
            try {
                f.delete();
            }
            catch (Exception ex1) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                LOG.error((Object)"Could not remove reconfig flag due to exception : ", (Throwable)ex1);
                LOG.error((Object)"Delete the file reconfig by hand before retrying.");
            }
        }
    }

    public boolean isReconfigure() {
        try {
            File file = new File(this.jxtaHomeDir, "reconf");
            boolean forceReconfig = file.exists();
            if (forceReconfig && LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Reconfig required - 'reconf' file found");
            }
            return forceReconfig;
        }
        catch (Exception ex1) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not check reconfig flag. Assuming it exists.", (Throwable)ex1);
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Reconfig required - error getting 'reconf' file");
            }
            return true;
        }
    }

    public boolean save() throws ConfiguratorException {
        return this.save(this.configFile);
    }

    public boolean save(File f) throws ConfiguratorException {
        this.saveTo(f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveTo(File saveFile) {
        block13: {
            FileOutputStream out = null;
            out = new FileOutputStream(saveFile);
            Document aDoc = this.advertisement.getDocument(MimeMediaType.XMLUTF8);
            aDoc.sendToStream(out);
            Object var5_5 = null;
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            out = null;
            {
                break block13;
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Could not save to : " + saveFile.getAbsolutePath()), (Throwable)e);
                    }
                    Object var5_6 = null;
                    try {
                        if (null != out) {
                            out.close();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    out = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (null != out) {
                        out.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                out = null;
                throw throwable;
            }
        }
    }

    private String parseHttpProxyServer(String proxy) {
        if (proxy.indexOf(";") >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(proxy, ";");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (!token.startsWith("http=")) continue;
                return token;
            }
        }
        return proxy;
    }

    private boolean fixAdvertisement() {
        block64: {
            try {
                RdvConfigAdv rdvAdv;
                StructuredTextDocument proxy;
                boolean tcpDisabled;
                TCPAdv tcpAdv;
                boolean httpDisabled;
                HTTPAdv httpAdv;
                StructuredDocument tcp;
                StructuredDocument http;
                boolean reconf;
                block63: {
                    boolean secureNeedsReconf;
                    block62: {
                        String winProxy;
                        String intf;
                        String cfMode;
                        XMLElement param;
                        reconf = this.isReconfigure();
                        if (this.advertisement == null) {
                            reconf = true;
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"Reconfig requested - New PlatformConfig Advertisement");
                            }
                            this.advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
                            this.advertisement.setDescription("Platform Config Advertisement created by : " + DefaultConfigurator.class.getName());
                        }
                        http = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                        tcp = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.tcpProtoClassID);
                        httpAdv = null;
                        httpDisabled = false;
                        tcpAdv = null;
                        tcpDisabled = false;
                        if (http != null) {
                            try {
                                httpDisabled = http.getChildren("isOff").hasMoreElements();
                                param = null;
                                Enumeration httpChilds = http.getChildren(TransportAdvertisement.getAdvertisementType());
                                if (httpChilds.hasMoreElements()) {
                                    param = (XMLElement)httpChilds.nextElement();
                                } else {
                                    httpChilds = http.getChildren(HTTPAdv.getAdvertisementType());
                                    if (httpChilds.hasMoreElements()) {
                                        param = (XMLElement)httpChilds.nextElement();
                                    }
                                }
                                httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(param);
                                cfMode = httpAdv.getConfigMode();
                                if (cfMode == null) {
                                    cfMode = "auto";
                                }
                                if (null != (intf = httpAdv.getInterfaceAddress()) && intf.trim().length() < 1 && !this.isValidInetAddress(intf.trim())) {
                                    reconf = true;
                                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                        LOG.info((Object)"Reconfig requested - invalid interface address");
                                    }
                                }
                            }
                            catch (Exception advTrouble) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)advTrouble);
                                }
                                httpAdv = null;
                            }
                        }
                        if (httpAdv == null) {
                            reconf = true;
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"Reconfig requested - http advertisement missing, making a new one.");
                            }
                            httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
                            httpAdv.setProtocol("http");
                            httpAdv.setPort(9700);
                            httpAdv.setProxyEnabled(false);
                            httpAdv.setServerEnabled(false);
                        }
                        if (tcp != null) {
                            try {
                                tcpDisabled = tcp.getChildren("isOff").hasMoreElements();
                                param = null;
                                Enumeration tcpChilds = tcp.getChildren(TransportAdvertisement.getAdvertisementType());
                                if (tcpChilds.hasMoreElements()) {
                                    param = (XMLElement)tcpChilds.nextElement();
                                } else {
                                    tcpChilds = tcp.getChildren(TCPAdv.getAdvertisementType());
                                    if (tcpChilds.hasMoreElements()) {
                                        param = (XMLElement)tcpChilds.nextElement();
                                    }
                                }
                                tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(param);
                                cfMode = tcpAdv.getConfigMode();
                                if (cfMode == null) {
                                    cfMode = "auto";
                                }
                                if (null != (intf = tcpAdv.getInterfaceAddress()) && intf.trim().length() < 1 && !this.isValidInetAddress(intf.trim())) {
                                    reconf = true;
                                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                        LOG.info((Object)"Reconfig requested - invalid interface address");
                                    }
                                }
                            }
                            catch (Exception advTrouble) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Reconfig requested - tcp advertisement corrupted", (Throwable)advTrouble);
                                }
                                tcpAdv = null;
                            }
                        }
                        if (tcpAdv == null) {
                            int port;
                            block61: {
                                reconf = true;
                                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                    LOG.info((Object)"Reconfig requested - tcp advertisement missing, making a new one.");
                                }
                                port = 9701;
                                String tcpPort = System.getProperty("jxta.tcp.port");
                                if (tcpPort != null) {
                                    try {
                                        int propertyPort = Integer.parseInt(tcpPort);
                                        if (propertyPort < 65536 && propertyPort >= 0) {
                                            port = propertyPort;
                                        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                            LOG.warn((Object)("Property 'jxta.tcp.port' is not a valid port number : " + propertyPort));
                                        }
                                    }
                                    catch (NumberFormatException ignored) {
                                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block61;
                                        LOG.warn((Object)("Property 'jxta.tcp.port' was not an integer : " + tcpPort));
                                    }
                                }
                            }
                            tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
                            tcpAdv.setProtocol("TCP");
                            tcpAdv.setPort(port);
                            tcpAdv.setMulticastAddr("224.0.1.85");
                            tcpAdv.setMulticastPort(1234);
                            tcpAdv.setMulticastSize(16384);
                            tcpAdv.setMulticastState(true);
                            tcpAdv.setServer("");
                            tcpAdv.setInterfaceAddress("");
                        }
                        if ((winProxy = System.getProperty("jxta.proxy")) != null) {
                            String proxyServer = this.parseHttpProxyServer(winProxy);
                            if (proxyServer != null) {
                                httpAdv.setProxyEnabled(true);
                                httpAdv.setProxy(proxyServer.substring(proxyServer.indexOf("=") + 1));
                                String proxyUser = System.getProperty("jxta.proxy.user");
                                String proxyPassword = System.getProperty("jxta.proxy.password");
                                if (proxyUser != null && proxyPassword != null) {
                                    char[] proxyPass = proxyPassword.toCharArray();
                                    PasswordAuthentication pass = new PasswordAuthentication(proxyUser, proxyPass);
                                    Authenticator.setDefault(new ProxyAuthenticator(pass));
                                }
                                System.setProperty("jxta.proxy.user", "");
                                System.setProperty("jxta.proxy.password", "");
                            }
                        } else if (httpAdv.getProxy() == null) {
                            httpAdv.setProxy("myProxy.myDomain:8080");
                            httpAdv.setProxyEnabled(false);
                        }
                        secureNeedsReconf = true;
                        try {
                            XMLElement param2 = (XMLElement)((Object)this.advertisement.getServiceParam(PeerGroup.membershipClassID));
                            if (param2 == null) break block62;
                            try {
                                Advertisement adv = AdvertisementFactory.newAdvertisement(param2);
                                if (adv instanceof PSEConfigAdv) {
                                    secureNeedsReconf = false;
                                }
                            }
                            catch (NoSuchElementException notPSEConfigAdv) {}
                        }
                        catch (Exception nobigdeal) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block62;
                            LOG.warn((Object)"Failure reading PSEConfigAdv. Will make a new one.", (Throwable)nobigdeal);
                        }
                    }
                    if (secureNeedsReconf) {
                        this.advertisement.removeServiceParam(PeerGroup.membershipClassID);
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)"Reconfig requested - PSE wanted config");
                        }
                    }
                    if (secureNeedsReconf && null != System.getProperty("net.jxta.tls.principal") && null != System.getProperty("net.jxta.tls.password")) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Bypassing Security config UI");
                        }
                        PSEConfigAdv pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
                        PSEUtils.IssuerInfo info = PSEUtils.genCert(System.getProperty("net.jxta.tls.principal"), null);
                        pseConf.setCertificate(info.cert);
                        pseConf.setPrivateKey(info.subjectPkey, System.getProperty("net.jxta.tls.password").toCharArray());
                        XMLDocument pseDoc = (XMLDocument)pseConf.getDocument(MimeMediaType.XMLUTF8);
                        this.advertisement.putServiceParam(PeerGroup.membershipClassID, pseDoc);
                        secureNeedsReconf = false;
                    }
                    reconf |= secureNeedsReconf;
                    proxy = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.proxyClassID);
                    try {
                        XMLElement param = (XMLElement)((Object)this.advertisement.getServiceParam(PeerGroup.rendezvousClassID));
                        if (param != null) {
                            try {
                                Advertisement adv = AdvertisementFactory.newAdvertisement(param);
                                if (adv instanceof RdvConfigAdv) {
                                    rdvAdv = (RdvConfigAdv)adv;
                                    break block63;
                                }
                                rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
                            }
                            catch (NoSuchElementException notRdvConfigAdv) {
                                rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
                                Enumeration rdvEnum = param.getChildren("Addr");
                                while (rdvEnum.hasMoreElements()) {
                                    String addrElement = ((XMLElement)rdvEnum.nextElement()).getTextValue();
                                    if (null == addrElement) continue;
                                    rdvAdv.addSeedRendezvous(URI.create(addrElement));
                                }
                                Enumeration rdv = param.getChildren("Rdv");
                                boolean isRendezvous = rdv.hasMoreElements() && "true".equals(((XMLElement)rdv.nextElement()).getTextValue().trim());
                                rdvAdv.setConfiguration(isRendezvous ? RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS : RdvConfigAdv.RendezVousConfiguration.EDGE);
                                Attribute flags = param.getAttribute("Flags");
                                if (flags != null) {
                                    boolean onlySeeds = flags.getValue().indexOf("UseOnlySeeds") != -1;
                                    rdvAdv.setUseOnlySeeds(onlySeeds);
                                }
                                break block63;
                            }
                        }
                        rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
                    }
                    catch (Exception failure) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"Problem reading rendezvous configuration", (Throwable)failure);
                        }
                        rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
                    }
                }
                XMLDocument rdvDoc = (XMLDocument)rdvAdv.getDocument(MimeMediaType.XMLUTF8);
                this.advertisement.putServiceParam(PeerGroup.rendezvousClassID, rdvDoc);
                if (null == proxy) {
                    proxy = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    proxy.appendChild(proxy.createElement((Object)"isOff"));
                    this.advertisement.putServiceParam(PeerGroup.proxyClassID, proxy);
                }
                if (!reconf) {
                    return false;
                }
                http = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredDocument httAdvDoc = (StructuredDocument)httpAdv.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(http, http, httAdvDoc);
                if (httpDisabled) {
                    http.appendChild(http.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, http);
                tcp = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredDocumentUtils.copyElements(tcp, tcp, (StructuredDocument)tcpAdv.getDocument(MimeMediaType.XMLUTF8));
                if (tcpDisabled) {
                    tcp.appendChild(tcp.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.tcpProtoClassID, tcp);
            }
            catch (Exception serious) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block64;
                LOG.error((Object)"Trouble while fixing advertisement. Hope for the best.", (Throwable)serious);
            }
        }
        return true;
    }

    private boolean finishConfig() {
        return true;
    }

    private boolean isValidInetAddress(String ia) {
        boolean found = false;
        boolean loopback = false;
        String string = ia = ia != null ? ia.trim() : "";
        if (ia.length() > 0) {
            InetAddress[] ias = null;
            try {
                ias = InetAddress.getAllByName(ia);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            Iterator la = IPUtils.getAllLocalAddresses();
            while (la.hasNext() && !found) {
                for (int i = 0; i < ias.length; ++i) {
                    found |= ias[i].equals((InetAddress)la.next());
                }
            }
            loopback = true;
            for (int i = 0; i < ias.length; ++i) {
                loopback &= ias[i].isLoopbackAddress();
            }
        }
        return found || loopback;
    }

    class ProxyAuthenticator
    extends Authenticator {
        PasswordAuthentication password = null;

        public ProxyAuthenticator(PasswordAuthentication password) {
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.password;
        }
    }
}

