/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.meter;

import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.meter.ServiceMonitorImpl;
import net.jxta.impl.meter.ServiceMonitorPulseInfo;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleImplAdvertisement;

public abstract class GenericServiceMonitor
implements ServiceMonitorImpl,
Module {
    private ModuleClassID moduleClassID;
    protected MonitorManager monitorManager;
    protected long reportRate;
    protected int reportRateIndex;
    private Hashtable resolverHandlerMeters = new Hashtable();
    protected ServiceMetric cumulativeServiceMetric;
    protected ServiceMetric[] deltaServiceMetrics;
    protected ModuleImplAdvertisement implAdvertisement;

    public void init(PeerGroup group, ID assignedID, Advertisement advertisement) {
        group.unref();
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.moduleClassID = (ModuleClassID)assignedID;
    }

    public void init(MonitorManager monitorManager) {
        this.monitorManager = monitorManager;
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    protected void init() {
    }

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public PeerGroup getPeerGroup() {
        return this.monitorManager.getPeerGroup();
    }

    protected ServiceMetric getCumulativeServiceMetric() {
        return this.cumulativeServiceMetric;
    }

    public void resetPulseRate(ServiceMonitorPulseInfo pulseInfo, int oldPulseRateIndex) {
        this.reportRate = pulseInfo.getPulseRate();
        this.reportRateIndex = pulseInfo.getPulseRateIndex();
    }

    public void validateCumulativeServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter) {
    }

    public ServiceMonitorFilter createSupportedCumulativeServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter) {
        return serviceMonitorFilter;
    }

    public void validateServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter, long reportRate) {
    }

    public ServiceMonitorFilter createSupportedServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter, long reportRate) {
        return serviceMonitorFilter;
    }

    protected ServiceMetric createServiceMetric() {
        try {
            return MonitorResources.createServiceMetric(this.moduleClassID);
        }
        catch (JxtaException e) {
            return null;
        }
    }

    protected abstract ServiceMetric collectServiceMetrics();

    public synchronized void beginPulse(ServiceMonitorPulseInfo pulseInfo) {
        ServiceMetric baseDeltaServiceMetric;
        boolean anyData = false;
        this.deltaServiceMetrics[this.reportRateIndex] = baseDeltaServiceMetric = this.collectServiceMetrics();
        if (baseDeltaServiceMetric != null) {
            for (int reportRate = this.reportRateIndex + 1; reportRate < this.deltaServiceMetrics.length; ++reportRate) {
                if (!pulseInfo.isRegisteredFilterForRate(reportRate)) continue;
                if (this.deltaServiceMetrics[reportRate] == null) {
                    this.deltaServiceMetrics[reportRate] = this.createServiceMetric();
                }
                this.deltaServiceMetrics[reportRate].mergeMetrics(baseDeltaServiceMetric);
            }
        }
    }

    public void endPulse(ServiceMonitorPulseInfo pulseInfo) {
        for (int reportRateIndex = 0; reportRateIndex < this.monitorManager.getReportRatesCount(); ++reportRateIndex) {
            if (!pulseInfo.isEvenPulseForRateIndex(reportRateIndex)) continue;
            this.deltaServiceMetrics[reportRateIndex] = null;
        }
    }

    public void beginCumulativeReport() {
    }

    public void endCumulativeReport() {
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int reportIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        return this.deltaServiceMetrics[deltaReportRateIndex];
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        return this.cumulativeServiceMetric;
    }

    public void serviceMonitorFilterRegistered(ServiceMonitorFilter serviceMonitorFilter, int reportRateIndex, long reportRate, boolean newRate) {
        if (newRate) {
            this.deltaServiceMetrics[reportRateIndex] = this.createServiceMetric();
        }
    }

    public void serviceMonitorFilterDeregistered(ServiceMonitorFilter serviceMonitorFilter, int reportRateIndex, long reportRate, boolean retiredRate) {
        if (retiredRate) {
            this.deltaServiceMetrics[reportRateIndex] = null;
        }
    }

    public void destroy() {
    }
}

