/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.PSEConfig;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class URIKeyStoreManager
implements KeyStoreManager {
    private static final transient Logger LOG = Logger.getLogger((String)PSEConfig.class.getName());
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private String keystore_type;
    private String keystore_provider;
    private URI keystore_location;

    public URIKeyStoreManager(String type, String provider, URI location) throws NoSuchProviderException, KeyStoreException {
        File asFile;
        if (null == type) {
            type = DEFAULT_KEYSTORE_TYPE;
            provider = null;
        }
        if ("pkcs12".equalsIgnoreCase(type)) {
            if ("BC".equals(provider)) {
                provider = null;
            }
            boolean hasJDK15 = System.getProperty("java.specification.version", "0.0").compareTo("1.5") >= 0;
            String string = provider = hasJDK15 ? null : "BC";
        }
        if (!location.isAbsolute()) {
            throw new IllegalArgumentException("location must be an absolute URI");
        }
        if ("file".equalsIgnoreCase(location.getScheme()) && (asFile = new File(location)).exists() && !asFile.isFile()) {
            throw new IllegalArgumentException("location must refer to a file");
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("pse location = " + location));
        }
        this.keystore_type = type;
        this.keystore_provider = provider;
        this.keystore_location = location;
        if (null == this.keystore_provider) {
            KeyStore.getInstance(this.keystore_type);
        } else {
            KeyStore.getInstance(this.keystore_type, this.keystore_provider);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized(null);
    }

    public boolean isInitialized(char[] store_password) {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURL().openStream(), store_password);
            return true;
        }
        catch (Exception failed) {
            return false;
        }
    }

    public void createKeyStore(char[] store_password) throws KeyStoreException, IOException {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(null, store_password);
            this.saveKeyStore(store, store_password);
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public KeyStore loadKeyStore(char[] password) throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Loading (" + this.keystore_type + "," + this.keystore_provider + ") store from " + this.keystore_location));
        }
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURL().openStream(), password);
            return store;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void saveKeyStore(KeyStore store, char[] password) throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Writing " + store + " to " + this.keystore_location));
        }
        try {
            OutputStream os = null;
            os = "file".equalsIgnoreCase(this.keystore_location.getScheme()) ? new FileOutputStream(new File(this.keystore_location)) : this.keystore_location.toURL().openConnection().getOutputStream();
            store.store(os, password);
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void eraseKeyStore() {
        if ("file".equalsIgnoreCase(this.keystore_location.getScheme())) {
            File asFile = new File(this.keystore_location);
            if (asFile.exists() && asFile.isFile() && asFile.canWrite()) {
                asFile.delete();
            }
        } else {
            throw new UnsupportedOperationException("Unable to delete non-file URI");
        }
    }
}

