/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.config.Config;
import net.jxta.impl.membership.pse.CMKeyStoreManager;
import net.jxta.impl.membership.pse.DialogAuthenticator;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.impl.membership.pse.URIKeyStoreManager;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.membership.Authenticator;
import net.jxta.membership.InteractiveAuthenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSEMembershipService
implements MembershipService {
    private static final transient Logger LOG = Logger.getLogger((String)PSEMembershipService.class.getName());
    public static final ModuleSpecID pseMembershipSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000050306"));
    PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    PSEConfig pseStore = null;
    private PSECredential defaultCredential = null;
    private List principals = new ArrayList();
    private List authCredentials = new ArrayList();
    private PropertyChangeSupport support = new PropertyChangeSupport(this.getInterface());
    private PSEConfigAdv config;
    private boolean doAutoLogin = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        KeyStoreManager store_manager;
        this.assignedID = assignedID;
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        ConfigParams configAdv = group.getConfigAdvertisement();
        StructuredDocument param = configAdv.getServiceParam(assignedID);
        if (null == param) {
            throw new PeerGroupException("Could not locate a " + PSEConfigAdv.getAdvertisementType());
        }
        Advertisement paramsAdv = null;
        try {
            paramsAdv = AdvertisementFactory.newAdvertisement((XMLElement)((Object)param));
        }
        catch (NoSuchElementException ignored) {
            // empty catch block
        }
        if (!(paramsAdv instanceof PSEConfigAdv)) {
            throw new PeerGroupException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
        }
        this.config = (PSEConfigAdv)paramsAdv;
        URI location = this.config.getKeyStoreLocation();
        try {
            if (null == location) {
                Cm cm = ((StdPeerGroup)group).getCacheManager();
                store_manager = new CMKeyStoreManager(this.config.getKeyStoreType(), this.config.getKeyStoreProvider(), cm, assignedID);
            } else {
                if (!location.isAbsolute()) {
                    File pseHome = new File(Config.JXTA_HOME);
                    location = location.resolve(pseHome.toURI());
                }
                store_manager = new URIKeyStoreManager(this.config.getKeyStoreType(), this.config.getKeyStoreProvider(), location);
            }
        }
        catch (NoSuchProviderException not_available) {
            throw new PeerGroupException("Requested KeyStore provider not available", not_available);
        }
        catch (KeyStoreException bad) {
            throw new PeerGroupException("KeyStore failure initializing KeyStoreManager", bad);
        }
        this.pseStore = new PSEConfig(store_manager, null);
        boolean pseInited = this.pseStore.isInitialized();
        try {
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            String override_str = jxtaRsrcs.getString("impl.membership.pse.autologin");
            if (null != override_str) {
                this.doAutoLogin = Boolean.valueOf(override_str);
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Adjusting autologin to " + this.doAutoLogin));
                }
            }
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring PSE Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPSE state : " + (pseInited ? "inited" : "new"));
            configInfo.append("\n\t\tAuto login : " + this.doAutoLogin);
            LOG.info((Object)configInfo);
        }
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] arg) {
        if (this.doAutoLogin) {
            Credential cred;
            block21: {
                char[] password;
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Attempting to automatically login to PSE");
                }
                if ((password = System.getProperty("net.jxta.tls.password", "").toCharArray()).length > 0) {
                    System.setProperty("net.jxta.tls.password", "");
                    try {
                        AuthenticationCredential authCred = new AuthenticationCredential(this.group, "StringAuthentication", null);
                        StringAuthenticator auth = (StringAuthenticator)this.apply(authCred);
                        auth.setAuth1_KeyStorePassword(password);
                        auth.setAuth2Identity(this.group.getPeerID());
                        auth.setAuth3_IdentityPassword(password);
                        if (auth.isReadyForJoin()) {
                            this.join(auth);
                        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Property based authentication failed.");
                        }
                    }
                    catch (PeerGroupException failed) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Property based authentication failed.", (Throwable)failed);
                        }
                    }
                    catch (ProtocolNotSupportedException failed) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block21;
                        LOG.warn((Object)"Property based authentication failed.", (Throwable)failed);
                    }
                }
            }
            if (null == (cred = this.getDefaultCredential())) {
                try {
                    AuthenticationCredential authCred = new AuthenticationCredential(this.group, "InteractiveAuthentication", null);
                    InteractiveAuthenticator auth = (InteractiveAuthenticator)this.apply(authCred);
                    if (null != auth && auth.interact() && auth.isReadyForJoin()) {
                        this.join(auth);
                    } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Interactive authentication failed.");
                    }
                }
                catch (PeerGroupException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Interactive authentication failed.", (Throwable)failed);
                    }
                }
                catch (ProtocolNotSupportedException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Interactive authentication failed.", (Throwable)failed);
                    }
                }
            }
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Auto login disabled");
        }
        return 0;
    }

    public void stopApp() {
        this.resign();
    }

    public Authenticator apply(AuthenticationCredential application) throws ProtocolNotSupportedException {
        String method = application.getMethod();
        if ("StringAuthentication".equals(method)) {
            if (this.pseStore.isInitialized()) {
                return new StringAuthenticator(this, application);
            }
            return new StringAuthenticator(this, application, this.config.getCertificate(), this.config.getEncryptedPrivateKey());
        }
        if ("DialogAuthentication".equals(method) || "InteractiveAuthentication".equals(method) || null == method) {
            if (this.pseStore.isInitialized()) {
                return new DialogAuthenticator(this, application);
            }
            return new DialogAuthenticator(this, application, this.config.getCertificate(), this.config.getEncryptedPrivateKey());
        }
        throw new ProtocolNotSupportedException("Authentication method not recognized");
    }

    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultCredential(PSECredential newDefault) {
        PSECredential oldDefault = this.defaultCredential;
        PSEMembershipService pSEMembershipService = this;
        synchronized (pSEMembershipService) {
            this.defaultCredential = newDefault;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("New Default credential : " + newDefault));
        }
        try {
            PeerAdvertisement peeradv = this.group.getPeerAdvertisement();
            if (null != newDefault) {
                XMLDocument paramDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                net.jxta.impl.protocol.Certificate peerCerts = new net.jxta.impl.protocol.Certificate();
                peerCerts.setCertificates(newDefault.getCertificateChain());
                XMLDocument peerCertsAsDoc = (XMLDocument)peerCerts.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(paramDoc, paramDoc, peerCertsAsDoc, "RootCert");
                peeradv.putServiceParam(PeerGroup.peerGroupClassID, paramDoc);
            } else {
                peeradv.removeServiceParam(PeerGroup.peerGroupClassID);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.support.firePropertyChange("defaultCredential", oldDefault, newDefault);
    }

    public Enumeration getCurrentCredentials() {
        List<Object> credList = Arrays.asList(this.principals.toArray());
        return Collections.enumeration(credList);
    }

    public Enumeration getAuthCredentials() {
        List<Object> credList = Arrays.asList(this.authCredentials.toArray());
        return Collections.enumeration(credList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential join(Authenticator authenticated) throws PeerGroupException {
        PSECredential newCred;
        char[] key_password;
        block30: {
            if (this != authenticated.getSourceService()) {
                throw new ClassCastException("This is not my authenticator!");
            }
            if (!authenticated.isReadyForJoin()) {
                throw new PeerGroupException("Not ready to join!");
            }
            char[] store_password = null;
            key_password = null;
            try {
                boolean pseInited;
                if (!(authenticated instanceof StringAuthenticator)) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("I dont know how to deal with this authenticator " + authenticated));
                    }
                    throw new PeerGroupException("I dont know how to deal with this authenticator");
                }
                StringAuthenticator auth = (StringAuthenticator)authenticated;
                store_password = auth.getAuth1_KeyStorePassword();
                ID identity = auth.getAuth2Identity();
                key_password = auth.getAuth3_IdentityPassword();
                if (null != store_password) {
                    this.pseStore.setKeyStorePassword(store_password);
                }
                if (!(pseInited = this.pseStore.isInitialized())) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)"Creating new PSE key store");
                    }
                    try {
                        Certificate[] seed_cert = this.config.getCertificateChain();
                        if (null == seed_cert) {
                            throw new IOException("Could not read root certificate chain");
                        }
                        PrivateKey seedPrivKey = this.config.getPrivateKey(key_password);
                        if (null == seedPrivKey) {
                            throw new IOException("Could not read private key");
                        }
                        this.pseStore.initialize();
                        this.pseStore.setKey(identity, seed_cert, seedPrivKey, key_password);
                    }
                    catch (IOException failed) {
                        LOG.fatal((Object)"Could not create PSE!", (Throwable)failed);
                        throw new PeerGroupException("Could not create PSE!", failed);
                    }
                    catch (KeyStoreException failed) {
                        LOG.fatal((Object)"Could not create PSE!", (Throwable)failed);
                        throw new PeerGroupException("Could not create PSE!", failed);
                    }
                }
                try {
                    X509Certificate[] certList = this.pseStore.getTrustedCertificateChain(identity);
                    if (null == certList) {
                        certList = new X509Certificate[]{this.pseStore.getTrustedCertificate(identity)};
                    }
                    PrivateKey privateKey = this.pseStore.getKey(identity, key_password);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    CertPath certs = cf.generateCertPath(Arrays.asList(certList));
                    newCred = new PSECredential(this, identity, certs, privateKey);
                    PSEMembershipService pSEMembershipService = this;
                    synchronized (pSEMembershipService) {
                        this.principals.add(newCred);
                        this.authCredentials.add(authenticated.getAuthenticationCredential());
                    }
                }
                catch (IOException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Could not create credential.", (Throwable)failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                catch (KeyStoreException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Could not create credential.", (Throwable)failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                catch (CertificateException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Could not create credential.", (Throwable)failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                Object var14_19 = null;
                if (null == store_password) break block30;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                if (null != store_password) {
                    Arrays.fill(store_password, '\u0000');
                }
                if (null != key_password) {
                    Arrays.fill(key_password, '\u0000');
                }
                throw throwable;
            }
            Arrays.fill(store_password, '\u0000');
        }
        if (null != key_password) {
            Arrays.fill(key_password, '\u0000');
        }
        if (null == this.getDefaultCredential()) {
            this.setDefaultCredential(newCred);
        }
        this.support.firePropertyChange("addCredential", null, newCred);
        return newCred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resign() {
        Iterator<Object> eachCred = Arrays.asList(this.principals.toArray()).iterator();
        PSEMembershipService pSEMembershipService = this;
        synchronized (pSEMembershipService) {
            this.principals.clear();
            this.authCredentials.clear();
        }
        this.setDefaultCredential(null);
        while (eachCred.hasNext()) {
            PSECredential aCred = (PSECredential)eachCred.next();
            aCred.setValid(false);
        }
    }

    public Credential makeCredential(Element element2) {
        return new PSECredential(this, element2);
    }

    public PSEConfig getPSEConfig() {
        return this.pseStore;
    }
}

