/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.KeyStoreManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSEConfig {
    private static final transient Logger LOG = Logger.getLogger((String)PSEConfig.class.getName());
    private KeyStoreManager keystore_manager;
    private char[] keystore_password = null;

    public PSEConfig(KeyStoreManager storeManager, char[] password) {
        this.keystore_manager = storeManager;
        this.setKeyStorePassword(password);
    }

    public final void setKeyStorePassword(char[] store_password) {
        if (null != this.keystore_password) {
            Arrays.fill(this.keystore_password, '\u0000');
        }
        this.keystore_password = (char[])(null == store_password ? null : (char[])store_password.clone());
    }

    protected void finalize() throws Throwable {
        if (null != this.keystore_password) {
            Arrays.fill(this.keystore_password, '\u0000');
        }
        super.finalize();
    }

    public boolean isInitialized() {
        try {
            if (this.keystore_password != null) {
                return this.keystore_manager.isInitialized(this.keystore_password);
            }
            return this.keystore_manager.isInitialized();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Initializing new KeyStore...");
        }
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            try {
                if (this.keystore_manager.isInitialized(this.keystore_password)) {
                    return;
                }
                this.keystore_manager.createKeyStore(this.keystore_password);
            }
            catch (KeyStoreException failed) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Something failed", (Throwable)failed);
                }
                this.keystore_manager.eraseKeyStore();
                throw failed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erase() throws IOException {
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            this.keystore_manager.eraseKeyStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() {
        Exception failure;
        try {
            KeyStoreManager keyStoreManager = this.keystore_manager;
            synchronized (keyStoreManager) {
                KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
                return store;
            }
        }
        catch (KeyStoreException failed) {
            failure = failed;
        }
        catch (IOException failed) {
            failure = failed;
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Failure checking password : " + failure));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    boolean validPasswd(ID id, char[] store_password, char[] key_password) {
        Exception failure;
        try {
            KeyStoreManager keyStoreManager = this.keystore_manager;
            synchronized (keyStoreManager) {
                void var6_9;
                KeyStore store;
                if (null != store_password) {
                    store = this.keystore_manager.loadKeyStore(store_password);
                } else if (null != this.keystore_password) {
                    store = this.keystore_manager.loadKeyStore(this.keystore_password);
                } else {
                    throw new UnrecoverableKeyException("KeyStore password not initialized");
                }
                String alias = id.toString();
                Key key = var6_9.getKey(alias, key_password);
                return null != key;
            }
        }
        catch (UnrecoverableKeyException failed) {
            failure = failed;
        }
        catch (NoSuchAlgorithmException failed) {
            failure = failed;
        }
        catch (KeyStoreException failed) {
            failure = failed;
        }
        catch (IOException failed) {
            failure = failed;
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Failure checking password : " + failure));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID[] getTrustedCertsList() throws KeyStoreException, IOException {
        ArrayList<ID> trustedCertsList = new ArrayList<ID>();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            Enumeration<String> eachAlias = store.aliases();
            while (eachAlias.hasMoreElements()) {
                String anAlias = eachAlias.nextElement();
                if (!store.isCertificateEntry(anAlias) && !store.isKeyEntry(anAlias)) continue;
                try {
                    URI id = new URI(anAlias);
                    trustedCertsList.add(IDFactory.fromURI(id));
                }
                catch (URISyntaxException badID) {}
            }
            return trustedCertsList.toArray(new ID[trustedCertsList.size()]);
        }
    }

    public ID[] getKeysList() throws KeyStoreException, IOException {
        return this.getKeysList(this.keystore_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ID[] getKeysList(char[] store_password) throws KeyStoreException, IOException {
        ArrayList<ID> keyedRootsList = new ArrayList<ID>();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(store_password);
            Enumeration<String> eachAlias = store.aliases();
            while (eachAlias.hasMoreElements()) {
                String anAlias = eachAlias.nextElement();
                if (!store.isKeyEntry(anAlias)) continue;
                try {
                    URI id = new URI(anAlias);
                    keyedRootsList.add(IDFactory.fromURI(id));
                }
                catch (URISyntaxException badID) {}
            }
            return keyedRootsList.toArray(new ID[keyedRootsList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getTrustedCertificateID(X509Certificate cert) throws KeyStoreException, IOException {
        String anAlias = null;
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            anAlias = store.getCertificateAlias(cert);
        }
        if (null == anAlias) {
            return null;
        }
        try {
            URI id = new URI(anAlias);
            return IDFactory.fromURI(id);
        }
        catch (URISyntaxException badID) {
            return null;
        }
    }

    public X509Certificate getTrustedCertificate(ID id) throws KeyStoreException, IOException {
        return this.getTrustedCertificate(id, this.keystore_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate getTrustedCertificate(ID id, char[] store_password) throws KeyStoreException, IOException {
        String alias = id.toString();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(store_password);
            if (!store.containsAlias(alias)) {
                return null;
            }
            return (X509Certificate)store.getCertificate(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getTrustedCertificateChain(ID id) throws KeyStoreException, IOException {
        String alias = id.toString();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            if (!store.containsAlias(alias)) {
                return null;
            }
            Certificate[] certs = store.getCertificateChain(alias);
            if (null == certs) {
                return null;
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length];
            System.arraycopy(certs, 0, x509certs, 0, certs.length);
            return x509certs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getKey(ID id, char[] key_password) throws KeyStoreException, IOException {
        String alias = id.toString();
        try {
            KeyStoreManager keyStoreManager = this.keystore_manager;
            synchronized (keyStoreManager) {
                KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
                if (!store.containsAlias(alias) || !store.isKeyEntry(alias)) {
                    return null;
                }
                return (PrivateKey)store.getKey(alias, key_password);
            }
        }
        catch (NoSuchAlgorithmException failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Something failed", (Throwable)failed);
            }
            KeyStoreException failure = new KeyStoreException("Something Failed");
            failure.initCause(failed);
            throw failure;
        }
        catch (UnrecoverableKeyException failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Key password failure", (Throwable)failed);
            }
            KeyStoreException failure = new KeyStoreException("Key password failure");
            failure.initCause(failed);
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrustedCertificate(ID id, X509Certificate cert) throws KeyStoreException, IOException {
        String alias = id.toString();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            store.setCertificateEntry(alias, cert);
            this.keystore_manager.saveKeyStore(store, this.keystore_password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(ID id, Certificate[] certchain, PrivateKey key, char[] key_password) throws KeyStoreException, IOException {
        String alias = id.toString();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            store.setKeyEntry(alias, key, key_password, certchain);
            this.keystore_manager.saveKeyStore(store, this.keystore_password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erase(ID id) throws KeyStoreException, IOException {
        String alias = id.toString();
        KeyStoreManager keyStoreManager = this.keystore_manager;
        synchronized (keyStoreManager) {
            KeyStore store = this.keystore_manager.loadKeyStore(this.keystore_password);
            store.deleteEntry(alias);
            this.keystore_manager.saveKeyStore(store, this.keystore_password);
        }
    }
}

